package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.*;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import org.apache.log4j.Logger;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

@RestController
@RequestMapping(value={"/monitor", "/funder", "/project", "/ri", "/organization"})
@CrossOrigin(origins = "*")
public class MonitorController {
    private final Logger log = Logger.getLogger(this.getClass());
//
//    @Autowired
//    private LayoutService layoutService;

    @Autowired
    private PortalService portalService;

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public PortalResponse updatePortal(@RequestBody Portal portal) {
        PortalResponse portalResponse = portalService.updatePortal(portal);

//        String old_pid = portalResponse.getPid();
//        String new_pid = portal.getPid();
//        if(!old_pid.equals(new_pid)) {
//            layoutService.updatePid(old_pid, new_pid);
//        }

        return portalResponse;
    }

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public PortalResponse insertPortal(@RequestBody Portal portal) {
        PortalResponse portalResponse = portalService.insertPortal(portal);
        return portalResponse;
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public Boolean deletePortals(@RequestBody List<String> portals) {
        for (String id: portals) {
            String pid = portalService.deletePortal(id);
//            layoutService.deleteByPid(pid);
        }

        return true;
    }

//    @RequestMapping(value = "/{pid}/layout", method = RequestMethod.GET)
//    public Layout getLayoutForCommunity(@PathVariable(value = "pid") String pid) {
//        return layoutService.findByPid(pid);
//    }
//
//    @RequestMapping(value = "/{pid}/layout", method = RequestMethod.POST)
//    public Layout updateLayoutForCommunity(@PathVariable(value = "pid") String pid, @RequestBody Layout layout) {
//        return layoutService.save(layout);
//    }

}

