package eu.dnetlib.uoamonitorservice.controllers;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import eu.dnetlib.uoamonitorservice.configuration.GlobalVars;
import eu.dnetlib.uoamonitorservice.configuration.mongo.MongoConnection;
import eu.dnetlib.uoamonitorservice.configuration.properties.MongoConfig;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@RestController
@CrossOrigin(origins = "*")
public class MonitorServiceCheckDeployController {
    private final Logger log = Logger.getLogger(this.getClass());

    @Autowired
    private MongoConnection mongoConnection;

    @Autowired
    private MongoConfig mongoConfig;

    @Autowired
    private GlobalVars globalVars;

    @RequestMapping(value = {"", "/health_check"}, method = RequestMethod.GET)
    public String hello() {
        log.debug("Hello from uoa-monitor-service!");
        return "Hello from uoa-monitor-service!";
    }

    @PreAuthorize("hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value = "/health_check/advanced", method = RequestMethod.GET)
    public Map<String, String> checkEverything() {
        Map<String, String> response = new HashMap<>();

        MongoTemplate mt = mongoConnection.getMongoTemplate();
        DBObject ping = new BasicDBObject("ping", "1");
        try {
            CommandResult answer = mt.getDb().command(ping);
            response.put("Mongo try: error", answer.getErrorMessage());
        } catch (Exception e) {
            response.put("Mongo catch: error", e.getMessage());
        }

        response.put("monitorservice.mongodb.database", mongoConfig.getDatabase());
        response.put("monitorservice.mongodb.host", mongoConfig.getHost());
        response.put("monitorservice.mongodb.port", mongoConfig.getPort()+"");
        response.put("monitorservice.mongodb.username", mongoConfig.getUsername() == null ? null : "[unexposed value]");
        response.put("monitorservice.mongodb.password", mongoConfig.getPassword() == null ? null : "[unexposed value]");
//        response.put("Define also", "monitorservice.mongodb.username, monitorservice.mongodb.password");

        if(globalVars.date != null) {
            response.put("Date of deploy", globalVars.date.toString());
        }
        if(globalVars.getBuildDate() != null) {
            response.put("Date of build", globalVars.getBuildDate());
        }
        if(globalVars.getVersion() != null) {
            response.put("Version", globalVars.getVersion());
        }

        return response;
    }
}
