package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.handlers.utils.RolesUtils;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoamonitorservice.dao.*;
import eu.dnetlib.uoamonitorservice.entities.*;
import eu.dnetlib.uoamonitorservice.handlers.EntityNotFoundException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.ForbiddenException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.*;

@RestController
@CrossOrigin(origins = "*")
public class StakeholderController {
    private final Logger log = Logger.getLogger(this.getClass());

    @Autowired
    private RolesUtils rolesUtils;

    @Autowired
    private StakeholderDAO stakeholderDAO;

    @Autowired
    private TopicDAO topicDAO;

    @Autowired
    private CategoryDAO categoryDAO;

    @Autowired
    private SubCategoryDAO subCategoryDAO;

    @Autowired
    private SectionDAO sectionDAO;

    @Autowired
    private IndicatorDAO indicatorDAO;

    @Autowired
    private TopicController topicController;

    @Autowired
    private PortalService portalService;

    @PreAuthorize("isAuthenticated()")
    @RequestMapping(value = "/stakeholder/alias", method = RequestMethod.GET)
    public List<String> getAllReservedStakeholderAlias() {
//        log.debug("get all stakeholder reserved alias-es");
        List<String> stakeholderAlias = new ArrayList<>();

        List<Stakeholder> stakeholders = stakeholderDAO.findAll();
        if(stakeholders != null) {
            stakeholders.forEach(stakeholder -> {
                stakeholderAlias.add(stakeholder.getAlias());
            });
        }
        stakeholderAlias.add( "all");
        stakeholderAlias.add("default");
        stakeholderAlias.add("alias");

        return stakeholderAlias;
    }

//    @PreAuthorize("isAuthenticated()")
    @PreAuthorize("hasAnyAuthority(" +
        "@AuthorizationService.PORTAL_ADMIN, " +
        "@AuthorizationService.curator(#stakeholderFull.getType()))")
    @RequestMapping(value = "/build-stakeholder", method = RequestMethod.POST)
    public Stakeholder<Topic<Category<SubCategory<Section<Indicator>>>>> buildFullStakeholder(@RequestBody Stakeholder<Topic<Category<SubCategory<Section<Indicator>>>>> stakeholderFull) {
        log.debug("build stakeholder");
        log.debug("Alias: "+stakeholderFull.getAlias());

        Stakeholder<String> stakeholder = new Stakeholder<>(stakeholderFull);

        List<String> topics = new ArrayList<>();
        List<Topic<Category<SubCategory<Section<Indicator>>>>> topicsFull = new ArrayList<>();
        for(Topic topic : stakeholderFull.getTopics()) {
            Topic<Category<SubCategory<Section<Indicator>>>> topicFull = topicController.buildTopic(topic);
            topicsFull.add(topicFull);
            topics.add(topicFull.getId());
        }
        stakeholderFull.setTopics(topicsFull);
        stakeholder.setTopics(topics);

        Date date = new Date();
        stakeholder.setCreationDate(date);
        stakeholder.setUpdateDate(date);

        stakeholderFull.setCreationDate(date);
        stakeholderFull.setUpdateDate(date);

        Stakeholder<String> stakeholderSaved = stakeholderDAO.save(stakeholder);
        stakeholderFull.setId(stakeholderSaved.getId());

        Portal portal = portalService.getPortal(stakeholderFull.getAlias());
        if(portal == null) {
            portal = new Portal();
            portal.setPid(stakeholderFull.getAlias());
            portal.setName(stakeholderFull.getName());
            portal.setType(stakeholderFull.getType());
            portalService.insertPortal(portal);
        }

        return stakeholderFull;
        //return null;
    }

    public Stakeholder setFullEntities(Stakeholder<String> stakeholder, List<String> roles) {
        boolean addAll = false;
        boolean addPublicAndRestricted = false;

//        if(roles == null
//                || roles.contains(authorizationService.PORTAL_ADMIN)
//                || roles.contains(authorizationService.curator(stakeholder.getType()))
//                || roles.contains(authorizationService.manager(stakeholder.getType(), stakeholder.getAlias()))) {
        if(rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
            //if(visibility == null || visibility == (Visibility.PRIVATE)) {
                addAll = true;
            //}
            //if(visibility == null || visibility == (Visibility.PRIVATE) || visibility == (Visibility.RESTRICTED)) {
                addPublicAndRestricted = true;
            //}
//        } else if(roles != null && roles.contains(authorizationService.member(stakeholder.getType(), stakeholder.getAlias()))) {
        } else if(rolesUtils.isMember(roles, stakeholder.getType(), stakeholder.getAlias())) {
            //if(visibility == null || visibility == (Visibility.PRIVATE) || visibility == (Visibility.RESTRICTED)) {
                addPublicAndRestricted = true;
            //}
        }

        Stakeholder<Topic> stakeholderFull = new Stakeholder<>(stakeholder);

        List<Topic> topics = new ArrayList<>();

        for (String topicId: (List<String>)stakeholder.getTopics()) {
            Topic<String> topic = topicDAO.findById(topicId);
            if(topic == null) {
                // EXCEPTION - Topic not found
                throw new EntityNotFoundException("Get stakeholder: Topic with id: "+topicId+" not found (topic exists in stakeholder: "+stakeholder.getId()+")");
            }

            if((!addAll && topic.getVisibility() == Visibility.PRIVATE)
                    || (!addPublicAndRestricted && topic.getVisibility() == Visibility.RESTRICTED)) {
                continue;
            }

            Topic<Category> topicFull = new Topic<Category>(topic);

            List<Category> categories = new ArrayList<>();

            for(String categoryId : topic.getCategories()) {
                Category<String> category = categoryDAO.findById(categoryId);
                if(category == null) {
                    // EXCEPTION - Category not found
                    throw new EntityNotFoundException("Get stakeholder: Category with id: "+categoryId+" not found (category exists in topic: "+topicId+")");
                }

                if((!addAll && category.getVisibility() == Visibility.PRIVATE)
                        || (!addPublicAndRestricted && category.getVisibility() == Visibility.RESTRICTED)) {
                    continue;
                }

                Category<SubCategory> categoryFull = new Category<SubCategory>(category);

                List<SubCategory> subCategories = new ArrayList<>();

                for(String subCategoryId : category.getSubCategories()) {
                    SubCategory<String> subCategory = subCategoryDAO.findById(subCategoryId);
                    if(subCategory == null) {
                        // EXCEPTION - SubCategory not found
                        throw new EntityNotFoundException("Get stakeholder: SubCategory with id: "+subCategoryId+" not found (subCategory exists in category: "+categoryId+")");
                    }

                    if((!addAll && subCategory.getVisibility() == Visibility.PRIVATE)
                            || (!addPublicAndRestricted && subCategory.getVisibility() == Visibility.RESTRICTED)) {
                        continue;
                    }

                    SubCategory subCategoryFull = new SubCategory<Section<Indicator>>(subCategory);

                    List<Section> sectionsCharts = new ArrayList<>();

                    for(String sectionId : subCategory.getCharts()) {
                        sectionsCharts.add(getSectionFull(sectionId, subCategoryId, addAll, addPublicAndRestricted));
                    }
                    subCategoryFull.setCharts(sectionsCharts);

                    List<Section> sectionsNumbers = new ArrayList<>();

                    for(String sectionId : subCategory.getNumbers()) {
                        sectionsNumbers.add(getSectionFull(sectionId, subCategoryId, addAll, addPublicAndRestricted));
                    }
                    subCategoryFull.setNumbers(sectionsNumbers);

//                    List<Indicator> charts = new ArrayList<>();
//                    for(String indicatorId : subCategory.getCharts()) {
//                        Indicator indicator = indicatorDAO.findById(indicatorId);
//                        if(indicator == null) {
//                            // EXCEPTION - Indicator not found
//                            throw new EntityNotFoundException("Get stakeholder: Indicator with id: "+indicatorId+" not found (indicator exists in subCategory: "+subCategoryId+")");
//                        }
//                        charts.add(indicator);
//                    }
//                    subCategoryFull.setCharts(charts);
//
//                    List<Indicator> numbers = new ArrayList<>();
//                    for (String indicatorId : subCategory.getNumbers()) {
//                        Indicator indicator = indicatorDAO.findById(indicatorId);
//                        if (indicator == null) {
//                            // EXCEPTION - Indicator not found
//                            throw new EntityNotFoundException("Get stakeholder: Indicator with id: " + indicatorId + " not found (indicator exists in subCategory: " + subCategoryId + ")");
//                        }
//                        numbers.add(indicator);
//                    }
//                    subCategoryFull.setNumbers(numbers);

                    subCategories.add(subCategoryFull);
                }

                categoryFull.setSubCategories(subCategories);
                categories.add(categoryFull);
            }

            topicFull.setCategories(categories);
            topics.add(topicFull);
        }

        stakeholderFull.setTopics(topics);
        return stakeholderFull;
    }

//    private SubCategory setFullSubcategory(SubCategory subCategory) {
//        SubCategory subCategoryFull = new SubCategory<Section<Indicator>>(subCategory);
//
//        List<Section> sectionsCharts = new ArrayList<>();
//
//        for(String sectionId : subCategory.getCharts()) {
//            sectionsCharts.add(getSectionFull(sectionId, subCategoryId, addAll, addPublicAndRestricted));
//        }
//        subCategoryFull.setCharts(sectionsCharts);
//
//        List<Section> sectionsNumbers = new ArrayList<>();
//
//        for(String sectionId : subCategory.getNumbers()) {
//            sectionsNumbers.add(getSectionFull(sectionId, subCategoryId, addAll, addPublicAndRestricted));
//        }
//        subCategoryFull.setNumbers(sectionsNumbers);
//    }

    private Section getSectionFull(String sectionId, String subCategoryId, boolean addAll, boolean addPublicAndRestricted) {
        Section<String> section = sectionDAO.findById(sectionId);
        if (section == null) {
            // EXCEPTION - Section not found
            throw new EntityNotFoundException("Get stakeholder: Section with id: " + sectionId + " not found (section exists in subCategory: " + subCategoryId + ")");
        }

        Section sectionFull = new Section<Indicator>(section);

        List<Indicator> indicators = new ArrayList<>();
        for (String indicatorId : section.getIndicators()) {
            Indicator indicator = indicatorDAO.findById(indicatorId);
            if (indicator == null) {
                // EXCEPTION - Indicator not found
                throw new EntityNotFoundException("Get stakeholder: Indicator with id: " + indicatorId + " not found (indicator exists in section: " + sectionId + ")");
            }

            if((!addAll && indicator.getVisibility() == Visibility.PRIVATE)
                    || (!addPublicAndRestricted && indicator.getVisibility() == Visibility.RESTRICTED)) {
                continue;
            }

            indicators.add(indicator);
        }
        sectionFull.setIndicators(indicators);

        return sectionFull;
    }

    @PreAuthorize("hasAnyAuthority(" +
            "@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value = "/stakeholder/all", method = RequestMethod.GET)
    public List<Stakeholder> getAllStakeholders(@RequestParam(required = false) String type) {
//        log.debug("get all stakeholders" + (type != null ? " with type: "+type : ""));

        List<Stakeholder> stakeholders;
        if(type == null) {
            stakeholders = stakeholderDAO.findAll();
        } else {
            stakeholders = stakeholderDAO.findByType(type);
        }

        List<Stakeholder> stakeholdersFull = new ArrayList<>();
        for(Stakeholder stakeholder : stakeholders) {
            List<String> roles = rolesUtils.getRoles();
            stakeholdersFull.add(this.setFullEntities(stakeholder, roles));
        }

        return stakeholdersFull;
    }

    @PreAuthorize("isAuthenticated()")
    @RequestMapping(value = "/stakeholder/default", method = RequestMethod.GET)
    public List<Stakeholder> getAllDefaultStakeholders(@RequestParam(required = false) String type) {
//        log.debug("get all default stakeholders" + (type != null ? " with type: "+type : ""));

        List<Stakeholder> stakeholders;
        if(type == null) {
            stakeholders = stakeholderDAO.findByDefaultId(null);
        } else {
            stakeholders = stakeholderDAO.findByDefaultIdAndType(null, type);
        }

        List<Stakeholder> stakeholdersFull = new ArrayList<>();

        // Remove stakeholders for which i do not have authority
        if(stakeholders != null && stakeholders.size() > 0) {
            List<String> roles = rolesUtils.getRoles();
//            log.debug("ROLES: ");
//            roles.forEach(role -> log.debug(role));
//
//            if (roles.contains(authorizationService.PORTAL_ADMIN)) {
            if (rolesUtils.isPortalAdmin(roles)) {
                for(Stakeholder stakeholder : stakeholders) {
                    stakeholdersFull.add(this.setFullEntities(stakeholder, roles));
                }
                return stakeholdersFull;
            }

            Iterator<Stakeholder> stakeholderIterator = stakeholders.iterator();
            while(stakeholderIterator.hasNext()) {
                Stakeholder stakeholder = stakeholderIterator.next();

//                if(roles.contains(authorizationService.curator(stakeholder.getType()))) {
                if(rolesUtils.isCurator(roles, stakeholder.getType())) {
                    stakeholdersFull.add(this.setFullEntities(stakeholder, roles));
                    continue;
                }
                stakeholderIterator.remove();
            }
        }

        return stakeholdersFull;
    }

    @RequestMapping(value = "/stakeholder", method = RequestMethod.GET)
    public List<Stakeholder> getAllRealStakeholders(@RequestParam(required = false) String type,
                                                    @RequestParam(required = false) String defaultId) {
//        log.debug("get all NOT default stakeholders" + (type != null ? " with type: "+type : ""));

        List<Stakeholder> stakeholders;
        if(type != null && defaultId != null) {
            stakeholders = stakeholderDAO.findByDefaultIdAndType(defaultId, type);
        } else if(defaultId != null) {
            stakeholders = stakeholderDAO.findByDefaultId(defaultId);
        } else if(type != null) {
            stakeholders = stakeholderDAO.findByDefaultIdNotAndType(null, type);
        } else {
            stakeholders = stakeholderDAO.findByDefaultIdNot(null);
        }

        //List<Stakeholder> stakeholdersFull = new ArrayList<>();

        if(stakeholders != null && stakeholders.size() > 0) {
//            List<String> roles = authorizationService.getRoles();
            List<String> roles = rolesUtils.getRoles();

//            if (roles.contains(authorizationService.PORTAL_ADMIN)) {
            if (rolesUtils.isPortalAdmin(roles)) {
//                for(Stakeholder stakeholder : stakeholders) {
//                    stakeholdersFull.add(this.setFullEntities(stakeholder));
//                }
//                return stakeholdersFull;
                return stakeholders;
            }

            Iterator<Stakeholder> stakeholderIterator = stakeholders.iterator();
            while(stakeholderIterator.hasNext()) {
                Stakeholder stakeholder = stakeholderIterator.next();

//                if(roles.contains(authorizationService.curator(stakeholder.getType()))
//                        || roles.contains(authorizationService.manager(stakeholder.getType(), stakeholder.getAlias()))
//                        || stakeholder.getVisibility() == Visibility.PUBLIC
//                        || (stakeholder.getVisibility() == Visibility.RESTRICTED && roles.contains(authorizationService.member(stakeholder.getType(), stakeholder.getAlias())))) {
                if(rolesUtils.isCurator(roles, stakeholder.getType())
                        || rolesUtils.isManager(roles, stakeholder.getType(), stakeholder.getAlias())
                        || stakeholder.getVisibility() == Visibility.PUBLIC
                        || stakeholder.getVisibility() == Visibility.RESTRICTED) {
//                        || (stakeholder.getVisibility() == Visibility.RESTRICTED && rolesUtils.isMember(roles, stakeholder.getType(), stakeholder.getAlias()))) {
                    //stakeholdersFull.add(this.setFullEntities(stakeholder));
                    continue;
                }
                stakeholderIterator.remove();
            }
        }

//        log.debug(new Date());

//        return stakeholdersFull;
        return stakeholders;
    }

    @PreAuthorize("isAuthenticated()")
    @RequestMapping(value = "/my-stakeholder", method = RequestMethod.GET)
    public List<Stakeholder> getMyRealStakeholders(@RequestParam(required = false) String type) {
//        log.debug("get my NOT default stakeholders" + (type != null ? " with type: "+type : ""));

        List<Stakeholder> stakeholders;
        if(type == null) {
            stakeholders = stakeholderDAO.findByDefaultIdNot(null);
        } else {
            stakeholders = stakeholderDAO.findByDefaultIdNotAndType(null, type);
        }

        List<Stakeholder> stakeholdersFull = new ArrayList<>();

        if(stakeholders != null && stakeholders.size() > 0) {
//            List<String> roles = authorizationService.getRoles();
            List<String> roles = rolesUtils.getRoles();
//            log.debug("ROLES: ");
//            roles.forEach(role -> log.debug(role));

//            if (roles.contains(authorizationService.PORTAL_ADMIN)) {
            if (rolesUtils.isPortalAdmin(roles)) {
//                for(Stakeholder stakeholder : stakeholders) {
//                    stakeholdersFull.add(this.setFullEntities(stakeholder, roles));
//                }
//                return stakeholdersFull;
                return stakeholders;
            }

            Iterator<Stakeholder> stakeholderIterator = stakeholders.iterator();
            while(stakeholderIterator.hasNext()) {
                Stakeholder stakeholder = stakeholderIterator.next();

//                if(roles.contains(authorizationService.curator(stakeholder.getType()))
//                        || roles.contains(authorizationService.manager(stakeholder.getType(), stakeholder.getAlias()))) {
                if(rolesUtils.isCurator(roles, stakeholder.getType())
                        || rolesUtils.isManager(roles, stakeholder.getType(), stakeholder.getAlias())) {
                    //stakeholdersFull.add(this.setFullEntities(stakeholder, roles));
                    continue;
                } else {
                    stakeholderIterator.remove();
                }
            }
        }

//        log.debug(new Date());

        return stakeholders;
    }

    @RequestMapping(value = "/stakeholder/{alias}", method = RequestMethod.GET)
    public Stakeholder getStakeholder(@PathVariable("alias") String alias) {
//        log.debug("get stakeholder: "+alias);

        Stakeholder<String> stakeholder = stakeholderDAO.findByAlias(alias);
        if(stakeholder == null) {
            // EXCEPTION - Stakeholder not found
            throw new EntityNotFoundException("Get stakeholder: Stakeholder with alias: "+alias+" not found");
        }

//        List<String> roles = authorizationService.getRoles();
        List<String> roles = rolesUtils.getRoles();

        if(stakeholder.getDefaultId() == null && !rolesUtils.isLoggedIn(roles)) {
            // EXCEPTION - Unauthorized
            throw new AccessDeniedException("Get stakeholder: You are not authorized (not logged in) to access stakeholder with alias: "+alias);
        }
        if(stakeholder.getDefaultId() == null && !rolesUtils.hasCreateAndDeleteAuthority(roles, stakeholder.getType())) {
            // EXCEPTION - Access denied
            throw new ForbiddenException("Get stakeholder: You are not authorized to access stakeholder with alias: "+alias);
        }

        if((stakeholder.getVisibility() == Visibility.PRIVATE && !rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())
                || (stakeholder.getVisibility() == Visibility.RESTRICTED && !rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias()) && !rolesUtils.isMember(roles, stakeholder.getType(), stakeholder.getAlias())))) {
//            // EXCEPTION - Access denied
//            throw new ForbiddenException("Get stakeholder: You are not authorized to get stakeholder with alias: "+alias);
            List<String> topicsEmpty = stakeholder.getTopics();
            topicsEmpty.clear();
            stakeholder.setTopics(topicsEmpty);
            stakeholder.setVisibility(Visibility.PRIVATE);
            return stakeholder;
        }

        return this.setFullEntities(stakeholder, roles);
    }

//    @PreAuthorize("isAuthenticated()")
    @PreAuthorize("hasAnyAuthority("
        + "@AuthorizationService.PORTAL_ADMIN, "
        + "@AuthorizationService.curator(#_stakeholder.getType()), "
        + "@AuthorizationService.manager(#_stakeholder.getType(), #_stakeholder.getAlias()) "
    + ")")
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public Stakeholder saveStakeholder(@RequestBody Stakeholder _stakeholder) {
        log.debug("save stakeholder");
        log.debug("Alias: "+_stakeholder.getAlias() + " - Id: "+_stakeholder.getId());

//        if(_stakeholder == null) {
//            log.debug("stakeholder null");
//            // EXCEPTION - Parameter for Stakeholder is not accepted
//        }

        Stakeholder<String> stakeholder = new Stakeholder<>(_stakeholder);

        Date date = new Date();
        stakeholder.setUpdateDate(date);

        List<String> topics = new ArrayList<>();

        // stakeholder does not exist in DB
        if(_stakeholder.getId() == null) {
            stakeholder.setCreationDate(date);

//            for(Topic topic : _stakeholder.getTopics()) {
//                topics.add(topic.getId());
//            }
        } else {
            Stakeholder<String> oldStakeholder = stakeholderDAO.findById(_stakeholder.getId());
            if(oldStakeholder == null) {
                // EXCEPTION - Stakeholder not found
                throw new EntityNotFoundException("save stakeholder: Stakeholder with id: "+_stakeholder.getId()+" not found");
            }
            for(String topicId : oldStakeholder.getTopics()) {
                Topic topic = topicDAO.findById(topicId);
                if (topic == null) {
                    // EXCEPTION - Topic not found
                    throw new EntityNotFoundException("Save stakeholder: Topic with id: "+topicId+" not found (topic exists in stakeholder: "+stakeholder.getId()+")");
                }
                topics.add(topic.getId());
            }
//            stakeholder.setTopics(topics);
//            _stakeholder = this.setFullEntities(stakeholder, rolesUtils.getRoles());
        }

        stakeholder.setTopics(topics);

        Stakeholder<String> stakeholderSaved = stakeholderDAO.save(stakeholder);
        _stakeholder.setId(stakeholderSaved.getId());
        _stakeholder.setCreationDate(stakeholderSaved.getCreationDate());
        _stakeholder.setUpdateDate(stakeholderSaved.getUpdateDate());

        topics = null;
        stakeholder = null;
        stakeholderSaved = null;

        return _stakeholder;
    }

    @PreAuthorize("isAuthenticated()")
    @RequestMapping(value = "/{stakeholderId}/delete", method = RequestMethod.DELETE)
    public boolean deleteStakeholder(@PathVariable("stakeholderId") String stakeholderId) {
        log.debug("delete stakeholder");
        log.debug("Id: "+stakeholderId);

        Stakeholder<String> stakeholder = stakeholderDAO.findById(stakeholderId);
        String pid = null;

        if(stakeholder != null) {
            pid = stakeholder.getAlias();
//            List<String> roles = authorizationService.getRoles();
            List<String> roles = rolesUtils.getRoles();

//            if(!roles.contains(authorizationService.PORTAL_ADMIN)
//                    && !roles.contains(authorizationService.curator(stakeholder.getType()))) {
            if(!rolesUtils.hasCreateAndDeleteAuthority(roles, stakeholder.getType())) {
                // EXCEPTION - Access denied
                throw new ForbiddenException("Delete stakeholder: You are not authorized to delete stakeholder with id: "+stakeholderId);
            }

//            for(String topicId : stakeholder.getTopics()) {
//                Topic<String> topic = topicDAO.findById(topicId);
//                if (topic == null) {
//                    // EXCEPTION - Topic not found
//                    throw new EntityNotFoundException("Delete stakeholder: Topic with id: "+topicId+" not found (topic exists in stakeholder: "+stakeholderId+")");
//                }
//
//                for (String categoryId : topic.getCategories()) {
//                    Category<String> category = categoryDAO.findById(categoryId);
//                    if (category == null) {
//                        // EXCEPTION - Category not found
//                        throw new EntityNotFoundException("Delete stakeholder: Category with id: "+categoryId+" not found (category exists in topic: "+topicId+")");
//                    }
//
//                    for (String subCategoryId : category.getSubCategories()) {
//                        SubCategory<String> subcategory = subCategoryDAO.findById(subCategoryId);
//                        if (subcategory == null) {
//                            // EXCEPTION - SubCategory not found
//                            throw new EntityNotFoundException("Delete stakeholder: SubCategory with id: "+subCategoryId+" not found (subcategory exists in category: "+categoryId+")");
//                        }
//
//                        for(String chartSectionId : subcategory.getCharts()) {
//                            Section<String> chartSection = sectionDAO.findById(chartSectionId);
//                            if (chartSection == null) {
//                                // EXCEPTION - Section not found
//                                throw new EntityNotFoundException("Delete topic: Section with id: "+chartSectionId+" not found (section exists in subcategory: "+subCategoryId+")");
//                            }
//
//                            for (String chartId : chartSection.getIndicators()) {
//                                indicatorDAO.delete(chartId);
//                            }
//                            subcategory.setCharts(null);
//                            sectionDAO.delete(chartSectionId);
//                        }
//
//                        for(String numberSectionId : subcategory.getNumbers()) {
//                            Section<String> numberSection = sectionDAO.findById(numberSectionId);
//                            if (numberSection == null) {
//                                // EXCEPTION - Section not found
//                                throw new EntityNotFoundException("Delete topic: Section with id: "+numberSectionId+" not found (section exists in subcategory: "+subCategoryId+")");
//                            }
//
//                            for (String numberId : numberSection.getIndicators()) {
//                                indicatorDAO.delete(numberId);
//                            }
//                            subcategory.setNumbers(null);
//                            sectionDAO.delete(numberSectionId);
//                        }
//
//                        subCategoryDAO.delete(subCategoryId);
//                    }
//                    category.setSubCategories(null);
//                    categoryDAO.delete(categoryId);
//                }
//                topic.setCategories(null);
//                topicDAO.delete(topicId);
//            }

            topicController.deleteTree(stakeholder);

            stakeholder.setTopics(null);
            stakeholderDAO.delete(stakeholderId);
            log.debug("Stakeholder deleted!");

            Portal portal = portalService.getPortal(pid);
            if(portal != null) {
                portalService.deletePortal(portal.getId());
            }
        } else {
            // EXCEPTION - Stakeholder not found
            throw new EntityNotFoundException("Delete stakeholder: Stakeholder with id: "+stakeholderId+" not found");
        }
        return true;
    }


//    @RequestMapping(value = "/{stakeholderId}/toggle-status", method = RequestMethod.POST)
//    public Boolean toggleStakeholderStatus(@PathVariable("stakeholderId") String stakeholderId) {
//        log.debug("toggle stakeholder status (isActive)");
//        log.debug("Stakeholder: "+stakeholderId);
//
//        Stakeholder stakeholder = stakeholderDAO.findById(stakeholderId);
//        if (stakeholder == null) {
//            // EXCEPTION - Stakeholder not found
//            throw new EntityNotFoundException("Toggle stakeholder status: Stakeholder with id: "+stakeholderId+" not found");
//        }
//        stakeholder.setIsActive(!stakeholder.getIsActive());
//
//        stakeholderDAO.save(stakeholder);
//        log.debug("Stakeholder toggled!");
//
//        return stakeholder.getIsActive();
//    }
//
//    @RequestMapping(value = "/{stakeholderId}/toggle-access", method = RequestMethod.POST)
//    public Boolean toggleStakeholderAccess(@PathVariable("stakeholderId") String stakeholderId) {
//        log.debug("toggle stakeholder access (isPublic)");
//        log.debug("Stakeholder: "+stakeholderId);
//
//        Stakeholder stakeholder = stakeholderDAO.findById(stakeholderId);
//        if (stakeholder == null) {
//            // EXCEPTION - Stakeholder not found
//            throw new EntityNotFoundException("Toggle stakeholder access: Stakeholder with id: "+stakeholderId+" not found");
//        }
//        stakeholder.setIsPublic(!stakeholder.getIsPublic());
//
//        stakeholderDAO.save(stakeholder);
//        log.debug("Stakeholder toggled!");
//
//        return stakeholder.getIsPublic();
//    }


    @PreAuthorize("isAuthenticated()")
    @RequestMapping(value = "/{stakeholderId}/change-visibility", method = RequestMethod.POST)
    public Visibility toggleStakeholderAccess(@PathVariable("stakeholderId") String stakeholderId,
                                              @RequestParam("visibility") Visibility visibility) {
        log.debug("change stakeholder visibility: "+visibility);
        log.debug("Stakeholder: "+stakeholderId);

        Stakeholder stakeholder = stakeholderDAO.findById(stakeholderId);
        if (stakeholder == null) {
            // EXCEPTION - Stakeholder not found
            throw new EntityNotFoundException("Change stakeholder visibility: Stakeholder with id: "+stakeholderId+" not found");
        }

//        List<String> roles = authorizationService.getRoles();
        List<String> roles = rolesUtils.getRoles();

//        if(!roles.contains(authorizationService.PORTAL_ADMIN)
//                && !roles.contains(authorizationService.curator(stakeholder.getType()))
//                && !roles.contains(authorizationService.manager(stakeholder.getType(), stakeholder.getAlias()))) {
        if(!rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
            // EXCEPTION - Access denied
            throw new ForbiddenException("Change stakeholder visibility: You are not authorized to update stakeholder with id: "+stakeholderId);
        }
        stakeholder.setVisibility(visibility);

        stakeholderDAO.save(stakeholder);
        log.debug("Stakeholder toggled!");

        return stakeholder.getVisibility();
    }

    // The following are not supposed to be used
//    @RequestMapping(value = "/stakeholder/dates", method = RequestMethod.GET)
//    public List<Date> getAllStakeholderDates() {
//        List<Stakeholder> profiles = stakeholderDAO.findAll();
//        List<Date> profileDates = new ArrayList<>();
//
//        int i=0;
//        for(Stakeholder profile : profiles) {
//            log.debug(profile.getCreationDate());
//            profileDates.add(profile.getCreationDate());
//            log.debug(profileDates.get(i));
//            i++;
//        }
//        return profileDates;
//    }
//
//    @RequestMapping(value = "/stakeholder/dates1", method = RequestMethod.GET)
//    public List<String> getAllStakeholderDates1() {
//        List<Stakeholder> profiles = stakeholderDAO.findAll();
//        List<String> profileDates = new ArrayList<>();
//
//        for(Stakeholder profile : profiles) {
//            log.debug(profile.getCreationDate().toString());
//            profileDates.add(profile.getCreationDate().toString());
//        }
//        return profileDates;
//    }
//
//    @RequestMapping(value = "/stakeholder/dates2", method = RequestMethod.GET)
//    public List<String> getAllStakeholderDates2() {
//        List<Stakeholder> profiles = stakeholderDAO.findAll();
//        List<String> profileDates = new ArrayList<>();
//        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//
//        for(Stakeholder profile : profiles) {
//            log.debug(format.format(profile.getCreationDate()));
//            profileDates.add(format.format(profile.getCreationDate()));
//        }
//        return profileDates;
//    }
}
