package eu.dnetlib.uoamonitorservice.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.data.annotation.Id;

import java.util.Date;
import java.util.List;


enum StakeholderType
{
    // Do not rename or remove existring values. This may cause problems with already stored values in DB
    funder, ri, project, organization,
    FUNDER, RI, PROJECT, ORGANIZATION;
}


public class Stakeholder<StringOrTopic> {
    @Id
    @JsonProperty("_id")
    private String id;

    private StakeholderType type; // private StakeholderType type;
    private String index_id;
    private String index_name;
    private String index_shortName;
    private String logoUrl;
    private boolean isUpload = false;
    private String name;
    private String alias;
    private String description;
    private String defaultId = null;
    private Visibility visibility = Visibility.PRIVATE;
    private Date creationDate;
    private Date updateDate;

    private List<StringOrTopic> topics;

    public Stakeholder() {

    }
    public Stakeholder(Stakeholder stakeholder) {
        id = stakeholder.getId();
        setType(stakeholder.getType());
        index_id = stakeholder.getIndex_id();
        index_name = stakeholder.getIndex_name();
        index_shortName = stakeholder.getIndex_shortName();
        logoUrl = stakeholder.getLogoUrl();
        isUpload = stakeholder.getIsUpload();
        name = stakeholder.getName();
        alias = stakeholder.getAlias();
        description = stakeholder.getDescription();
        defaultId = stakeholder.getDefaultId();
        setVisibility(stakeholder.getVisibility());
        creationDate = stakeholder.getCreationDate();
        updateDate = stakeholder.getUpdateDate();
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

//    public StakeholderType getType() {
//        return type;
//    }
//
//    public void setType(StakeholderType type) {
//        this.type = type;
//    }

    public String getType() {
        if(type == null) {
            return null;
        }
        return type.name();
    }

    public void setType(String type) {
        if(type == null) {
            this.type = null;
        } else {
            StakeholderType stakeholderType = StakeholderType.valueOf(type);
            this.type = stakeholderType;
        }
    }

    public String getIndex_id() {
        return index_id;
    }

    public void setIndex_id(String index_id) {
        this.index_id = index_id;
    }

    public String getIndex_name() {
        return index_name;
    }

    public void setIndex_name(String index_name) {
        this.index_name = index_name;
    }

    public String getIndex_shortName() {
        return index_shortName;
    }

    public void setIndex_shortName(String index_shortName) {
        this.index_shortName = index_shortName;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public boolean getIsUpload() {
        return isUpload;
    }

    public void setIsUpload(boolean isUpload) {
        this.isUpload = isUpload;
    }

    public String getName() { return name; }

    public void setName(String name) { this.name = name; }
    
    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultId() {
        return defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public Visibility getVisibility() {
        //return visibility.getLabel();
        return visibility;
    }

    public void setVisibility(Visibility visibility) {
        //this.visibility = Visibility.get(visibility);
        this.visibility = visibility;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public List<StringOrTopic> getTopics() {
        return topics;
    }

    public void setTopics(List<StringOrTopic> topics) {
        this.topics = topics;
    }
}
