/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.uoamonitorservice.entities.Visibility;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.data.annotation.Id;

public class Category<StringOrSubcategory> {
    @Id
    @JsonProperty(value="_id")
    private String id;
    private String name;
    private String alias;
    private String description;
    private Visibility visibility = Visibility.PRIVATE;
    private Date creationDate;
    private Date updateDate;
    private boolean isOverview;
    private String defaultId;
    private List<StringOrSubcategory> subCategories;

    public Category() {
    }

    public Category(Category category) {
        this.id = category.getId();
        this.name = category.getName();
        this.alias = category.getAlias();
        this.description = category.getDescription();
        this.setVisibility(category.getVisibility());
        this.creationDate = category.getCreationDate();
        this.updateDate = category.getUpdateDate();
        this.isOverview = category.getIsOverview();
        this.defaultId = category.getDefaultId();
    }

    public void copyFromDefault(Category defaultCategory) {
        this.setName(defaultCategory.getName());
        this.setAlias(defaultCategory.getAlias());
        this.setDescription(defaultCategory.getDescription());
        this.setVisibility(defaultCategory.getVisibility());
        this.setCreationDate(defaultCategory.getCreationDate());
        this.setUpdateDate(defaultCategory.getUpdateDate());
        this.setIsOverview(defaultCategory.getIsOverview());
        this.setDefaultId(defaultCategory.getId());
        this.setSubCategories(new ArrayList());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public boolean getIsOverview() {
        return this.isOverview;
    }

    public void setIsOverview(boolean isOverview) {
        this.isOverview = isOverview;
    }

    public String getDefaultId() {
        return this.defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public List<StringOrSubcategory> getSubCategories() {
        return this.subCategories;
    }

    public void setSubCategories(List<StringOrSubcategory> subCategories) {
        this.subCategories = subCategories;
    }
}

