/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.uoamonitorservice.entities.IndicatorPath;
import eu.dnetlib.uoamonitorservice.entities.IndicatorSize;
import eu.dnetlib.uoamonitorservice.entities.IndicatorType;
import eu.dnetlib.uoamonitorservice.entities.Visibility;
import java.util.Date;
import java.util.List;
import org.springframework.data.annotation.Id;

public class Indicator {
    @Id
    @JsonProperty(value="_id")
    private String id;
    private String name;
    private String description;
    private String additionalDescription;
    private IndicatorType type;
    private IndicatorSize width;
    private IndicatorSize height = IndicatorSize.MEDIUM;
    private List<String> tags;
    private Visibility visibility = Visibility.PRIVATE;
    private Date creationDate;
    private Date updateDate;
    private String defaultId;
    private List<IndicatorPath> indicatorPaths;

    public void copyFromDefault(Indicator defaultIndicator) {
        this.setName(defaultIndicator.getName());
        this.setDescription(defaultIndicator.getDescription());
        this.setAdditionalDescription(defaultIndicator.getAdditionalDescription());
        this.setType(defaultIndicator.getType());
        this.setWidth(defaultIndicator.getWidth());
        this.setHeight(defaultIndicator.getHeight());
        this.setTags(defaultIndicator.getTags());
        this.setVisibility(Visibility.RESTRICTED);
        this.setCreationDate(defaultIndicator.getCreationDate());
        this.setUpdateDate(defaultIndicator.getUpdateDate());
        this.setDefaultId(defaultIndicator.getId());
        this.setIndicatorPaths(defaultIndicator.getIndicatorPaths());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAdditionalDescription() {
        return this.additionalDescription;
    }

    public void setAdditionalDescription(String description) {
        this.additionalDescription = description;
    }

    public String getType() {
        if (this.type == null) {
            return null;
        }
        return this.type.name();
    }

    public void setType(String type) {
        IndicatorType indicatorType;
        this.type = type == null ? null : (indicatorType = IndicatorType.valueOf((String)type));
    }

    public IndicatorSize getWidth() {
        return this.width;
    }

    public void setWidth(IndicatorSize width) {
        this.width = width;
    }

    public IndicatorSize getHeight() {
        return this.height;
    }

    public void setHeight(IndicatorSize height) {
        this.height = height;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getDefaultId() {
        return this.defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public List<IndicatorPath> getIndicatorPaths() {
        return this.indicatorPaths;
    }

    public void setIndicatorPaths(List<IndicatorPath> indicatorPaths) {
        this.indicatorPaths = indicatorPaths;
    }
}

