package eu.dnetlib.uoamonitorservice.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.data.annotation.Id;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SubCategory<StringOrSection> {
    @Id
    @JsonProperty("_id")
    private String id;

    private String name;
    private String alias;
    private String description;
    private Visibility visibility = Visibility.PRIVATE;
    private Date creationDate;
    private Date updateDate;
    private String defaultId;
    private List<StringOrSection> charts;
    private List<StringOrSection> numbers;

    public SubCategory() {}
    public SubCategory(SubCategory subCategory) {
        id = subCategory.getId();
        name = subCategory.getName();
        alias = subCategory.getAlias();
        description = subCategory.getDescription();
        setVisibility(subCategory.getVisibility());
        creationDate = subCategory.getCreationDate();
        updateDate = subCategory.getUpdateDate();
        defaultId = subCategory.getDefaultId();
    }

    public void createOverviewSubCategory(Category category) {
        setName("Overview");
        setAlias("overview");
        setVisibility(category.getVisibility());
        setCreationDate(category.getCreationDate());
        setUpdateDate(category.getUpdateDate());
        setCharts(new ArrayList<>());
        setNumbers(new ArrayList<>());
    }

    public void copyFromDefault(SubCategory defaultSubCategory) {
        setName(defaultSubCategory.getName());
        setAlias(defaultSubCategory.getAlias());
        setDescription(defaultSubCategory.getDescription());
        setVisibility(defaultSubCategory.getVisibility());
        setCreationDate(defaultSubCategory.getCreationDate());
        setUpdateDate(defaultSubCategory.getUpdateDate());
        setDefaultId(defaultSubCategory.getId());
        setCharts(new ArrayList());
        setNumbers(new ArrayList());
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Visibility getVisibility() {
        return visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getDefaultId() {
        return defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public List<StringOrSection> getCharts() {
        return charts;
    }

    public void setCharts(List<StringOrSection> charts) {
        this.charts = charts;
    }

    public List<StringOrSection> getNumbers() {
        return numbers;
    }

    public void setNumbers(List<StringOrSection> numbers) {
        this.numbers = numbers;
    }
}
