/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.handlers.ForbiddenException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.utils.RolesUtils;
import eu.dnetlib.uoamonitorservice.controllers.SectionController;
import eu.dnetlib.uoamonitorservice.dao.CategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.IndicatorDAO;
import eu.dnetlib.uoamonitorservice.dao.SectionDAO;
import eu.dnetlib.uoamonitorservice.dao.StakeholderDAO;
import eu.dnetlib.uoamonitorservice.dao.SubCategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.TopicDAO;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Indicator;
import eu.dnetlib.uoamonitorservice.entities.Section;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.SubCategory;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.entities.Visibility;
import eu.dnetlib.uoamonitorservice.handlers.EntityNotFoundException;
import eu.dnetlib.uoamonitorservice.handlers.PathNotValidException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class SubCategoryController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private RolesUtils rolesUtils;
    @Autowired
    private StakeholderDAO stakeholderDAO;
    @Autowired
    private TopicDAO topicDAO;
    @Autowired
    private CategoryDAO categoryDAO;
    @Autowired
    private SubCategoryDAO subCategoryDAO;
    @Autowired
    private SectionDAO sectionDAO;
    @Autowired
    private IndicatorDAO indicatorDAO;
    @Autowired
    private SectionController sectionController;

    public SubCategory<Section<Indicator>> buildSubCategory(SubCategory<Section<Indicator>> subcategoryFull) {
        SubCategory subCategory = new SubCategory(subcategoryFull);
        ArrayList<String> sectionCharts = new ArrayList<String>();
        ArrayList<Section> sectionChartsFull = new ArrayList<Section>();
        for (Section section : subcategoryFull.getCharts()) {
            Section sectionFull = this.sectionController.buildSection(section);
            sectionChartsFull.add(sectionFull);
            sectionCharts.add(sectionFull.getId());
        }
        subcategoryFull.setCharts(sectionChartsFull);
        subCategory.setCharts(sectionCharts);
        ArrayList<String> sectionNumbers = new ArrayList<String>();
        ArrayList<Section> sectionNumbersFull = new ArrayList<Section>();
        for (Section section : subcategoryFull.getNumbers()) {
            Section sectionFull = this.sectionController.buildSection(section);
            sectionNumbersFull.add(sectionFull);
            sectionNumbers.add(sectionFull.getId());
        }
        subcategoryFull.setNumbers(sectionNumbersFull);
        subCategory.setNumbers(sectionNumbers);
        Date date = new Date();
        subCategory.setCreationDate(date);
        subCategory.setUpdateDate(date);
        subcategoryFull.setCreationDate(date);
        subcategoryFull.setUpdateDate(date);
        this.subCategoryDAO.save(subCategory);
        subcategoryFull.setId(subCategory.getId());
        return subcategoryFull;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/save"}, method={RequestMethod.POST})
    public SubCategory<Section<Indicator>> saveSubCategory(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @RequestBody SubCategory<Section<Indicator>> subcategoryFull) {
        this.log.debug((Object)"save subcategory");
        this.log.debug((Object)("Alias: " + subcategoryFull.getAlias() + " - Id: " + subcategoryFull.getId() + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId));
        Category category = this.checkForExceptions(stakeholderId, topicId, categoryId);
        SubCategory subCategory = new SubCategory(subcategoryFull);
        Date date = new Date();
        subCategory.setUpdateDate(date);
        subcategoryFull.setUpdateDate(date);
        ArrayList<String> chartSections = new ArrayList<String>();
        ArrayList<String> numberSections = new ArrayList<String>();
        SubCategory oldSubcategory = null;
        if (subcategoryFull.getId() != null) {
            Section section;
            oldSubcategory = this.subCategoryDAO.findById(subcategoryFull.getId());
            if (oldSubcategory == null) {
                throw new EntityNotFoundException("save subcategory: SubCategory with id: " + subcategoryFull.getId() + " not found");
            }
            for (String chartSectionId : oldSubcategory.getCharts()) {
                section = this.sectionDAO.findById(chartSectionId);
                if (section == null) {
                    throw new EntityNotFoundException("Save subcategory: Chart section with id: " + chartSectionId + " not found (section exists in subcategory: " + subCategory.getId() + ")");
                }
                chartSections.add(section.getId());
            }
            for (String numberSectionId : oldSubcategory.getNumbers()) {
                section = this.sectionDAO.findById(numberSectionId);
                if (section == null) {
                    throw new EntityNotFoundException("Save subcategory: Number section with id: " + numberSectionId + " not found (section exists in subcategory: " + subCategory.getId() + ")");
                }
                numberSections.add(section.getId());
            }
        } else {
            subCategory.setCreationDate(date);
            subcategoryFull.setCreationDate(date);
            for (Section chartSection : subcategoryFull.getCharts()) {
                chartSections.add(chartSection.getId());
            }
            for (Section numberSection : subcategoryFull.getNumbers()) {
                numberSections.add(numberSection.getId());
            }
        }
        subCategory.setCharts(chartSections);
        subCategory.setNumbers(numberSections);
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder.getDefaultId() == null) {
            if (subcategoryFull.getId() == null) {
                this.subCategoryDAO.save(subCategory);
                this.onSaveDefaultSubCategory(subCategory, categoryId);
            } else {
                this.onUpdateDefaultSubCategory(subCategory, oldSubcategory);
                this.subCategoryDAO.save(subCategory);
            }
        } else {
            this.subCategoryDAO.save(subCategory);
        }
        List subcategories = category.getSubCategories();
        int index = subcategories.indexOf(subCategory.getId());
        if (index == -1) {
            subcategories.add(subCategory.getId());
            this.categoryDAO.save(category);
            this.log.debug((Object)"Subcategory saved!");
            subcategoryFull.setId(subCategory.getId());
        }
        chartSections = null;
        numberSections = null;
        subCategory = null;
        return subcategoryFull;
    }

    public void onSaveDefaultSubCategory(SubCategory subCategory, String categoryId) {
        this.log.debug((Object)"On save default subCategory");
        List categories = this.categoryDAO.findByDefaultId(categoryId);
        for (Category category : categories) {
            SubCategory subCategoryNew = new SubCategory();
            subCategoryNew.copyFromDefault(subCategory);
            this.subCategoryDAO.save(subCategoryNew);
            List subCategories = category.getSubCategories();
            subCategories.add(subCategoryNew.getId());
            this.categoryDAO.save(category);
        }
    }

    public void onUpdateDefaultSubCategory(SubCategory subCategory, SubCategory oldSubcategory) {
        this.log.debug((Object)"On update default subCategory");
        List subCategories = this.subCategoryDAO.findByDefaultId(subCategory.getId());
        boolean changed = false;
        for (SubCategory subCategoryBasedOnDefault : subCategories) {
            if (subCategory.getName() != null && !subCategory.getName().equals(subCategoryBasedOnDefault.getName()) && (oldSubcategory.getName() == null || oldSubcategory.getName().equals(subCategoryBasedOnDefault.getName()))) {
                subCategoryBasedOnDefault.setName(subCategory.getName());
                subCategoryBasedOnDefault.setAlias(subCategory.getAlias());
                changed = true;
            }
            if (subCategory.getDescription() != null && !subCategory.getDescription().equals(subCategoryBasedOnDefault.getDescription()) && (oldSubcategory.getDescription() == null || oldSubcategory.getDescription().equals(subCategoryBasedOnDefault.getDescription()))) {
                subCategoryBasedOnDefault.setDescription(subCategory.getDescription());
                changed = true;
            }
            if (!changed) continue;
            subCategoryBasedOnDefault.setUpdateDate(subCategory.getUpdateDate());
            this.subCategoryDAO.save(subCategoryBasedOnDefault);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/delete"}, method={RequestMethod.DELETE})
    public boolean deleteSubCategory(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @RequestParam(required=false) String children) {
        this.log.debug((Object)"delete subcategory");
        this.log.debug((Object)("Id: " + subcategoryId + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId));
        Category category = this.checkForExceptions(stakeholderId, topicId, categoryId);
        SubCategory subcategory = this.subCategoryDAO.findById(subcategoryId);
        if (subcategory == null) throw new EntityNotFoundException("Delete subcategory: SubCategory with id: " + subcategoryId + " not found");
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        List roles = this.rolesUtils.getRoles();
        if (subcategory.getDefaultId() != null && !this.rolesUtils.hasCreateAndDeleteAuthority(roles, stakeholder.getType())) {
            throw new ForbiddenException("Delete subcategory: You are not authorized to delete a default SubCategory in stakeholder with id: " + stakeholderId);
        }
        List subcategories = category.getSubCategories();
        int index = subcategories.indexOf(subcategoryId);
        if (index == -1) throw new PathNotValidException("Delete subcategory: Subcategory with id: " + subcategoryId + " not found in Category: " + categoryId);
        if (category.getDefaultId() == null && children != null) {
            this.onDeleteDefaultSubCategory(subcategoryId, categoryId, children);
        }
        this.sectionController.deleteTree(subcategory);
        subcategory.setCharts(null);
        subcategory.setNumbers(null);
        subcategories.remove(index);
        this.categoryDAO.save(category);
        this.subCategoryDAO.delete(subcategoryId);
        this.log.debug((Object)"Subcategory deleted!");
        return true;
    }

    public boolean onDeleteDefaultSubCategory(String defaultSubCategoryId, String defaultCategoryId, String children) {
        block4: {
            block3: {
                if (!children.equals("delete")) break block3;
                List categories = this.categoryDAO.findByDefaultId(defaultCategoryId);
                List subCategories = this.subCategoryDAO.findByDefaultId(defaultSubCategoryId);
                block0: for (Category category : categories) {
                    Iterator subCategoriesIterator = subCategories.iterator();
                    while (subCategoriesIterator.hasNext()) {
                        SubCategory subCategory = (SubCategory)subCategoriesIterator.next();
                        String subCategoryId = subCategory.getId();
                        if (category.getSubCategories() == null || !category.getSubCategories().contains(subCategoryId)) continue;
                        subCategoriesIterator.remove();
                        category.getSubCategories().remove(subCategoryId);
                        this.categoryDAO.save(category);
                        this.sectionController.deleteTree(subCategory);
                        this.subCategoryDAO.delete(subCategoryId);
                        this.log.debug((Object)("SubCategory with id: " + subCategoryId + " deleted!"));
                        continue block0;
                    }
                }
                break block4;
            }
            if (!children.equals("disconnect")) break block4;
            List subCategories = this.subCategoryDAO.findByDefaultId(defaultSubCategoryId);
            for (SubCategory subCategory : subCategories) {
                this.sectionController.disConnectTree(subCategory);
                subCategory.setDefaultId(null);
                this.subCategoryDAO.save(subCategory);
                this.log.debug((Object)("DefaultId for SubCategory with id: " + subCategory.getId() + " empty!"));
            }
        }
        return true;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/reorder"}, method={RequestMethod.POST})
    public List<SubCategory> reorderSubCategories(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @RequestBody List<String> subCategories) {
        this.log.debug((Object)"reorder subCategories");
        this.log.debug((Object)("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId));
        Category category = this.checkForExceptions(stakeholderId, topicId, categoryId);
        List oldSubcategories = category.getSubCategories();
        for (String subcategoryId : oldSubcategories) {
            if (subCategories.contains(subcategoryId)) continue;
            subCategories.add(subcategoryId);
        }
        category.setSubCategories(subCategories);
        ArrayList<SubCategory> subCategoriesFull = new ArrayList<SubCategory>();
        for (String subCategoryId : subCategories) {
            SubCategory subCategory = this.subCategoryDAO.findById(subCategoryId);
            if (subCategory == null) {
                throw new EntityNotFoundException("Reorder subCategories: subCategory with id: " + subCategoryId + " not found");
            }
            subCategoriesFull.add(subCategory);
        }
        this.categoryDAO.save(category);
        this.log.debug((Object)"SubCategories reordered!");
        return subCategoriesFull;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/change-visibility"}, method={RequestMethod.POST})
    public Visibility changeTopicVisibility(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @RequestParam(value="visibility") Visibility visibility) {
        this.log.debug((Object)("change subCategory visibility: " + visibility));
        this.log.debug((Object)("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId));
        SubCategory subCategory = this.subCategoryDAO.findById(subcategoryId);
        if (subCategory == null) {
            throw new EntityNotFoundException("Change subCategory visibility: SubCategory with id: " + subcategoryId + " not found");
        }
        subCategory.setVisibility(visibility);
        this.toggleSubCategory(stakeholderId, topicId, categoryId, subCategory);
        return subCategory.getVisibility();
    }

    public void toggleSubCategory(String stakeholderId, String topicId, String categoryId, SubCategory subcategory) {
        Category category = this.checkForExceptions(stakeholderId, topicId, categoryId);
        if (!category.getSubCategories().contains(subcategory.getId())) {
            throw new PathNotValidException("Toggle subCategory: SubCategory with id: " + subcategory.getId() + " not found in Category: " + categoryId);
        }
        this.subCategoryDAO.save(subcategory);
        this.log.debug((Object)"SubCategory toggled!");
    }

    private Category checkForExceptions(String stakeholderId, String topicId, String categoryId) {
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder == null) {
            throw new EntityNotFoundException("Save indicator: Stakeholder with id: " + stakeholderId + " not found");
        }
        List roles = this.rolesUtils.getRoles();
        if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
            throw new ForbiddenException("CheckForExceptions SubCategory: You are not authorized to update stakeholder with id: " + stakeholderId);
        }
        Topic topic = this.topicDAO.findById(topicId);
        if (topic == null) {
            throw new EntityNotFoundException("Save indicator: Topic with id: " + topicId + " not found");
        }
        if (!stakeholder.getTopics().contains(topicId)) {
            throw new PathNotValidException("Save indicator: Topic with id: " + topicId + " not found in Stakeholder: " + stakeholderId);
        }
        Category category = this.categoryDAO.findById(categoryId);
        if (category == null) {
            throw new EntityNotFoundException("Save indicator: Category with id: " + categoryId + " not found");
        }
        if (!topic.getCategories().contains(categoryId)) {
            throw new PathNotValidException("Save indicator: Category with id: " + categoryId + " not found in Topic: " + topicId);
        }
        return category;
    }

    public void deleteTree(Category category) {
        List subCategories = category.getSubCategories();
        for (String subCategoryId : subCategories) {
            SubCategory subCategory = this.subCategoryDAO.findById(subCategoryId);
            if (subCategory == null) {
                throw new EntityNotFoundException("SubCategory delete tree: SubCategory with id: " + subCategoryId + " not found (subCategory exists in category: " + category.getId() + ")");
            }
            this.sectionController.deleteTree(subCategory);
            this.subCategoryDAO.delete(subCategoryId);
        }
    }

    public void disConnectTree(Category category) {
        List subCategories = category.getSubCategories();
        for (String subCategoryId : subCategories) {
            SubCategory subCategory = this.subCategoryDAO.findById(subCategoryId);
            if (subCategory == null) {
                throw new EntityNotFoundException("SubCategory disconnect tree: SubCategory with id: " + subCategoryId + " not found (subCategory exists in category: " + category.getId() + ")");
            }
            this.sectionController.disConnectTree(subCategory);
            subCategory.setDefaultId(null);
            this.subCategoryDAO.save(subCategory);
        }
    }
}

