/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.handlers.ForbiddenException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.utils.RolesUtils;
import eu.dnetlib.uoamonitorservice.controllers.CategoryController;
import eu.dnetlib.uoamonitorservice.dao.CategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.StakeholderDAO;
import eu.dnetlib.uoamonitorservice.dao.TopicDAO;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.entities.Visibility;
import eu.dnetlib.uoamonitorservice.handlers.EntityNotFoundException;
import eu.dnetlib.uoamonitorservice.handlers.PathNotValidException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class TopicController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private RolesUtils rolesUtils;
    @Autowired
    private StakeholderDAO stakeholderDAO;
    @Autowired
    private TopicDAO topicDAO;
    @Autowired
    private CategoryController categoryController;
    @Autowired
    private CategoryDAO categoryDAO;

    public Topic<Category> buildTopic(Topic<Category> topicFull) {
        Topic topic = new Topic(topicFull);
        ArrayList<String> categories = new ArrayList<String>();
        ArrayList<Category> categoriesFull = new ArrayList<Category>();
        for (Category category : topicFull.getCategories()) {
            Category categoryFull = this.categoryController.buildCategory(category);
            categoriesFull.add(categoryFull);
            categories.add(categoryFull.getId());
        }
        topicFull.setCategories(categoriesFull);
        topic.setCategories(categories);
        Date date = new Date();
        topic.setCreationDate(date);
        topic.setUpdateDate(date);
        topicFull.setCreationDate(date);
        topicFull.setUpdateDate(date);
        this.topicDAO.save(topic);
        topicFull.setId(topic.getId());
        return topicFull;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/save"}, method={RequestMethod.POST})
    public Topic<Category> saveTopic(@PathVariable(value="stakeholderId") String stakeholderId, @RequestBody Topic<Category> topicFull) {
        ArrayList<String> categories;
        Topic topic;
        this.log.debug((Object)"save topic");
        this.log.debug((Object)("Alias: " + topicFull.getAlias() + " - Id: " + topicFull.getId() + " - Stakeholder: " + stakeholderId));
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder != null) {
            List roles = this.rolesUtils.getRoles();
            if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
                throw new ForbiddenException("Save Topic: You are not authorized to update stakeholder with id: " + stakeholderId);
            }
            topic = new Topic(topicFull);
            Date date = new Date();
            topic.setUpdateDate(date);
            topicFull.setUpdateDate(date);
            categories = new ArrayList<String>();
            Topic oldTopic = null;
            if (topicFull.getId() != null) {
                oldTopic = this.topicDAO.findById(topicFull.getId());
                if (oldTopic == null) {
                    throw new EntityNotFoundException("save topic: Topic with id: " + topicFull.getId() + " not found");
                }
                for (String categoryId : oldTopic.getCategories()) {
                    Category category = this.categoryDAO.findById(categoryId);
                    if (category == null) {
                        throw new EntityNotFoundException("Save topic: Category with id: " + categoryId + " not found (category exists in topic: " + topic.getId() + ")");
                    }
                    categories.add(category.getId());
                }
            } else {
                topic.setCreationDate(date);
                topicFull.setCreationDate(date);
                for (Category category : topicFull.getCategories()) {
                    categories.add(category.getId());
                }
            }
            topic.setCategories(categories);
            if (stakeholder.getDefaultId() == null) {
                if (topicFull.getId() == null) {
                    this.topicDAO.save(topic);
                    this.onSaveDefaultTopic(topic, stakeholderId);
                } else {
                    this.onUpdateDefaultTopic(topic, oldTopic);
                    this.topicDAO.save(topic);
                }
            } else {
                this.topicDAO.save(topic);
            }
            List topics = stakeholder.getTopics();
            int index = topics.indexOf(topic.getId());
            if (index == -1) {
                topics.add(topic.getId());
                this.stakeholderDAO.save(stakeholder);
                this.log.debug((Object)"Topic saved!");
                topicFull.setId(topic.getId());
            }
        } else {
            throw new EntityNotFoundException("Save topic: Stakeholder with id: " + stakeholderId + " not found");
        }
        categories = null;
        topic = null;
        return topicFull;
    }

    public void onSaveDefaultTopic(Topic topic, String stakeholderId) {
        this.log.debug((Object)"On save default topic");
        List stakeholders = this.stakeholderDAO.findByDefaultId(stakeholderId);
        for (Stakeholder _stakeholder : stakeholders) {
            Topic topicNew = new Topic();
            topicNew.copyFromDefault(topic);
            this.topicDAO.save(topicNew);
            List topics = _stakeholder.getTopics();
            topics.add(topicNew.getId());
            this.stakeholderDAO.save(_stakeholder);
        }
    }

    public void onUpdateDefaultTopic(Topic topic, Topic oldTopic) {
        this.log.debug((Object)"On update default topic");
        List topics = this.topicDAO.findByDefaultId(topic.getId());
        boolean changed = false;
        for (Topic topicBasedOnDefault : topics) {
            if (topic.getName() != null && !topic.getName().equals(topicBasedOnDefault.getName()) && (oldTopic.getName() == null || oldTopic.getName().equals(topicBasedOnDefault.getName()))) {
                topicBasedOnDefault.setName(topic.getName());
                topicBasedOnDefault.setAlias(topic.getAlias());
                changed = true;
            }
            if (topic.getDescription() != null && !topic.getDescription().equals(topicBasedOnDefault.getDescription()) && (oldTopic.getDescription() == null || oldTopic.getDescription().equals(topicBasedOnDefault.getDescription()))) {
                topicBasedOnDefault.setDescription(topic.getDescription());
                changed = true;
            }
            if (topic.getIcon() != null && !topic.getIcon().equals(topicBasedOnDefault.getIcon()) && (oldTopic.getIcon() == null || oldTopic.getIcon().equals(topicBasedOnDefault.getIcon()))) {
                topicBasedOnDefault.setIcon(topic.getIcon());
                changed = true;
            }
            if (!changed) continue;
            topicBasedOnDefault.setUpdateDate(topic.getUpdateDate());
            this.topicDAO.save(topicBasedOnDefault);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/delete"}, method={RequestMethod.DELETE})
    public boolean deleteTopic(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @RequestParam(required=false) String children) {
        this.log.debug((Object)"delete topic");
        this.log.debug((Object)("Id: " + topicId + " - Stakeholder: " + stakeholderId));
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder == null) throw new EntityNotFoundException("Delete topic: Stakeholder with id: " + stakeholderId + " not found");
        List roles = this.rolesUtils.getRoles();
        if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
            throw new ForbiddenException("Delete topic: You are not authorized to update stakeholder with id: " + stakeholderId);
        }
        Topic topic = this.topicDAO.findById(topicId);
        if (topic == null) throw new EntityNotFoundException("Delete topic: Topic with id: " + topicId + " not found");
        if (topic.getDefaultId() != null && !this.rolesUtils.hasCreateAndDeleteAuthority(roles, stakeholder.getType())) {
            throw new ForbiddenException("Delete topic: You are not authorized to delete a default Topic in stakeholder with id: " + stakeholderId);
        }
        List topics = stakeholder.getTopics();
        int index = topics.indexOf(topicId);
        if (index == -1) throw new PathNotValidException("Delete topic: Topic with id: " + topicId + " not found in Stakeholder: " + stakeholderId);
        if (stakeholder.getDefaultId() == null && children != null) {
            this.onDeleteDefaultTopic(topicId, stakeholderId, children);
        }
        this.categoryController.deleteTree(topic);
        topic.setCategories(null);
        topics.remove(index);
        this.stakeholderDAO.save(stakeholder);
        this.topicDAO.delete(topicId);
        this.log.debug((Object)"Topic deleted!");
        return true;
    }

    public boolean onDeleteDefaultTopic(String defaultTopicId, String defaultStakeholderId, String children) {
        block4: {
            block3: {
                if (!children.equals("delete")) break block3;
                List stakeholders = this.stakeholderDAO.findByDefaultId(defaultStakeholderId);
                List topics = this.topicDAO.findByDefaultId(defaultTopicId);
                block0: for (Stakeholder stakeholder : stakeholders) {
                    Iterator topicsIterator = topics.iterator();
                    while (topicsIterator.hasNext()) {
                        Topic topic = (Topic)topicsIterator.next();
                        String topicId = topic.getId();
                        if (stakeholder.getTopics() == null || !stakeholder.getTopics().contains(topicId)) continue;
                        topicsIterator.remove();
                        stakeholder.getTopics().remove(topicId);
                        this.stakeholderDAO.save(stakeholder);
                        this.categoryController.deleteTree(topic);
                        this.topicDAO.delete(topicId);
                        this.log.debug((Object)("Topic with id: " + topicId + " deleted!"));
                        continue block0;
                    }
                }
                break block4;
            }
            if (!children.equals("disconnect")) break block4;
            List topics = this.topicDAO.findByDefaultId(defaultTopicId);
            for (Topic topic : topics) {
                this.categoryController.disConnectTree(topic);
                topic.setDefaultId(null);
                this.topicDAO.save(topic);
                this.log.debug((Object)("DefaultId for Topic with id: " + topic.getId() + " cleared!"));
            }
        }
        return true;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/reorder"}, method={RequestMethod.POST})
    public List<Topic> reorderTopics(@PathVariable(value="stakeholderId") String stakeholderId, @RequestBody List<String> topics) {
        this.log.debug((Object)"reorder topics");
        this.log.debug((Object)("Stakeholder: " + stakeholderId));
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder != null) {
            List roles = this.rolesUtils.getRoles();
            if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
                throw new ForbiddenException("Reorder topics: You are not authorized to update stakeholder with id: " + stakeholderId);
            }
            List oldTopics = stakeholder.getTopics();
            for (String topicId : oldTopics) {
                if (topics.contains(topicId)) continue;
                topics.add(topicId);
            }
            stakeholder.setTopics(topics);
            ArrayList<Topic> topicsFull = new ArrayList<Topic>();
            for (String topicId : topics) {
                Topic topic = this.topicDAO.findById(topicId);
                if (topic == null) {
                    throw new EntityNotFoundException("Reorder Topics: Topic with id: " + topicId + " not found");
                }
                topicsFull.add(topic);
            }
            this.stakeholderDAO.save(stakeholder);
            this.log.debug((Object)"Topics reordered!");
            return topicsFull;
        }
        throw new EntityNotFoundException("Reorder topics: Stakeholder with id: " + stakeholderId + " not found");
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/change-visibility"}, method={RequestMethod.POST})
    public Visibility changeTopicVisibility(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @RequestParam(value="visibility") Visibility visibility) {
        this.log.debug((Object)("change topic visibility: " + visibility));
        this.log.debug((Object)("Stakeholder: " + stakeholderId + " - Topic: " + topicId));
        Topic topic = this.topicDAO.findById(topicId);
        if (topic == null) {
            throw new EntityNotFoundException("Change topic visibility: Topic with id: " + topicId + " not found");
        }
        topic.setVisibility(visibility);
        this.toggleTopic(stakeholderId, topic);
        return topic.getVisibility();
    }

    public void toggleTopic(String stakeholderId, Topic topic) {
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder != null) {
            List roles = this.rolesUtils.getRoles();
            if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
                throw new ForbiddenException("Toggle topic: You are not authorized to update stakeholder with id: " + stakeholderId);
            }
            if (!stakeholder.getTopics().contains(topic.getId())) {
                throw new PathNotValidException("Toggle topic: Topic with id: " + topic.getId() + " not found in Stakeholder: " + stakeholderId);
            }
        } else {
            throw new EntityNotFoundException("Toggle topic: Stakeholder with id: " + stakeholderId + " not found");
        }
        this.topicDAO.save(topic);
        this.log.debug((Object)"Topic toggled!");
    }

    public void deleteTree(Stakeholder stakeholder) {
        List topics = stakeholder.getTopics();
        for (String topicId : topics) {
            Topic topic = this.topicDAO.findById(topicId);
            if (topic == null) {
                throw new EntityNotFoundException("Topic delete tree: Topic with id: " + topicId + " not found (topic exists in stakeholder: " + stakeholder.getId() + ")");
            }
            this.categoryController.deleteTree(topic);
            this.topicDAO.delete(topicId);
        }
    }
}

