package eu.dnetlib.uoamonitorservice.entities;

import java.util.List;
import java.util.Map;

enum IndicatorPathType {
    // Do not rename or remove existring values. This may cause problems with already stored values in DB
    table, bar, column, pie, line, other,
    TABLE, BAR, COLUMN, PIE, LINE, OTHER;
}

//enum SourceType {
//    STATISTICS, SEARCH, METRICS, STATS_TOOL,OLD,IMAGE;
//}

public class IndicatorPath {
    private IndicatorPathType type;  // for charts is type of chart {table, bar, column, etc}
    private String source; // for numbers is the service {statistics, search, metrics} for charts is the tool {stats-tool,old,metrics, image}
    private String url;
    private List<String> jsonPath;
    private String chartObject;
    private Map<String, String> parameters;
    private Map<String, String> filters;
    //private Map<String, Map<String, String>> filters;

    public IndicatorPath() {}

    public IndicatorPath(IndicatorPath indicatorPath) {
        setType(indicatorPath.getType());
        source = indicatorPath.getSource();
        url = indicatorPath.getUrl();
        jsonPath = indicatorPath.getJsonPath();
        chartObject = indicatorPath.getChartObject();
        parameters = indicatorPath.getParameters();
        filters = indicatorPath.getFilters();
    }

    public String getType() {
        if(type == null) {
            return null;
        }
        return type.name();
    }

//    public IndicatorPathType getType() {
//        return type;
//    }

    public void setType(String type) {
        if(type == null) {
            this.type = null;
        } else {
            IndicatorPathType indicatorPathType = IndicatorPathType.valueOf(type);
            this.type = indicatorPathType;
        }
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<String> getJsonPath() {
        return jsonPath;
    }

    public void setJsonPath(List<String> jsonPath) {
        this.jsonPath = jsonPath;
    }

    public String getChartObject() {
        return chartObject;
    }

    public void setChartObject(String chartObject) {
        this.chartObject = chartObject;
    }

    public Map<String, String> getParameters() {
        return parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getFilters() {
        return filters;
    }

    public void setFilters(Map<String, String> filters) {
        this.filters = filters;
    }
}
