/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.handlers.ForbiddenException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.utils.RolesUtils;
import eu.dnetlib.uoamonitorservice.controllers.SubCategoryController;
import eu.dnetlib.uoamonitorservice.dao.CategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.StakeholderDAO;
import eu.dnetlib.uoamonitorservice.dao.SubCategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.TopicDAO;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.SubCategory;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.entities.Visibility;
import eu.dnetlib.uoamonitorservice.handlers.EntityNotFoundException;
import eu.dnetlib.uoamonitorservice.handlers.PathNotValidException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class CategoryController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private RolesUtils rolesUtils;
    @Autowired
    private StakeholderDAO stakeholderDAO;
    @Autowired
    private TopicDAO topicDAO;
    @Autowired
    private CategoryDAO categoryDAO;
    @Autowired
    private SubCategoryDAO subCategoryDAO;
    @Autowired
    private SubCategoryController subCategoryController;

    public Category<SubCategory> buildCategory(Category<SubCategory> categoryFull) {
        Category category = new Category(categoryFull);
        ArrayList<String> subCategories = new ArrayList<String>();
        ArrayList<SubCategory> subCategoriesFull = new ArrayList<SubCategory>();
        for (SubCategory subCategory : categoryFull.getSubCategories()) {
            SubCategory subcategoryFull = this.subCategoryController.buildSubCategory(subCategory);
            subCategoriesFull.add(subcategoryFull);
            subCategories.add(subcategoryFull.getId());
        }
        categoryFull.setSubCategories(subCategoriesFull);
        category.setSubCategories(subCategories);
        Date date = new Date();
        category.setCreationDate(date);
        category.setUpdateDate(date);
        categoryFull.setCreationDate(date);
        categoryFull.setUpdateDate(date);
        this.categoryDAO.save(category);
        categoryFull.setId(category.getId());
        return categoryFull;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/save"}, method={RequestMethod.POST})
    public Category<SubCategory> saveCategory(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @RequestBody Category<SubCategory> categoryFull) {
        this.log.debug((Object)"save category");
        this.log.debug((Object)("Alias: " + categoryFull.getAlias() + " - Id: " + categoryFull.getId() + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId));
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder == null) throw new EntityNotFoundException("Save category: Stakeholder with id: " + stakeholderId + " not found");
        List roles = this.rolesUtils.getRoles();
        if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
            throw new ForbiddenException("Save Category: You are not authorized to update stakeholder with id: " + stakeholderId);
        }
        Category oldCategory = null;
        if (categoryFull.getId() != null && (oldCategory = this.categoryDAO.findById(categoryFull.getId())) == null) {
            throw new EntityNotFoundException("save category: Category with id: " + categoryFull.getId() + " not found");
        }
        Topic topic = this.topicDAO.findById(topicId);
        if (topic == null) throw new EntityNotFoundException("Save category: Topic with id: " + topicId + " not found");
        if (!stakeholder.getTopics().contains(topicId)) throw new PathNotValidException("Save category: Topic with id: " + topicId + " not found in Stakeholder: " + stakeholderId);
        Category category = new Category(categoryFull);
        Date date = new Date();
        category.setUpdateDate(date);
        categoryFull.setUpdateDate(date);
        ArrayList<String> subCategories = new ArrayList<String>();
        if (categoryFull.getId() == null) {
            category.setCreationDate(date);
            categoryFull.setCreationDate(date);
            SubCategory subCategory = new SubCategory();
            subCategory.createOverviewSubCategory(categoryFull);
            this.subCategoryDAO.save(subCategory);
            List subCategoriesFull = categoryFull.getSubCategories();
            subCategoriesFull.add(subCategory);
            for (SubCategory oldSubCategory : subCategoriesFull) {
                subCategories.add(oldSubCategory.getId());
            }
        } else {
            for (String subCategoryId : oldCategory.getSubCategories()) {
                SubCategory subCategory = this.subCategoryDAO.findById(subCategoryId);
                if (subCategory == null) {
                    throw new EntityNotFoundException("Save category: SubCategory with id: " + subCategoryId + " not found (subcategory exists in category: " + category.getId() + ")");
                }
                subCategories.add(subCategory.getId());
            }
        }
        category.setSubCategories(subCategories);
        if (stakeholder.getDefaultId() == null) {
            if (categoryFull.getId() == null) {
                this.categoryDAO.save(category);
                this.onSaveDefaultCategory(category, topicId);
            } else {
                this.onUpdateDefaultCategory(category, oldCategory);
                this.categoryDAO.save(category);
            }
        } else {
            this.categoryDAO.save(category);
        }
        List categories = topic.getCategories();
        int index = categories.indexOf(category.getId());
        if (index == -1) {
            categories.add(category.getId());
            this.topicDAO.save(topic);
            this.log.debug((Object)"Category saved!");
            categoryFull.setId(category.getId());
        }
        subCategories = null;
        return categoryFull;
    }

    public void onSaveDefaultCategory(Category<String> category, String topicId) {
        this.log.debug((Object)"On save default category");
        List topics = this.topicDAO.findByDefaultId(topicId);
        for (Topic topic : topics) {
            Category categoryNew = new Category();
            categoryNew.copyFromDefault(category);
            this.categoryDAO.save(categoryNew);
            List categories = topic.getCategories();
            categories.add(categoryNew.getId());
            this.topicDAO.save(topic);
        }
        String subCategoryOverviewId = (String)category.getSubCategories().get(0);
        SubCategory subCategoryOverview = this.subCategoryDAO.findById(subCategoryOverviewId);
        this.subCategoryController.onSaveDefaultSubCategory(subCategoryOverview, category.getId());
    }

    public void onUpdateDefaultCategory(Category category, Category oldCategory) {
        this.log.debug((Object)"On update default category");
        List categories = this.categoryDAO.findByDefaultId(category.getId());
        boolean changed = false;
        for (Category categoryBasedOnDefault : categories) {
            if (category.getName() != null && !category.getName().equals(categoryBasedOnDefault.getName()) && (oldCategory.getName() == null || oldCategory.getName().equals(categoryBasedOnDefault.getName()))) {
                categoryBasedOnDefault.setName(category.getName());
                categoryBasedOnDefault.setAlias(category.getAlias());
                changed = true;
            }
            if (category.getDescription() != null && !category.getDescription().equals(categoryBasedOnDefault.getDescription()) && (oldCategory.getDescription() == null || oldCategory.getDescription().equals(categoryBasedOnDefault.getDescription()))) {
                categoryBasedOnDefault.setDescription(category.getDescription());
                changed = true;
            }
            if (!changed) continue;
            categoryBasedOnDefault.setUpdateDate(category.getUpdateDate());
            this.categoryDAO.save(categoryBasedOnDefault);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/delete"}, method={RequestMethod.DELETE})
    public boolean deleteCategory(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @RequestParam(required=false) String children) {
        this.log.debug((Object)"delete category");
        this.log.debug((Object)("Id: " + categoryId + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId));
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder == null) throw new EntityNotFoundException("Delete category: Stakeholder with id: " + stakeholderId + " not found");
        List roles = this.rolesUtils.getRoles();
        if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
            throw new ForbiddenException("Delete category: You are not authorized to update stakeholder with id: " + stakeholderId);
        }
        Topic topic = this.topicDAO.findById(topicId);
        if (topic == null) throw new EntityNotFoundException("Delete category: Topic with id: " + topicId + " not found");
        if (!stakeholder.getTopics().contains(topicId)) throw new PathNotValidException("Delete category: Topic with id: " + topicId + " not found in Stakeholder: " + stakeholderId);
        Category category = this.categoryDAO.findById(categoryId);
        if (category == null) throw new EntityNotFoundException("Delete category: Category with id: " + categoryId + " not found");
        if (category.getDefaultId() != null && !this.rolesUtils.hasCreateAndDeleteAuthority(roles, stakeholder.getType())) {
            throw new ForbiddenException("Delete category: You are not authorized to delete a default Category in stakeholder with id: " + stakeholderId);
        }
        List categories = topic.getCategories();
        int index = categories.indexOf(categoryId);
        if (index == -1) throw new PathNotValidException("Delete category: Category with id: " + categoryId + " not found in Topic: " + topicId);
        if (topic.getDefaultId() == null && children != null) {
            this.onDeleteDefaultCategory(categoryId, topicId, children);
        }
        this.subCategoryController.deleteTree(category);
        category.setSubCategories(null);
        categories.remove(index);
        this.topicDAO.save(topic);
        this.categoryDAO.delete(categoryId);
        this.log.debug((Object)"Category deleted!");
        return true;
    }

    public boolean onDeleteDefaultCategory(String defaultCategoryId, String defaultTopicId, String children) {
        block4: {
            block3: {
                if (!children.equals("delete")) break block3;
                List topics = this.topicDAO.findByDefaultId(defaultTopicId);
                List categories = this.categoryDAO.findByDefaultId(defaultCategoryId);
                block0: for (Topic topic : topics) {
                    Iterator categoriesIterator = categories.iterator();
                    while (categoriesIterator.hasNext()) {
                        Category category = (Category)categoriesIterator.next();
                        String categoryId = category.getId();
                        if (topic.getCategories() == null || !topic.getCategories().contains(categoryId)) continue;
                        categoriesIterator.remove();
                        topic.getCategories().remove(categoryId);
                        this.topicDAO.save(topic);
                        this.subCategoryController.deleteTree(category);
                        this.categoryDAO.delete(categoryId);
                        this.log.debug((Object)("Category with id: " + categoryId + " deleted!"));
                        continue block0;
                    }
                }
                break block4;
            }
            if (!children.equals("disconnect")) break block4;
            List categories = this.categoryDAO.findByDefaultId(defaultCategoryId);
            for (Category category : categories) {
                this.subCategoryController.disConnectTree(category);
                category.setDefaultId(null);
                this.categoryDAO.save(category);
                this.log.debug((Object)("DefaultId for Category with id: " + category.getId() + " empty!"));
            }
        }
        return true;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/reorder"}, method={RequestMethod.POST})
    public List<Category> reorderCategories(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @RequestBody List<String> categories) {
        this.log.debug((Object)"reorder categories");
        this.log.debug((Object)("Stakeholder: " + stakeholderId + " - Topic: " + topicId));
        Topic topic = this.checkForExceptions(stakeholderId, topicId);
        List oldCategories = topic.getCategories();
        for (String categoryId : oldCategories) {
            if (categories.contains(categoryId)) continue;
            categories.add(categoryId);
        }
        topic.setCategories(categories);
        ArrayList<Category> categoriesFull = new ArrayList<Category>();
        for (String categoryId : categories) {
            Category category = this.categoryDAO.findById(categoryId);
            if (category == null) {
                throw new EntityNotFoundException("Reorder Categories: Category with id: " + categoryId + " not found");
            }
            categoriesFull.add(category);
        }
        this.topicDAO.save(topic);
        this.log.debug((Object)"Categories reordered!");
        return categoriesFull;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/change-visibility"}, method={RequestMethod.POST})
    public Category changeCategoryVisibility(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @RequestParam(value="visibility") Visibility visibility, @RequestParam(required=false) Boolean propagate) {
        this.log.debug((Object)("change category visibility: " + visibility + " - toggle propagate: " + (propagate != null && propagate != false ? "true" : "false")));
        this.log.debug((Object)("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId));
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder != null) {
            List roles = this.rolesUtils.getRoles();
            if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
                throw new ForbiddenException("Toggle category: You are not authorized to update stakeholder with id: " + stakeholderId);
            }
            Topic topic = this.topicDAO.findById(topicId);
            if (topic != null) {
                if (stakeholder.getTopics().contains(topicId)) {
                    if (topic.getCategories().contains(categoryId)) {
                        return this.changeVisibilityTree(categoryId, visibility, propagate);
                    }
                    throw new PathNotValidException("Toggle category: Category with id: " + categoryId + " not found in Topic: " + topicId);
                }
                throw new PathNotValidException("Toggle category: Topic with id: " + topicId + " not found in Stakeholder: " + stakeholderId);
            }
            throw new EntityNotFoundException("Toggle category: Topic with id: " + topicId + " not found");
        }
        throw new EntityNotFoundException("Toggle category: Stakeholder with id: " + stakeholderId + " not found");
    }

    public Category changeVisibilityTree(String categoryId, Visibility visibility, Boolean propagate) {
        Category category = this.categoryDAO.findById(categoryId);
        if (category == null) {
            throw new EntityNotFoundException("Change category visibility: Category with id: " + categoryId + " not found");
        }
        Category categoryFull = new Category(category);
        ArrayList<SubCategory> subCategoriesFull = new ArrayList<SubCategory>();
        if (propagate != null && propagate.booleanValue()) {
            for (String subCategoryId : category.getSubCategories()) {
                subCategoriesFull.add(this.subCategoryController.changeVisibilityTree(subCategoryId, visibility, propagate));
            }
        }
        category.setVisibility(visibility);
        this.categoryDAO.save(category);
        this.log.debug((Object)"Category toggled!");
        categoryFull.setVisibility(visibility);
        categoryFull.setSubCategories(subCategoriesFull);
        return categoryFull;
    }

    private Topic checkForExceptions(String stakeholderId, String topicId) {
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder == null) {
            throw new EntityNotFoundException("checkForExceptions category: Stakeholder with id: " + stakeholderId + " not found");
        }
        List roles = this.rolesUtils.getRoles();
        if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
            throw new ForbiddenException("checkForExceptions category: You are not authorized to update stakeholder with id: " + stakeholderId);
        }
        Topic topic = this.topicDAO.findById(topicId);
        if (topic == null) {
            throw new EntityNotFoundException("checkForExceptions category: Topic with id: " + topicId + " not found");
        }
        if (!stakeholder.getTopics().contains(topicId)) {
            throw new PathNotValidException("checkForExceptions category: Topic with id: " + topicId + " not found in Stakeholder: " + stakeholderId);
        }
        return topic;
    }

    public void deleteTree(Topic topic) {
        List categories = topic.getCategories();
        for (String categoryId : categories) {
            Category category = this.categoryDAO.findById(categoryId);
            if (category == null) {
                throw new EntityNotFoundException("Category delete tree: Category with id: " + categoryId + " not found (category exists in topic: " + topic.getId() + ")");
            }
            this.subCategoryController.deleteTree(category);
            this.categoryDAO.delete(categoryId);
        }
    }

    public void disConnectTree(Topic topic) {
        List categories = topic.getCategories();
        for (String categoryId : categories) {
            Category category = this.categoryDAO.findById(categoryId);
            if (category == null) {
                throw new EntityNotFoundException("Category disconnect tree: Category with id: " + categoryId + " not found (category exists in topic: " + topic.getId() + ")");
            }
            this.subCategoryController.disConnectTree(category);
            category.setDefaultId(null);
            this.categoryDAO.save(category);
        }
    }
}

