/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.handlers.ForbiddenException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.utils.RolesUtils;
import eu.dnetlib.uoamonitorservice.controllers.IndicatorController;
import eu.dnetlib.uoamonitorservice.dao.CategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.IndicatorDAO;
import eu.dnetlib.uoamonitorservice.dao.SectionDAO;
import eu.dnetlib.uoamonitorservice.dao.StakeholderDAO;
import eu.dnetlib.uoamonitorservice.dao.SubCategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.TopicDAO;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Indicator;
import eu.dnetlib.uoamonitorservice.entities.Section;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.SubCategory;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.entities.Visibility;
import eu.dnetlib.uoamonitorservice.handlers.EntityNotFoundException;
import eu.dnetlib.uoamonitorservice.handlers.PathNotValidException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class SectionController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private RolesUtils rolesUtils;
    @Autowired
    private StakeholderDAO stakeholderDAO;
    @Autowired
    private TopicDAO topicDAO;
    @Autowired
    private CategoryDAO categoryDAO;
    @Autowired
    private SubCategoryDAO subCategoryDAO;
    @Autowired
    private SectionDAO sectionDAO;
    @Autowired
    private IndicatorDAO indicatorDAO;
    @Autowired
    private IndicatorController indicatorController;

    public Section<Indicator> buildSection(Section<Indicator> sectionFull) {
        Section section = new Section(sectionFull);
        ArrayList<String> indicators = new ArrayList<String>();
        ArrayList<Indicator> indicatorsFull = new ArrayList<Indicator>();
        for (Indicator chart : sectionFull.getIndicators()) {
            Indicator chartSaved = this.indicatorDAO.save(chart);
            chart.setId(chartSaved.getId());
            indicatorsFull.add(chart);
            indicators.add(chartSaved.getId());
        }
        sectionFull.setIndicators(indicatorsFull);
        section.setIndicators(indicators);
        Date date = new Date();
        section.setCreationDate(date);
        section.setUpdateDate(date);
        sectionFull.setCreationDate(date);
        sectionFull.setUpdateDate(date);
        this.sectionDAO.save(section);
        sectionFull.setId(section.getId());
        return sectionFull;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/save/{index}"}, method={RequestMethod.POST})
    public Section saveSection(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="index") String index, @RequestBody Section<Indicator> sectionFull) {
        this.log.debug((Object)"save section");
        this.log.debug((Object)("Name: " + sectionFull.getTitle() + " - Id: " + sectionFull.getId() + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId));
        SubCategory subCategory = this.checkForExceptions(stakeholderId, topicId, categoryId, subcategoryId);
        Section section = new Section(sectionFull);
        Date date = new Date();
        section.setUpdateDate(date);
        sectionFull.setUpdateDate(date);
        ArrayList<String> indicators = new ArrayList<String>();
        Section oldSection = null;
        if (sectionFull.getId() != null) {
            oldSection = this.sectionDAO.findById(sectionFull.getId());
            if (oldSection == null) {
                throw new EntityNotFoundException("save section: Section with id: " + sectionFull.getId() + " not found");
            }
            for (String indicatorId : oldSection.getIndicators()) {
                Indicator indicator = this.indicatorDAO.findById(indicatorId);
                if (indicator == null) {
                    throw new EntityNotFoundException("Save section: Indicator with id: " + indicatorId + " not found (indicator exists in section: " + section.getId() + ")");
                }
                indicators.add(indicator.getId());
            }
        } else {
            section.setCreationDate(date);
            sectionFull.setCreationDate(date);
            for (Indicator indicator : sectionFull.getIndicators()) {
                indicators.add(indicator.getId());
            }
        }
        String sectionId = sectionFull.getId();
        section.setIndicators(indicators);
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder.getDefaultId() == null) {
            if (sectionId == null) {
                this.sectionDAO.save(section);
                this.onSaveDefaultSection(section, topicId, categoryId, subcategoryId, stakeholder);
            } else {
                this.onUpdateDefaultSection(section, stakeholder, oldSection);
                this.sectionDAO.save(section);
            }
        } else {
            this.sectionDAO.save(section);
        }
        List sections = null;
        if (sectionFull.getType().equals("chart")) {
            sections = subCategory.getCharts();
        } else if (sectionFull.getType().equals("number")) {
            sections = subCategory.getNumbers();
        }
        int existing_index = sections.indexOf(section.getId());
        if (existing_index == -1) {
            if (Integer.parseInt(index) != -1) {
                sections.add(Integer.parseInt(index), section.getId());
            } else {
                sections.add(section.getId());
            }
            this.subCategoryDAO.save(subCategory);
            this.log.debug((Object)"Section saved!");
            sectionFull.setId(section.getId());
        }
        return sectionFull;
    }

    public void onSaveDefaultSection(Section section, String defaultTopicId, String defaultCategoryId, String defaultSubcategoryId, Stakeholder defaultStakeholder) {
        this.log.debug((Object)"On save default section");
        List subCategories = this.subCategoryDAO.findByDefaultId(defaultSubcategoryId);
        for (SubCategory subCategory : subCategories) {
            Category parentCategory = this.categoryDAO.findBySubCategoriesContaining(subCategory.getId());
            Topic parentTopic = this.topicDAO.findByCategoriesContaining(parentCategory.getId());
            Stakeholder parentStakeholder = this.stakeholderDAO.findByTopicsContaining(parentTopic.getId());
            Section sectionNew = new Section();
            sectionNew.copyFromDefault(section);
            sectionNew.setStakeholderAlias(parentStakeholder.getAlias());
            this.sectionDAO.save(sectionNew);
            List sections = null;
            if (section.getType().equals("chart")) {
                sections = subCategory.getCharts();
            } else if (section.getType().equals("number")) {
                sections = subCategory.getNumbers();
            }
            sections.add(sectionNew.getId());
            this.subCategoryDAO.save(subCategory);
        }
    }

    public void onUpdateDefaultSection(Section section, Stakeholder stakeholder, Section oldSection) {
        this.log.debug((Object)"On update default section");
        boolean changed = false;
        List sections = this.sectionDAO.findByDefaultId(section.getId());
        for (Section sectionBasedOnDefault : sections) {
            if (section.getTitle() != null && !section.getTitle().equals(sectionBasedOnDefault.getTitle()) && (oldSection.getTitle() == null || oldSection.getTitle().equals(sectionBasedOnDefault.getTitle()))) {
                sectionBasedOnDefault.setTitle(section.getTitle());
                changed = true;
            }
            if (!changed) continue;
            sectionBasedOnDefault.setUpdateDate(section.getUpdateDate());
            this.sectionDAO.save(sectionBasedOnDefault);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/delete"}, method={RequestMethod.DELETE})
    public boolean deleteSection(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @RequestParam(required=false) String children) {
        this.log.debug((Object)"delete section");
        this.log.debug((Object)("Id: " + sectionId + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId));
        Section section = this.sectionDAO.findById(sectionId);
        if (section == null) throw new EntityNotFoundException("Delete section: Section with id: " + sectionId + " not found");
        SubCategory subCategory = this.checkForExceptions(stakeholderId, topicId, categoryId, subcategoryId);
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        List roles = this.rolesUtils.getRoles();
        if (section.getDefaultId() != null && !this.rolesUtils.hasCreateAndDeleteAuthority(roles, stakeholder.getType())) {
            throw new ForbiddenException("Delete section: You are not authorized to delete a default Section in stakeholder with id: " + stakeholderId);
        }
        String type = "";
        List sections = null;
        if (section.getType().equals("chart")) {
            sections = subCategory.getCharts();
            type = "chart";
        } else if (section.getType().equals("number")) {
            sections = subCategory.getNumbers();
            type = "number";
        }
        int index = sections.indexOf(sectionId);
        if (index == -1) throw new PathNotValidException("Delete section: Section with id: " + sectionId + " not found in SubCategory: " + subcategoryId);
        if (subCategory.getDefaultId() == null && children != null) {
            this.onDeleteDefaultSection(sectionId, subcategoryId, children, type);
        }
        this.indicatorController.deleteTree(section);
        sections.remove(index);
        this.subCategoryDAO.save(subCategory);
        this.sectionDAO.delete(sectionId);
        this.log.debug((Object)"Section deleted!");
        return true;
    }

    public boolean onDeleteDefaultSection(String defaultSectionId, String defaultSubCategoryId, String children, String type) {
        block7: {
            block6: {
                if (!children.equals("delete")) break block6;
                List subCategories = this.subCategoryDAO.findByDefaultId(defaultSubCategoryId);
                List sections = this.sectionDAO.findByDefaultId(defaultSectionId);
                block0: for (SubCategory subCategory : subCategories) {
                    Iterator sectionsIterator = sections.iterator();
                    while (sectionsIterator.hasNext()) {
                        Section section = (Section)sectionsIterator.next();
                        String sectionId = section.getId();
                        List subCategorySections = null;
                        if (type.equals("chart")) {
                            subCategorySections = subCategory.getCharts();
                        } else if (type.equals("number")) {
                            subCategorySections = subCategory.getNumbers();
                        }
                        if (subCategorySections == null || !subCategorySections.contains(sectionId)) continue;
                        sectionsIterator.remove();
                        subCategorySections.remove(sectionId);
                        this.subCategoryDAO.save(subCategory);
                        this.indicatorController.deleteTree(section);
                        this.sectionDAO.delete(sectionId);
                        this.log.debug((Object)("Section with id: " + sectionId + " deleted!"));
                        continue block0;
                    }
                }
                break block7;
            }
            if (!children.equals("disconnect")) break block7;
            List sections = this.sectionDAO.findByDefaultId(defaultSectionId);
            for (Section section : sections) {
                this.indicatorController.disConnectTree(section);
                section.setDefaultId(null);
                this.sectionDAO.save(section);
                this.log.debug((Object)("DefaultId for Section with id: " + section.getId() + " empty!"));
            }
        }
        return true;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{type}/reorder"}, method={RequestMethod.POST})
    public List<Section> reorderSections(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="type") String type, @RequestBody List<String> sections) {
        List oldSections;
        this.log.debug((Object)("reorder sections of type: " + type));
        this.log.debug((Object)("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId));
        SubCategory subCategory = this.checkForExceptions(stakeholderId, topicId, categoryId, subcategoryId);
        if (type.equals("chart")) {
            oldSections = subCategory.getCharts();
            for (String sectionId : oldSections) {
                if (sections.contains(sectionId)) continue;
                sections.add(sectionId);
            }
            subCategory.setCharts(sections);
        } else if (type.equals("number")) {
            oldSections = subCategory.getNumbers();
            for (String sectionId : oldSections) {
                if (sections.contains(sectionId)) continue;
                sections.add(sectionId);
            }
            subCategory.setNumbers(sections);
        }
        ArrayList<Section> sectionsFull = new ArrayList<Section>();
        for (String sectionId : sections) {
            Section section = this.sectionDAO.findById(sectionId);
            if (section == null) {
                throw new EntityNotFoundException("Reorder sections: Section with id: " + sectionId + " not found");
            }
            sectionsFull.add(section);
        }
        this.subCategoryDAO.save(subCategory);
        this.log.debug((Object)"Sections reordered!");
        return sectionsFull;
    }

    public void toggleSection(String stakeholderId, String topicId, String categoryId, String subcategoryId, Section section) {
        SubCategory subCategory = this.checkForExceptions(stakeholderId, topicId, categoryId, subcategoryId);
        List sections = null;
        if (section.getType().equals("chart")) {
            sections = subCategory.getCharts();
        } else if (section.getType().equals("number")) {
            sections = subCategory.getNumbers();
        }
        if (!sections.contains(section.getId())) {
            throw new PathNotValidException("Toggle section: Section with id: " + section.getId() + " not found in SubCategory: " + subcategoryId);
        }
        this.sectionDAO.save(section);
        this.log.debug((Object)"Section toggled!");
    }

    private SubCategory checkForExceptions(String stakeholderId, String topicId, String categoryId, String subcategoryId) {
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder == null) {
            throw new EntityNotFoundException("Save indicator: Stakeholder with id: " + stakeholderId + " not found");
        }
        List roles = this.rolesUtils.getRoles();
        if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
            throw new ForbiddenException("CheckForExceptions Section: You are not authorized to update stakeholder with id: " + stakeholderId);
        }
        Topic topic = this.topicDAO.findById(topicId);
        if (topic == null) {
            throw new EntityNotFoundException("Save indicator: Topic with id: " + topicId + " not found");
        }
        if (!stakeholder.getTopics().contains(topicId)) {
            throw new PathNotValidException("Save indicator: Topic with id: " + topicId + " not found in Stakeholder: " + stakeholderId);
        }
        Category category = this.categoryDAO.findById(categoryId);
        if (category == null) {
            throw new EntityNotFoundException("Save indicator: Category with id: " + categoryId + " not found");
        }
        if (!topic.getCategories().contains(categoryId)) {
            throw new PathNotValidException("Save indicator: Category with id: " + categoryId + " not found in Topic: " + topicId);
        }
        SubCategory subcategory = this.subCategoryDAO.findById(subcategoryId);
        if (subcategory == null) {
            throw new EntityNotFoundException("Save indicator: SubCategory with id: " + subcategoryId + " not found");
        }
        if (!category.getSubCategories().contains(subcategoryId)) {
            throw new PathNotValidException("Save indicator: SubCategory with id: " + subcategoryId + " not found in Category: " + categoryId);
        }
        return subcategory;
    }

    public void deleteTree(SubCategory subCategory) {
        Section section;
        List sections = subCategory.getCharts();
        for (String sectionId : sections) {
            section = this.sectionDAO.findById(sectionId);
            if (section == null) {
                throw new EntityNotFoundException("Section delete tree: Chart Section with id: " + sectionId + " not found (section exists in subCategory: " + subCategory.getId() + ")");
            }
            this.indicatorController.deleteTree(section);
            this.sectionDAO.delete(sectionId);
        }
        sections = subCategory.getNumbers();
        for (String sectionId : sections) {
            section = this.sectionDAO.findById(sectionId);
            if (section == null) {
                throw new EntityNotFoundException("Section delete tree: Number Section with id: " + sectionId + " not found (section exists in subCategory: " + subCategory.getId() + ")");
            }
            this.indicatorController.deleteTree(section);
            this.sectionDAO.delete(sectionId);
        }
    }

    public void disConnectTree(SubCategory subCategory) {
        Section section;
        List sections = subCategory.getCharts();
        for (String sectionId : sections) {
            section = this.sectionDAO.findById(sectionId);
            if (section == null) {
                throw new EntityNotFoundException("Section disconnect tree: Chart Section with id: " + sectionId + " not found (section exists in subCategory: " + subCategory.getId() + ")");
            }
            this.indicatorController.disConnectTree(section);
            section.setDefaultId(null);
            this.sectionDAO.save(section);
        }
        sections = subCategory.getNumbers();
        for (String sectionId : sections) {
            section = this.sectionDAO.findById(sectionId);
            if (section == null) {
                throw new EntityNotFoundException("Section disconnect tree: Number Section with id: " + sectionId + " not found (section exists in subCategory: " + subCategory.getId() + ")");
            }
            this.indicatorController.disConnectTree(section);
            section.setDefaultId(null);
            this.sectionDAO.save(section);
        }
    }

    public Section changeVisibilityTree(String sectionId, Visibility visibility) {
        Section section = this.sectionDAO.findById(sectionId);
        if (section == null) {
            throw new EntityNotFoundException("Change section visibility: Section with id: " + sectionId + " not found");
        }
        Section sectionFull = new Section(section);
        ArrayList<Indicator> indicatorsFull = new ArrayList<Indicator>();
        for (String indicatorId : section.getIndicators()) {
            indicatorsFull.add(this.indicatorController.changeVisibilityTree(indicatorId, null, visibility));
        }
        sectionFull.setIndicators(indicatorsFull);
        return sectionFull;
    }
}

