/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.handlers;

import eu.dnetlib.uoaadmintoolslibrary.responses.ExceptionResponse;
import eu.dnetlib.uoamonitorservice.handlers.EntityNotFoundException;
import eu.dnetlib.uoamonitorservice.handlers.PathNotValidException;
import org.apache.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;

@ControllerAdvice
@RestController
public class ExceptionsHandler {
    private final Logger log = Logger.getLogger(this.getClass());

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<ExceptionResponse> entityNotFoundException(Exception ex) {
        ExceptionResponse response = new ExceptionResponse();
        response.setErrorCode("Not found Exception");
        response.setErrorMessage("Entity not found Exception");
        response.setErrors(ex.getMessage());
        response.setStatus(HttpStatus.NOT_FOUND);
        this.log.error((Object)("entityNotFoundException exception : " + ex.getMessage()));
        return new ResponseEntity((Object)response, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={PathNotValidException.class})
    public ResponseEntity<ExceptionResponse> pathNotValidException(Exception ex) {
        ExceptionResponse response = new ExceptionResponse();
        response.setErrorCode("Not found Exception");
        response.setErrorMessage("Path not valid Exception");
        response.setErrors(ex.getMessage());
        response.setStatus(HttpStatus.NOT_FOUND);
        this.log.error((Object)("pathNotValidException exception : " + ex.getMessage()));
        return new ResponseEntity((Object)response, HttpStatus.NOT_FOUND);
    }
}

