/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.server.services;

import eu.dnetlib.api.functionality.ValidatorService;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.gwt.server.service.SpringGwtRemoteServiceServlet;
import eu.dnetlib.repo.manager.client.services.ValidationService;
import eu.dnetlib.repo.manager.server.utils.EmailUtils;
import eu.dnetlib.repo.manager.service.controllers.MonitorApi;
import eu.dnetlib.repo.manager.service.controllers.ValidatorApi;
import eu.dnetlib.repo.manager.shared.InterfaceInformation;
import eu.dnetlib.repo.manager.shared.JobsOfUser;
import eu.dnetlib.repo.manager.shared.ValidationServiceException;
import gr.uoa.di.driver.util.ServiceLocator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="validationService")
public class ValidationServiceImpl
extends SpringGwtRemoteServiceServlet
implements ValidationService {
    private static final Logger LOGGER = Logger.getLogger(ValidationServiceImpl.class);
    @Autowired
    private EmailUtils emailUtils;
    @Value(value="${services.repo-manager.deploy.environment}")
    private String deployEnvironment;
    private ServiceLocator<ValidatorService> validatorServiceLocator;
    @Autowired
    private ValidatorApi validatorApi;
    @Autowired
    private MonitorApi monitorApi;

    public void init(ServletConfig config) throws ServletException {
        LOGGER.info((Object)"initializing validation service impl ");
        super.init(config);
    }

    @PostConstruct
    public void initRulesets() {
    }

    public List<String> getSets(String baseUrl) throws ValidationServiceException {
        return this.validatorApi.getSetsOfRepository(baseUrl);
    }

    public Boolean identifyRepository(String baseUrl) throws ValidationServiceException {
        return this.validatorApi.identifyRepo(baseUrl);
    }

    public InterfaceInformation getInterfaceInformation(String baseUrl) throws ValidationServiceException {
        try {
            LOGGER.debug((Object)("Getting interface information with url: " + baseUrl));
            InterfaceInformation interfaceInformation = new InterfaceInformation();
            interfaceInformation.setIdentified(this.identifyRepository(baseUrl).booleanValue());
            if (interfaceInformation.isIdentified()) {
                interfaceInformation.setSets(this.getSets(baseUrl));
            }
            return interfaceInformation;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error getting interface information with url: " + baseUrl), (Throwable)e);
            throw new ValidationServiceException("login.generalError", ValidationServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public List<RuleSet> getRuleSets(String validationMode) throws ValidationServiceException {
        try {
            return this.validatorApi.getRuleSets(validationMode);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error getting rulesets", (Throwable)e);
            this.emailUtils.reportException(e);
            throw new ValidationServiceException("login.generalError", ValidationServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public RuleSet getRuleSet(String acronym) throws ValidationServiceException {
        return this.validatorApi.getRuleSet(acronym);
    }

    public void submitValidationJob(JobForValidation job) throws ValidationServiceException {
        try {
            this.validatorApi.submitJobForValidation(job);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while submitting validation job", (Throwable)e);
            this.emailUtils.reportException(e);
            throw new ValidationServiceException("login.generalError", ValidationServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public void reSubmitValidationJob(int jobId) throws ValidationServiceException {
        try {
            this.validatorApi.reSubmitJobForValidation(String.valueOf(jobId));
        }
        catch (JSONException e) {
            LOGGER.error((Object)"Error while re-submitting validation job", (Throwable)e);
            this.emailUtils.reportException((Exception)((Object)e));
            throw new ValidationServiceException("login.generalError", ValidationServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public StoredJob getJobSummary(int jobId, String groupBy) throws ValidationServiceException {
        try {
            return this.monitorApi.getJobSummary(String.valueOf(jobId), groupBy);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error getting job summary for id: " + jobId), (Throwable)e);
            this.emailUtils.reportException(e);
            throw new ValidationServiceException("login.generalError", ValidationServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public List<StoredJob> getJobsOfUser(String user, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo, String validationStatus) throws ValidationServiceException {
        try {
            LOGGER.debug((Object)("getting jobs of user " + user));
            List jobs = this.getValidationService().getStoredJobsNew(user, jobType, offset, limit, dateFrom, dateTo, validationStatus);
            return jobs;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error getting jobs of user " + user), (Throwable)e);
            this.emailUtils.reportException(e);
            throw new ValidationServiceException("login.generalError", ValidationServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public int getJobsTotalNumberOfUser(String user, String jobType, String validationStatus) throws ValidationServiceException {
        try {
            LOGGER.debug((Object)("getting jobs of user " + user));
            int sum = this.getValidationService().getStoredJobsTotalNumberNew(user, jobType, validationStatus);
            return sum;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error getting jobs of user " + user), (Throwable)e);
            this.emailUtils.reportException(e);
            throw new ValidationServiceException("login.generalError", ValidationServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public JobsOfUser getJobsOfUser(String user, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo, String validationStatus, boolean includeJobsTotal) throws ValidationServiceException {
        try {
            LOGGER.debug((Object)("getting jobs of user " + user + " totalJobs included: " + includeJobsTotal));
            JobsOfUser retJobs = new JobsOfUser();
            return this.monitorApi.getJobsOfUser(user, jobType, String.valueOf(offset), String.valueOf(limit), dateFrom, dateTo, validationStatus, String.valueOf(includeJobsTotal));
        }
        catch (Exception e) {
            LOGGER.error((Object)("getting jobs of user " + user + " totalJobs included: " + includeJobsTotal), (Throwable)e);
            throw new ValidationServiceException("login.generalError", ValidationServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    private ValidatorService getValidationService() {
        return (ValidatorService)this.validatorServiceLocator.getService();
    }

    public ServiceLocator<ValidatorService> getValidatorServiceLocator() {
        return this.validatorServiceLocator;
    }

    public void setValidatorServiceLocator(ServiceLocator<ValidatorService> validatorServiceLocator) {
        this.validatorServiceLocator = validatorServiceLocator;
    }
}

