package eu.dnetlib.repo.manager.client.datasources.update;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.client.widgets.ListOrGridViewOfDatasourcesWidget;
import eu.dnetlib.repo.manager.client.widgets.OpenAIRECompliantLogoDownloadWidget;
import eu.dnetlib.repo.manager.shared.DatasourcesCollection;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.IconPosition;
import org.gwtbootstrap3.client.ui.constants.IconType;

/**
 * Created by stefania on 1/14/16.
 */
public class SelectFromMyRepositoriesWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private FlowPanel myRepositoriesListBoxContent = new FlowPanel();

    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);
    private static HelpServiceAsync helpService = GWT.create(HelpService.class);

    public SelectFromMyRepositoriesWidget() {

        super();

        HTML title = new HTML("<h1 class=\"uk-article-title\">Manage your datasources</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);
        contentPanel.add(myRepositoriesListBoxContent);
    }

    @Override
    public void clear() {
        myRepositoriesListBoxContent.clear();
        gridPanel.remove(helpPanel);
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        helpService.getHelpById(parentToken, new HelpCallback(helpPanel, gridPanel));

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving repositories...</div>" +
                "<div class=\"whiteFilm\"></div>");
        myRepositoriesListBoxContent.addStyleName("loading-big");
        myRepositoriesListBoxContent.add(loadingWheel);

            repositoryService.getRepositoriesOfUser(RepositoryManager.currentUser.getEmail(), true, false,
                new AsyncCallback<DatasourcesCollection>() {

            @Override
            public void onFailure(Throwable caught) {

                myRepositoriesListBoxContent.removeStyleName("loading-big");
                myRepositoriesListBoxContent.remove(loadingWheel);

                Alert errorAlert = new Alert();
                errorAlert.setType(AlertType.DANGER);
                errorAlert.setText("System error retrieving repositories.");
                errorAlert.setDismissable(false);
                myRepositoriesListBoxContent.add(errorAlert);
            }

            @Override
            public void onSuccess(DatasourcesCollection datasourcesCollection) {

                myRepositoriesListBoxContent.removeStyleName("loading-big");
                myRepositoriesListBoxContent.remove(loadingWheel);

                ListOrGridViewOfDatasourcesWidget listOrGridViewOfDatasourcesWidget =
                        new ListOrGridViewOfDatasourcesWidget(datasourcesCollection, "Choose the Datasource you would like to manage",
                                parentToken, "<i class=\"fa fa-pencil\" aria-hidden=\"true\"></i>", false);

                myRepositoriesListBoxContent.add(listOrGridViewOfDatasourcesWidget.asWidget());

                OpenAIRECompliantLogoDownloadWidget openAIRECompliantLogoDownloadWidget = new OpenAIRECompliantLogoDownloadWidget();
                myRepositoriesListBoxContent.add(openAIRECompliantLogoDownloadWidget.asWidget());


            }
        });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }
}
