package eu.dnetlib.repo.manager.client.widgets.wizard;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.IconPosition;
import org.gwtbootstrap3.client.ui.constants.IconType;

/**
 * Created by stefania on 12/17/15.
 */
public class NavigationWidget implements IsWidget {

    private FlowPanel fundingNavigationPanel = new FlowPanel();

    private Button back = new Button();
    private Button next = new Button();

    private int currentActiveStep = 0;

    private NextButtonListener nextButtonListener;
    private BackButtonListener backButtonListener;

    public NavigationWidget() {

        fundingNavigationPanel.addStyleName("wizardActions");

        back.setText("Back");
        back.addStyleName("btn-grey-light");
        back.removeStyleName("btn-default");
        back.setIcon(IconType.ANGLE_DOUBLE_LEFT);
        back.setIconPosition(IconPosition.LEFT);
        back.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                fireBackEvent();
            }
        });

        next.setText("Next Step");
        next.addStyleName("btn-grey-light");
        next.removeStyleName("btn-default");
        next.setIcon(IconType.ANGLE_DOUBLE_RIGHT);
        next.setIconPosition(IconPosition.RIGHT);
        next.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                fireNextEvent();
            }
        });

        fundingNavigationPanel.add(back);
        fundingNavigationPanel.add(next);
    }


    @Override
    public Widget asWidget() {
        return fundingNavigationPanel;
    }

    public void setActiveStep(int stepNumber) {

        currentActiveStep = stepNumber;

        if(currentActiveStep==0)
            fundingNavigationPanel.remove(back);
        else
            fundingNavigationPanel.insert(back, 0);
    }

    public void hideNavigationButtons() {
        fundingNavigationPanel.clear();
    }

    public void setNextButtonText(String text) {
        next.setText(text);
    }

    public interface NextButtonListener {
        void nextClicked(int newActiveStep);
    }

    public void setNextButtonListener(NextButtonListener nextButtonListener) {
        this.nextButtonListener = nextButtonListener;
    }

    public interface BackButtonListener {
        void backClicked(int newActiveStep);
    }

    public void setBackButtonListener(BackButtonListener backButtonListener) {
        this.backButtonListener = backButtonListener;
    }

    private void fireNextEvent() {
        if(nextButtonListener !=null) {
            nextButtonListener.nextClicked(currentActiveStep+1);
        }
    }

    private void fireBackEvent() {
        if(backButtonListener !=null) {
            backButtonListener.backClicked(currentActiveStep-1);
        }
    }
}
