/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.admin.metrics;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.query.client.Function;
import com.google.gwt.query.client.GQuery;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.PiwikInfo;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import java.util.List;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;

public class MetricsAdminWidget
extends AbstractRepositoryManagerWidget
implements RepositoryManagerWidget {
    private String parentToken = "";
    private String restToken = "";
    private FlowPanel metricsAdminBoxContent = new FlowPanel();
    private Alert errorAlert = new Alert();
    private static HelpServiceAsync helpService = (HelpServiceAsync)GWT.create(HelpService.class);
    private static RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
    private DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd");

    public MetricsAdminWidget() {
        HTML title = new HTML("<h1 class=\"uk-article-title\">Metrics Admin</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        this.contentPanel.add((Widget)title);
        this.errorAlert.setType(AlertType.DANGER);
        this.errorAlert.setDismissable(false);
        this.errorAlert.setVisible(false);
        this.metricsAdminBoxContent.add((Widget)this.errorAlert);
        this.contentPanel.add((Widget)this.metricsAdminBoxContent);
    }

    public void clear() {
        this.metricsAdminBoxContent.clear();
        this.errorAlert.setVisible(false);
        this.gridPanel.remove((Widget)this.helpPanel);
    }

    public void reload() {
        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        this.metricsAdminBoxContent.add((Widget)this.errorAlert);
        helpService.getHelpById(this.parentToken, (AsyncCallback)new HelpCallback(this.helpPanel, this.gridPanel));
        HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; color: rgb(47, 64, 80); font-weight: bold;\">Retrieving piwik sites info...</div><div class=\"whiteFilm\"></div>");
        this.metricsAdminBoxContent.addStyleName("loading-big");
        this.metricsAdminBoxContent.add((Widget)loadingWheel);
        repositoryService.getPiwikSitesForRepositories((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    public void afterAdditionToRootPanel() {
    }

    private void addWidgetHandlers() {
        GQuery.$((String)".validate").click(new Function[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void createPiwikSitesInfoList(List<PiwikInfo> results, FlowPanel piwikInfosPanel) {
        if (results.isEmpty()) {
            piwikInfosPanel.add((Widget)new HTML("There are no piwik sites available yet."));
        } else {
            FlowPanel colPanel = new FlowPanel();
            colPanel.addStyleName("uk-width-1-1@m uk-first-column uk-margin-medium-bottom");
            piwikInfosPanel.add((Widget)colPanel);
            FlowPanel divPanel = new FlowPanel();
            divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");
            colPanel.add((Widget)divPanel);
            String content = "<table class=\"uk-table uk-table-striped uk-table-middle\" style=\"font-size: 12px\"><thead><tr><th class=\"uk-text-nowrap\">Repository</th><th class=\"uk-text-nowrap\">Piwik site</th><th class=\"uk-text-nowrap\">Requested on</th><th class=\"uk-text-nowrap\">Requestor</th><th class=\"uk-text-nowrap\">Validated</th><th class=\"uk-text-nowrap\">Actions</th></tr></thead>";
            content = content + "<tbody>";
            for (PiwikInfo piwikInfo : results) {
                content = content + "<tr class=\"el-item\">";
                content = content + "<td class=\"uk-table-shrink\">";
                content = piwikInfo.getRepositoryName() != null && !piwikInfo.getRepositoryName().trim().equals("") ? content + "<div class=\"el-title\">" + piwikInfo.getRepositoryName() + "</div>" : content + "--";
                content = piwikInfo.getCountry() != null && !piwikInfo.getCountry().trim().equals("") ? content + "<div class=\"el-title\">" + piwikInfo.getCountry() + "</div>" : content + "--";
                content = piwikInfo.getRepositoryId() != null && !piwikInfo.getRepositoryId().trim().equals("") ? content + "<div class=\"el-title\">(ID: " + piwikInfo.getRepositoryId() + ")</div>" : content + "--";
                content = content + "</td>";
                content = content + "<td class=\"uk-table-shrink\">";
                content = piwikInfo.getSiteId() != null && !piwikInfo.getSiteId().trim().equals("") ? content + "<div class=\"el-title\">ID: " + piwikInfo.getSiteId() + "</div>" : content + "--";
                content = piwikInfo.getAuthenticationToken() != null && !piwikInfo.getAuthenticationToken().trim().equals("") ? content + "<div class=\"el-title\">Authentication token: " + piwikInfo.getAuthenticationToken() + "</div>" : content + "--";
                content = content + "</td>";
                content = piwikInfo.getCreationDate() != null ? content + "<td class=\"uk-text-nowrap uk-table-shrink\"><div class=\"el-title\">" + this.dtf.format(piwikInfo.getCreationDate()) + "</div></td>" : content + "<td class=\"uk-text-nowrap uk-table-shrink\"><div class=\"el-title\">--</div></td>";
                content = content + "<td class=\"uk-text-nowrap uk-table-shrink\">";
                content = piwikInfo.getRequestorName() != null && !piwikInfo.getRequestorName().trim().equals("") ? content + "<div class=\"el-title\">" + piwikInfo.getRequestorName() + "</div>" : content + "--";
                content = piwikInfo.getRequestorEmail() != null && !piwikInfo.getRequestorEmail().trim().equals("") ? content + "<div class=\"el-title\">" + piwikInfo.getRequestorEmail() + "</div>" : content + "--";
                content = content + "</td>";
                if (piwikInfo.isValidated()) {
                    content = content + "<td class=\"uk-text-nowrap uk-table-shrink\">";
                    content = content + "<div class=\"el-title\">YES</div>";
                    if (piwikInfo.getValidationDate() != null) {
                        content = content + "<div class=\"el-title\">on " + this.dtf.format(piwikInfo.getValidationDate()) + "</div>";
                    }
                    content = content + "</td>";
                } else {
                    content = content + "<td class=\"uk-text-nowrap uk-table-shrink\"><div class=\"el-title\">NO</div></td>";
                }
                content = content + "<td class=\"uk-text-nowrap uk-table-shrink\">";
                if (!piwikInfo.isValidated()) {
                    content = content + "<a href=\"javascript:;\" id=\"" + piwikInfo.getRepositoryId() + "#validate\" class=\"uk-button uk-button-primary validate\">Validate</button>";
                }
                content = content + "</td></tr>";
            }
            content = content + "</tbody></table>";
            HTML reposListHTML = new HTML();
            reposListHTML.setHTML(content);
            divPanel.add((Widget)reposListHTML);
        }
        this.addWidgetHandlers();
    }

    private void validatePiwikSites(List<String> repositoryIds) {
        Modal approvePiwikSitesConfirmationPopup = new Modal();
        approvePiwikSitesConfirmationPopup.setDataBackdrop(ModalBackdrop.STATIC);
        FlowPanel modalContent = new FlowPanel();
        HTML description = new HTML("<h2 class=\"uk-modal-title\">Approval Confirmation</h2>\n<p>Are you sure you want to validate the selected piwik site(s)?</p>");
        modalContent.add((Widget)description);
        FlowPanel actionButtons = new FlowPanel();
        actionButtons.addStyleName("uk-text-right");
        modalContent.add((Widget)actionButtons);
        Button no = new Button("Cancel");
        no.setType(ButtonType.DEFAULT);
        no.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        actionButtons.add((Widget)no);
        Button yes = new Button("Yes, validate");
        yes.setType(ButtonType.PRIMARY);
        yes.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        actionButtons.add((Widget)yes);
        ModalBody modalBody = new ModalBody();
        modalBody.add((Widget)modalContent);
        approvePiwikSitesConfirmationPopup.add((Widget)modalBody);
        approvePiwikSitesConfirmationPopup.getElement().getChild(0).getChild(0).getChild(0).removeFromParent();
        approvePiwikSitesConfirmationPopup.show();
    }

    static /* synthetic */ FlowPanel access$000(MetricsAdminWidget x0) {
        return x0.metricsAdminBoxContent;
    }

    static /* synthetic */ Alert access$100(MetricsAdminWidget x0) {
        return x0.errorAlert;
    }

    static /* synthetic */ void access$200(MetricsAdminWidget x0, List x1, FlowPanel x2) {
        x0.createPiwikSitesInfoList(x1, x2);
    }

    static /* synthetic */ void access$300(MetricsAdminWidget x0, List x1) {
        x0.validatePiwikSites(x1);
    }

    static /* synthetic */ RepositoryServiceAsync access$400() {
        return repositoryService;
    }
}

