/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.browsehistory;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.query.client.GQuery;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.ValidationService;
import eu.dnetlib.repo.manager.client.services.ValidationServiceAsync;
import eu.dnetlib.repo.manager.shared.JobsOfUser;
import java.util.ArrayList;
import java.util.List;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.Pager;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.UnorderedList;

public class BrowseHistoryWidget
extends AbstractRepositoryManagerWidget
implements RepositoryManagerWidget {
    private String parentToken = "";
    private String restToken = "";
    private Alert errorAlert = new Alert();
    private Alert successAlert = new Alert();
    private Alert warningAlert = new Alert();
    private FlowPanel myHistoryListBoxContent = new FlowPanel();
    private FlowPanel controlsPanel = new FlowPanel();
    private FlowPanel contentAndPagerPanel = new FlowPanel();
    private FlowPanel topPagerPanel = new FlowPanel();
    private Pager resultsPagerTop = new Pager();
    private Label pageNumberTop = new Label();
    private FlowPanel jobsListContentPanel = new FlowPanel();
    private FlowPanel bottomPagerPanel = new FlowPanel();
    private Pager resultsPagerBottom = new Pager();
    private Label pageNumberBottom = new Label();
    private ListBox validationJobTypesListBox = new ListBox();
    private ListBox jobsPerPageListBox = new ListBox();
    private int jobTypeSelectedIndex = 0;
    private int jobsPerPageSelectedIndex = 0;
    private String jobStatusSelected = "all";
    private int currentPage = 1;
    private List<StoredJob> storedJobs = new ArrayList();
    private List<StoredJob> finishedStoredJobs = new ArrayList();
    private List<StoredJob> failedStoredJobs = new ArrayList();
    private List<StoredJob> pendingStoredJobs = new ArrayList();
    private JobsOfUser jobsOfUser = null;
    private ValidationServiceAsync validationService = (ValidationServiceAsync)GWT.create(ValidationService.class);
    private static HelpServiceAsync helpService = (HelpServiceAsync)GWT.create(HelpService.class);

    public BrowseHistoryWidget() {
        HTML title = new HTML("<h1 class=\"uk-article-title\">Previous validations</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        this.contentPanel.add((Widget)title);
        this.contentPanel.add((Widget)this.myHistoryListBoxContent);
        this.errorAlert.setType(AlertType.DANGER);
        this.errorAlert.setVisible(false);
        this.errorAlert.setDismissable(false);
        this.myHistoryListBoxContent.add((Widget)this.errorAlert);
        this.successAlert.setType(AlertType.SUCCESS);
        this.successAlert.setVisible(false);
        this.successAlert.setDismissable(false);
        this.myHistoryListBoxContent.add((Widget)this.successAlert);
        this.warningAlert.setType(AlertType.WARNING);
        this.warningAlert.setVisible(false);
        this.warningAlert.setDismissable(false);
        this.myHistoryListBoxContent.add((Widget)this.warningAlert);
        this.myHistoryListBoxContent.add((Widget)this.controlsPanel);
        this.myHistoryListBoxContent.add((Widget)this.contentAndPagerPanel);
        this.contentAndPagerPanel.addStyleName("contentAndPagerPanel");
        this.resultsPagerTop.addStyleName("resultsPager");
        this.resultsPagerTop.setAlignToSides(true);
        this.resultsPagerTop.setPreviousIcon(IconType.LONG_ARROW_LEFT);
        this.resultsPagerTop.setNextIcon(IconType.LONG_ARROW_RIGHT);
        this.resultsPagerTop.addPreviousClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.resultsPagerTop.addNextClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.resultsPagerBottom.addStyleName("resultsPager");
        this.resultsPagerBottom.setAlignToSides(true);
        this.resultsPagerBottom.setPreviousIcon(IconType.LONG_ARROW_LEFT);
        this.resultsPagerBottom.setNextIcon(IconType.LONG_ARROW_RIGHT);
        this.resultsPagerBottom.addPreviousClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.resultsPagerBottom.addNextClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.contentAndPagerPanel.add((Widget)this.topPagerPanel);
        this.contentAndPagerPanel.add((Widget)this.jobsListContentPanel);
        this.contentAndPagerPanel.add((Widget)this.bottomPagerPanel);
        this.controlsPanel.addStyleName("uk-grid");
        this.controlsPanel.addStyleName("page-controls");
        this.validationJobTypesListBox.addItem("-- none selected --", "noneSelected");
        this.validationJobTypesListBox.addItem("Compatibility Test", "Compatibility Test");
        this.validationJobTypesListBox.addItem("Registration Request", "Registration Request");
        this.validationJobTypesListBox.addItem("Workflow Request", "Workflow Request");
        this.validationJobTypesListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.jobsPerPageListBox.addItem("10", "10");
        this.jobsPerPageListBox.addItem("25", "25");
        this.jobsPerPageListBox.addItem("50", "50");
        this.jobsPerPageListBox.addItem("100", "100");
        this.jobsPerPageListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void clear() {
        this.errorAlert.setVisible(false);
        this.successAlert.setVisible(false);
        this.warningAlert.setVisible(false);
        this.controlsPanel.clear();
        this.topPagerPanel.clear();
        this.jobsListContentPanel.clear();
        this.bottomPagerPanel.clear();
        this.gridPanel.remove((Widget)this.helpPanel);
        this.validationJobTypesListBox.setSelectedIndex(0);
        this.jobsPerPageListBox.setSelectedIndex(0);
        this.jobTypeSelectedIndex = 0;
        this.jobsPerPageSelectedIndex = 0;
        this.jobStatusSelected = "all";
        this.currentPage = 1;
        this.jobsOfUser = null;
    }

    public void reload() {
        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        helpService.getHelpById(this.parentToken, (AsyncCallback)new HelpCallback(this.helpPanel, this.gridPanel));
        this.getStoredJobs(RepositoryManager.currentUser.getEmail(), null, Integer.valueOf(0), Integer.valueOf(10), null, null, null, true);
    }

    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    public void afterAdditionToRootPanel() {
    }

    private void getStoredJobs(String user, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo, String jobStatus, boolean includeJobsTotal) {
        this.errorAlert.setVisible(false);
        this.successAlert.setVisible(false);
        this.warningAlert.setVisible(false);
        HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; color: rgb(47, 64, 80); font-weight: bold;\">Retrieving validation history...</div><div class=\"whiteFilm\"></div>");
        this.myHistoryListBoxContent.addStyleName("loading-big");
        this.myHistoryListBoxContent.add((Widget)loadingWheel);
        this.validationService.getJobsOfUser(user, jobType, offset, limit, dateFrom, dateTo, jobStatus, includeJobsTotal, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateControls(JobsOfUser jobsOfUser) {
        this.controlsPanel.clear();
        FlowPanel firstRowFilters = new FlowPanel();
        firstRowFilters.addStyleName("uk-margin-bottom uk-width-1-1");
        firstRowFilters.addStyleName("filters");
        this.controlsPanel.add((Widget)firstRowFilters);
        FlowPanel jobTypeSelection = new FlowPanel();
        jobTypeSelection.addStyleName("links");
        firstRowFilters.add((Widget)jobTypeSelection);
        Label jobTypeFilterLabel = new Label("Filter by job type:");
        jobTypeFilterLabel.addStyleName("filterLabel");
        jobTypeSelection.add((Widget)jobTypeFilterLabel);
        FlowPanel jobTypeFilterListBoxPanel = new FlowPanel();
        jobTypeFilterListBoxPanel.addStyleName("inlineBlock");
        this.validationJobTypesListBox.setSelectedIndex(this.jobTypeSelectedIndex);
        jobTypeFilterListBoxPanel.add((Widget)this.validationJobTypesListBox);
        jobTypeSelection.add((Widget)jobTypeFilterListBoxPanel);
        FlowPanel secondRowFilters = new FlowPanel();
        secondRowFilters.addStyleName("uk-margin-bottom uk-width-1-1");
        secondRowFilters.addStyleName("filters");
        this.controlsPanel.add((Widget)secondRowFilters);
        FlowPanel links = new FlowPanel();
        links.addStyleName("links uk-inline");
        secondRowFilters.add((Widget)links);
        Label filterLabel = new Label("Filter validation jobs:");
        filterLabel.addStyleName("filterLabel");
        links.add((Widget)filterLabel);
        Anchor allJobsLink = new Anchor();
        allJobsLink.setText("All Jobs (" + jobsOfUser.getTotalJobs() + ")");
        if (this.jobStatusSelected.equals("all")) {
            allJobsLink.addStyleName("active");
        }
        links.add((Widget)allJobsLink);
        Anchor successfulQuestionsLink = new Anchor();
        successfulQuestionsLink.setText("successful (" + jobsOfUser.getTotalJobsSuccessful() + ")");
        if (this.jobStatusSelected.equals("successful")) {
            successfulQuestionsLink.addStyleName("active");
        }
        links.add((Widget)successfulQuestionsLink);
        Anchor failedQuestionsLink = new Anchor();
        failedQuestionsLink.setText("failed (" + jobsOfUser.getTotalJobsFailed() + ")");
        if (this.jobStatusSelected.equals("failed")) {
            failedQuestionsLink.addStyleName("active");
        }
        links.add((Widget)failedQuestionsLink);
        Anchor pendingQuestionsLink = new Anchor();
        pendingQuestionsLink.setText("ongoing (" + jobsOfUser.getTotalJobsOngoing() + ")");
        if (this.jobStatusSelected.equals("ongoing")) {
            pendingQuestionsLink.addStyleName("active");
        }
        links.add((Widget)pendingQuestionsLink);
        allJobsLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        successfulQuestionsLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        failedQuestionsLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pendingQuestionsLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        FlowPanel actions = new FlowPanel();
        actions.addStyleName("show-options uk-inline");
        secondRowFilters.add((Widget)actions);
        Label jobsPerPageFilterLabel = new Label("Jobs per page:");
        jobsPerPageFilterLabel.addStyleName("filterLabel");
        actions.add((Widget)jobsPerPageFilterLabel);
        FlowPanel jobsPerPageListBoxPanel = new FlowPanel();
        jobsPerPageListBoxPanel.addStyleName("inlineBlock");
        this.jobsPerPageListBox.setSelectedIndex(this.jobsPerPageSelectedIndex);
        jobsPerPageListBoxPanel.add((Widget)this.jobsPerPageListBox);
        actions.add((Widget)jobsPerPageListBoxPanel);
    }

    public void updateContents(List<StoredJob> storedJobs) {
        this.jobsListContentPanel.clear();
        String contents = "<div class=\"uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium uk-margin-top uk-margin-bottom\"><table class=\"uk-table uk-table-middle jobs-list\"><thead><tr><th class=\"\">Repository</th><th class=\"\">Validation Type</th><th class=\"\">Status</th><th class=\"\">Score</th><th class=\"\">Started</th><th class=\"\">Guidelines</th><th class=\"\">Actions</th><th class=\"\"></th></tr></thead>";
        if (storedJobs == null || storedJobs.size() == 0) {
            contents = contents + "<tbody><tr class=\"el-item\"><td colspan=\"10\"><div class=\"alert alert-warning\">No stored jobs found</div></td></tr></tbody>";
        } else {
            contents = contents + "<tbody>";
            int counter = 1;
            for (StoredJob storedJob : storedJobs) {
                String parity = "";
                parity = counter % 2 == 1 ? "odd" : "even";
                if (storedJob.getValidationType().equals("CU")) {
                    contents = contents + "<tr class=\"el-item " + parity + "\"><td class=\"uk-table-shrink\" rowspan=\"2\"><div class=\"el-title\">" + storedJob.getBaseUrl() + "</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">OAI Content</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getContentJobStatus() + "</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getContentJobScore() + "</div></td><td class=\"uk-table-shrink\" rowspan=\"2\"><div class=\"el-title\">" + storedJob.getStarted() + "</div></td><td class=\"uk-table-shrink\" rowspan=\"2\"><div class=\"el-title\">" + storedJob.getGuidelinesShortName() + "</div></td>";
                    contents = contents + "<td class=\"uk-table-shrink\" rowspan=\"2\"><div class=\"el-link actions\" href=\"#\"><div class=\"viewDetailsLinkWrapper\"><a href=\"#" + this.parentToken + "/" + storedJob.getId() + "\"  id=\"" + storedJob.getId() + "#viewDetails\" class=\"viewDetails\">View Results<i class=\"fa fa-angle-right\"></i></a></div><div><a id=\"" + storedJob.getId() + "#resubmit\" class=\"resubmitJob\">Resubmit<i class=\"fa fa-repeat\" aria-hidden=\"true\"></i></a></div></div></td>";
                    if (storedJob.getValidationStatus().equals("successful")) {
                        contents = contents + "<td class=\"uk-table-shrink\" rowspan=\"2\"><input width=\"20\" type=\"image\" height=\"20\" title=\"Successfull\" src=\"img/icon_colours-check.jpg\"></td>";
                    } else if (storedJob.getValidationStatus().equals("failed")) {
                        contents = contents + "<td class=\"uk-table-shrink\" rowspan=\"2\"><input width=\"20\" type=\"image\" height=\"20\" title=\"Successfull\" src=\"img/icon_colours-x.jpg\"></td>";
                    } else if (storedJob.getValidationStatus().equals("ongoing")) {
                        contents = contents + "<td class=\"uk-table-shrink\" rowspan=\"2\"><input width=\"20\" type=\"image\" height=\"20\" title=\"Ongoing\" src=\"img/icon_colours-question.jpg\"></td>";
                    }
                    contents = contents + "</tr>";
                    contents = contents + "<tr class=\"el-item " + parity + "\"><td class=\"uk-table-shrink\"><div class=\"el-title\">OAI Usage</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getUsageJobStatus() + "</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getUsageJobScore() + "</div></td></tr>";
                } else if (storedJob.getValidationType().equals("C")) {
                    contents = contents + "<tr class=\"el-item " + parity + "\"><td class=\"uk-table-shrink\"><div class=\"el-title\">OAI Content</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getContentJobStatus() + "</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getContentJobScore() + "</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getStarted() + "</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getBaseUrl() + "</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getGuidelinesShortName() + "</div></td>";
                    contents = contents + "<td class=\"uk-table-shrink\"><div class=\"el-link\" href=\"#\"><div class=\"viewDetailsLinkWrapper\"><a href=\"#" + this.parentToken + "/" + storedJob.getId() + "\"  id=\"" + storedJob.getId() + "#viewDetails\" class=\"viewDetails\">View Results<i class=\"fa fa-info\"></i><i class=\"fa fa-angle-right\"></i></a></div><div><a id=\"" + storedJob.getId() + "#resubmit\" class=\"uk-button uk-button-primary resubmitJob\"><i></i>Resubmit</a></div></div></td>";
                    if (storedJob.getValidationStatus().equals("successful")) {
                        contents = contents + "<td class=\"uk-table-shrink\"><input width=\"20\" type=\"image\" height=\"20\" title=\"Successfull\" src=\"img/check-icon.png\"></td>";
                    } else if (storedJob.getValidationStatus().equals("failed")) {
                        contents = contents + "<td class=\"uk-table-shrink\"><input width=\"20\" type=\"image\" height=\"20\" title=\"Successfull\" src=\"img/x-icon.png\"></td>";
                    }
                    contents = contents + "</tr>";
                } else {
                    contents = contents + "<tr class=\"el-item " + parity + "\"><td class=\"uk-table-shrink\"><div class=\"el-title\">OAI Usage</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getUsageJobStatus() + "</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getUsageJobScore() + "</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getStarted() + "</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getBaseUrl() + "</div></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + storedJob.getGuidelinesShortName() + "</div></td>";
                    contents = contents + "<td class=\"uk-table-shrink\"><div class=\"el-link\" href=\"#\"><div class=\"viewDetailsLinkWrapper\"><a href=\"#" + this.parentToken + "/" + storedJob.getId() + "\"  id=\"" + storedJob.getId() + "#viewDetails\" class=\"viewDetails\">View Results<i class=\"fa fa-info\"></i><i class=\"fa fa-angle-right\"></i></a></div><div><a id=\"" + storedJob.getId() + "#resubmit\" class=\"uk-button uk-button-primary resubmitJob\"><i></i>Resubmit</a></div></div></td>";
                    if (storedJob.getValidationStatus().equals("successful")) {
                        contents = contents + "<td class=\"uk-table-shrink\"><input width=\"20\" type=\"image\" height=\"20\" title=\"Successfull\" src=\"img/check-icon.png\"></td>";
                    } else if (storedJob.getValidationStatus().equals("failed")) {
                        contents = contents + "<td class=\"uk-table-shrink\"><input width=\"20\" type=\"image\" height=\"20\" title=\"Successfull\" src=\"img/x-icon.png\"></td>";
                    }
                    contents = contents + "</tr>";
                }
                ++counter;
            }
            contents = contents + "</tbody>";
        }
        contents = contents + "</table></div>";
        HTML questionsList = new HTML();
        questionsList.setHTML(contents);
        this.jobsListContentPanel.add((Widget)questionsList);
        this.addHandlers();
    }

    private void addHandlers() {
        GQuery.$((String)".resubmitJob").click(new Function[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void drawPager(FlowPanel pagerPanel) {
        pagerPanel.clear();
        int totalNoOfPages = 0;
        totalNoOfPages = this.jobStatusSelected.equals("all") ? (int)Math.ceil((double)this.jobsOfUser.getTotalJobs() / ((double)Integer.parseInt(this.jobsPerPageListBox.getSelectedValue()) * 1.0)) : (this.jobStatusSelected.equals("successful") ? (int)Math.ceil((double)this.jobsOfUser.getTotalJobsSuccessful() / ((double)Integer.parseInt(this.jobsPerPageListBox.getSelectedValue()) * 1.0)) : (this.jobStatusSelected.equals("failed") ? (int)Math.ceil((double)this.jobsOfUser.getTotalJobsFailed() / ((double)Integer.parseInt(this.jobsPerPageListBox.getSelectedValue()) * 1.0)) : (int)Math.ceil((double)this.jobsOfUser.getTotalJobsOngoing() / ((double)Integer.parseInt(this.jobsPerPageListBox.getSelectedValue()) * 1.0))));
        UnorderedList pager = new UnorderedList();
        pager.addStyleName("uk-pagination");
        ListItem listItemPrevious = new ListItem();
        Anchor previous = new Anchor();
        previous.setHTML("<span class=\"uk-margin-small-right\" uk-pagination-previous></span> Previous");
        previous.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        listItemPrevious.add((Widget)previous);
        pager.add((Widget)listItemPrevious);
        ListItem listItemNext = new ListItem();
        listItemNext.addStyleName("uk-margin-auto-left");
        Anchor next = new Anchor();
        next.setHTML("Next <span class=\"uk-margin-small-left\" uk-pagination-next></span>");
        next.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        listItemNext.add((Widget)next);
        pager.add((Widget)listItemNext);
        if (this.currentPage - 1 == 0) {
            previous.setEnabled(false);
            listItemPrevious.addStyleName("uk-disabled");
        } else {
            previous.setEnabled(true);
            listItemPrevious.removeStyleName("uk-disabled");
        }
        if (this.currentPage == totalNoOfPages) {
            next.setEnabled(false);
            listItemNext.addStyleName("uk-disabled");
        } else {
            next.setEnabled(true);
            listItemNext.removeStyleName("uk-disabled");
        }
        pagerPanel.add((Widget)pager);
        Label pageNumber = new Label();
        pageNumber.setText("page " + this.currentPage + " of " + totalNoOfPages);
        pageNumber.addStyleName("resultsPageLabel");
        pagerPanel.add((Widget)pageNumber);
    }

    private void previousPage() {
        String validationType = null;
        if (!this.validationJobTypesListBox.getSelectedValue().equals("noneSelected")) {
            validationType = this.validationJobTypesListBox.getSelectedValue();
        }
        String jobStatus = null;
        if (!this.jobStatusSelected.equals("all")) {
            jobStatus = this.jobStatusSelected;
        }
        --this.currentPage;
        int limit = Integer.parseInt(this.jobsPerPageListBox.getSelectedValue());
        int offset = (this.currentPage - 1) * limit;
        this.getStoredJobs(RepositoryManager.currentUser.getEmail(), validationType, Integer.valueOf(offset), Integer.valueOf(limit), null, null, jobStatus, true);
    }

    private void nextPage() {
        String validationType = null;
        if (!this.validationJobTypesListBox.getSelectedValue().equals("noneSelected")) {
            validationType = this.validationJobTypesListBox.getSelectedValue();
        }
        String jobStatus = null;
        if (!this.jobStatusSelected.equals("all")) {
            jobStatus = this.jobStatusSelected;
        }
        ++this.currentPage;
        int limit = Integer.parseInt(this.jobsPerPageListBox.getSelectedValue());
        int offset = (this.currentPage - 1) * limit;
        this.getStoredJobs(RepositoryManager.currentUser.getEmail(), validationType, Integer.valueOf(offset), Integer.valueOf(limit), null, null, jobStatus, true);
    }

    static /* synthetic */ void access$000(BrowseHistoryWidget x0) {
        x0.previousPage();
    }

    static /* synthetic */ void access$100(BrowseHistoryWidget x0) {
        x0.nextPage();
    }

    static /* synthetic */ int access$202(BrowseHistoryWidget x0, int x1) {
        x0.jobTypeSelectedIndex = x1;
        return x0.jobTypeSelectedIndex;
    }

    static /* synthetic */ ListBox access$300(BrowseHistoryWidget x0) {
        return x0.validationJobTypesListBox;
    }

    static /* synthetic */ String access$400(BrowseHistoryWidget x0) {
        return x0.jobStatusSelected;
    }

    static /* synthetic */ ListBox access$500(BrowseHistoryWidget x0) {
        return x0.jobsPerPageListBox;
    }

    static /* synthetic */ void access$600(BrowseHistoryWidget x0, String x1, String x2, Integer x3, Integer x4, String x5, String x6, String x7, boolean x8) {
        x0.getStoredJobs(x1, x2, x3, x4, x5, x6, x7, x8);
    }

    static /* synthetic */ int access$702(BrowseHistoryWidget x0, int x1) {
        x0.currentPage = x1;
        return x0.currentPage;
    }

    static /* synthetic */ int access$802(BrowseHistoryWidget x0, int x1) {
        x0.jobsPerPageSelectedIndex = x1;
        return x0.jobsPerPageSelectedIndex;
    }

    static /* synthetic */ JobsOfUser access$902(BrowseHistoryWidget x0, JobsOfUser x1) {
        x0.jobsOfUser = x1;
        return x0.jobsOfUser;
    }

    static /* synthetic */ FlowPanel access$1000(BrowseHistoryWidget x0) {
        return x0.myHistoryListBoxContent;
    }

    static /* synthetic */ Alert access$1100(BrowseHistoryWidget x0) {
        return x0.errorAlert;
    }

    static /* synthetic */ void access$1200(BrowseHistoryWidget x0, JobsOfUser x1) {
        x0.updateControls(x1);
    }

    static /* synthetic */ FlowPanel access$1300(BrowseHistoryWidget x0) {
        return x0.topPagerPanel;
    }

    static /* synthetic */ void access$1400(BrowseHistoryWidget x0, FlowPanel x1) {
        x0.drawPager(x1);
    }

    static /* synthetic */ FlowPanel access$1500(BrowseHistoryWidget x0) {
        return x0.bottomPagerPanel;
    }

    static /* synthetic */ String access$402(BrowseHistoryWidget x0, String x1) {
        x0.jobStatusSelected = x1;
        return x0.jobStatusSelected;
    }

    static /* synthetic */ Alert access$1600(BrowseHistoryWidget x0) {
        return x0.successAlert;
    }

    static /* synthetic */ Alert access$1700(BrowseHistoryWidget x0) {
        return x0.warningAlert;
    }

    static /* synthetic */ ValidationServiceAsync access$1800(BrowseHistoryWidget x0) {
        return x0.validationService;
    }
}

