/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.browsehistory;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.query.client.GQuery;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.functionality.validator.JobResultEntry;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.ValidationService;
import eu.dnetlib.repo.manager.client.services.ValidationServiceAsync;
import java.util.ArrayList;
import java.util.List;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;
import org.gwtbootstrap3.client.ui.html.UnorderedList;

public class ViewJobDetailsWidget
extends AbstractRepositoryManagerWidget
implements RepositoryManagerWidget {
    private String parentToken = "";
    private String restToken = "";
    private HTML title = new HTML();
    private FlowPanel viewJobDetailsBoxContent = new FlowPanel();
    private Alert errorAlert = new Alert();
    private FlowPanel helpPanel = new FlowPanel();
    private StoredJob storedJob;
    private List<JobResultEntry> contentResults = new ArrayList();
    private List<JobResultEntry> usageResults = new ArrayList();
    private ValidationServiceAsync validationService = (ValidationServiceAsync)GWT.create(ValidationService.class);
    private static HelpServiceAsync helpService = (HelpServiceAsync)GWT.create(HelpService.class);

    public ViewJobDetailsWidget() {
        this.title.addStyleName("uk-margin-medium-bottom");
        this.contentPanel.add((Widget)this.title);
        this.contentPanel.add((Widget)this.viewJobDetailsBoxContent);
        this.errorAlert.setType(AlertType.DANGER);
        this.errorAlert.setDismissable(false);
        this.errorAlert.setVisible(false);
        this.viewJobDetailsBoxContent.add((Widget)this.errorAlert);
    }

    public void clear() {
        this.viewJobDetailsBoxContent.clear();
        this.errorAlert.setVisible(false);
        this.gridPanel.remove((Widget)this.helpPanel);
        this.storedJob = null;
    }

    public void reload() {
        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        this.viewJobDetailsBoxContent.add((Widget)this.errorAlert);
        HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; color: rgb(47, 64, 80); font-weight: bold;\">Retrieving job details...</div><div class=\"whiteFilm\"></div>");
        this.viewJobDetailsBoxContent.addStyleName("loading-big");
        this.viewJobDetailsBoxContent.add((Widget)loadingWheel);
        helpService.getHelpById(this.parentToken + "_viewJobDetails", (AsyncCallback)new HelpCallback(this.helpPanel, this.gridPanel));
        this.validationService.getJobSummary(Integer.parseInt(this.restToken), "all", (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    public void afterAdditionToRootPanel() {
    }

    private FlowPanel createGeneralInfoItem() {
        FlowPanel generalInfoItem = new FlowPanel();
        String content = "<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\"uk-scrollspy-class=\"\"><span>" + this.storedJob.getBaseUrl() + "</span></h4><div class=\"uk-margin-small\">by " + this.storedJob.getUserEmail() + "</div>";
        generalInfoItem.add((Widget)new HTML(content));
        return generalInfoItem;
    }

    private FlowPanel createInfoTags() {
        FlowPanel generalInfoTags = new FlowPanel();
        String content = "<hr class=\"uk-scrollspy-inview uk-animation-slide-bottom-small\" uk-scrollspy-class=\"\"><div><span class=\"\">" + this.storedJob.getJobType() + "</span> | <span class=\"\">" + this.storedJob.getGuidelinesShortName() + "</span> | <span class=\"\">Validation set: " + this.storedJob.getValidationSet() + "</span></div><div><span class=\"\">Started: " + this.storedJob.getStarted() + "</span>, <span class=\"\">Ended: " + this.storedJob.getEnded() + "</span>, <span class=\"\">Duration: " + this.storedJob.getDuration() + "</span></div><div style=\"font-size: 120%\"><span class=\"\">Records tested: " + this.storedJob.getRecordsTested() + "</span></div><div><span class=\"label label-primary uk-margin-right\">Score for content: " + this.storedJob.getContentJobScore() + "</span><span class=\"label label-primary\">Score for usage: " + this.storedJob.getUsageJobScore() + "</span></div><hr class=\"uk-scrollspy-inview uk-animation-slide-bottom-small\" uk-scrollspy-class=\"\">";
        generalInfoTags.add((Widget)new HTML(content));
        return generalInfoTags;
    }

    private FlowPanel createUsageAndContentInfo() {
        FlowPanel usageAndContentTabs = new FlowPanel();
        UnorderedList tabTitles = new UnorderedList();
        tabTitles.addStyleName("uk-margin el-nav uk-tab");
        ListItem contentTab = new ListItem();
        ListItem usageTab = new ListItem();
        ListItem contentTabContent = new ListItem();
        ListItem usageTabContent = new ListItem();
        contentTab.addStyleName("uk-active");
        Anchor contentTablLink = new Anchor("for Content");
        contentTablLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        contentTab.add((Widget)contentTablLink);
        tabTitles.add((Widget)contentTab);
        Anchor usageTabLink = new Anchor("for Usage");
        usageTabLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        usageTab.add((Widget)usageTabLink);
        tabTitles.add((Widget)usageTab);
        usageAndContentTabs.add((Widget)tabTitles);
        UnorderedList tabContent = new UnorderedList();
        tabContent.addStyleName("uk-switcher");
        contentTabContent.addStyleName("el-item uk-active");
        tabContent.add((Widget)contentTabContent);
        usageTabContent.addStyleName("el-item");
        tabContent.add((Widget)usageTabContent);
        usageAndContentTabs.add((Widget)tabContent);
        if (this.storedJob.getResultEntries() != null) {
            for (JobResultEntry jobResultEntry : this.storedJob.getResultEntries()) {
                if (jobResultEntry.getType().equals("content")) {
                    this.contentResults.add(jobResultEntry);
                    continue;
                }
                this.usageResults.add(jobResultEntry);
            }
        }
        contentTabContent.add((Widget)this.rulesTable(this.contentResults));
        usageTabContent.add((Widget)this.rulesTable(this.usageResults));
        return usageAndContentTabs;
    }

    private FlowPanel rulesTable(List<JobResultEntry> jobResults) {
        FlowPanel contentRules = new FlowPanel();
        contentRules.addStyleName("uk-grid-margin uk-grid uk-grid-stack");
        FlowPanel colPanel = new FlowPanel();
        colPanel.addStyleName("uk-width-1-1@m uk-first-column");
        contentRules.add((Widget)colPanel);
        FlowPanel divPanel = new FlowPanel();
        divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");
        colPanel.add((Widget)divPanel);
        String content = "<table class=\"uk-table uk-table-striped uk-table-middle rules-table\"><thead><tr><th>Rule Name</th><th class=\"uk-text-nowrap\">Rule Description</th><th class=\"uk-text-nowrap\">Rule Weight</th><th class=\"uk-text-nowrap\"># of records</th><th class=\"uk-text-nowrap\">Status</th></tr></thead>";
        content = content + "<tbody>";
        if (jobResults == null || jobResults.size() == 0) {
            content = content + "<tr class=\"el-item\"><td colspan=\"10\"><div class=\"alert alert-warning\">No result entries found</div></td></tr>";
        } else {
            for (int i = 0; i < jobResults.size(); ++i) {
                content = content + "<tr class=\"el-item\"><td class=\"uk-table-shrink\"><div class=\"el-title\">" + jobResults.get(i).getName() + "</div></td><td class=\"uk-table-shrink\">\n<div class=\"el-title\">" + jobResults.get(i).getDescription() + "</div></td><td class=\"uk-table-shrink\">\n<div class=\"el-title\">" + jobResults.get(i).getWeight() + "</div></td><td class=\"uk-table-shrink\">\n<div class=\"el-title\">" + jobResults.get(i).getSuccesses() + "</div></td><td class=\"uk-table-shrink\">\n";
                content = jobResults.get(i).isHasErrors() && jobResults.get(i).isMandatory() ? content + "<span uk-icon=\"icon: close\" style=\"color: #cd242b\"></span><a href=\"javascript:;\" class=\"errorlink viewErrors uk-display-block\" id=\"" + jobResults.get(i).getType() + "#" + i + "\"><span>View Errors</span></a>" : (jobResults.get(i).isHasErrors() && !jobResults.get(i).isMandatory() ? content + "<span uk-icon=\"icon: warning\" style=\"color: #e9d60d\"></span><a href=\"javascript:;\" class=\"warninglink viewErrors uk-display-block\" id=\"" + jobResults.get(i).getType() + "#" + i + "\"><span>View Warnings</span></a>" : content + "<span uk-icon=\"icon: check\" style=\"color: #4b991f\"></span>");
                content = content + "</td></tr>";
            }
        }
        content = content + "</tbody></table>";
        HTML contentRulesListHTML = new HTML();
        contentRulesListHTML.setHTML(content);
        divPanel.add((Widget)contentRulesListHTML);
        return contentRules;
    }

    private void addHandlers() {
        GQuery.$((String)".viewErrors").click(new Function[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void openErrorModal(JobResultEntry jobResultEntry) {
        Modal errorsModal = new Modal();
        errorsModal.setDataBackdrop(ModalBackdrop.STATIC);
        FlowPanel modalContent = new FlowPanel();
        String content = "<h2 class=\"uk-modal-title\">Rule: " + jobResultEntry.getName() + "</h2><p>See the list of errors found for this specific rule</p>";
        for (String error : jobResultEntry.getErrors()) {
            content = content + "<a class=\"uk-display-block\" target=\"_blank\" href=\"" + this.storedJob.getBaseUrl() + "?verb=GetRecord&metadataPrefix=oai_dc&identifier=" + error + "\">" + error + "</a>";
        }
        HTML contentHTML = new HTML(content);
        modalContent.add((Widget)contentHTML);
        FlowPanel actionButtons = new FlowPanel();
        actionButtons.addStyleName("uk-text-right");
        modalContent.add((Widget)actionButtons);
        Button no = new Button("Ok");
        no.setType(ButtonType.DEFAULT);
        no.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        actionButtons.add((Widget)no);
        ModalBody modalBody = new ModalBody();
        modalBody.add((Widget)modalContent);
        errorsModal.add((Widget)modalBody);
        errorsModal.getElement().getChild(0).getChild(0).getChild(0).removeFromParent();
        errorsModal.show();
    }

    static /* synthetic */ FlowPanel access$000(ViewJobDetailsWidget x0) {
        return x0.viewJobDetailsBoxContent;
    }

    static /* synthetic */ Alert access$100(ViewJobDetailsWidget x0) {
        return x0.errorAlert;
    }

    static /* synthetic */ StoredJob access$202(ViewJobDetailsWidget x0, StoredJob x1) {
        x0.storedJob = x1;
        return x0.storedJob;
    }

    static /* synthetic */ HTML access$300(ViewJobDetailsWidget x0) {
        return x0.title;
    }

    static /* synthetic */ FlowPanel access$400(ViewJobDetailsWidget x0) {
        return x0.createGeneralInfoItem();
    }

    static /* synthetic */ FlowPanel access$500(ViewJobDetailsWidget x0) {
        return x0.createInfoTags();
    }

    static /* synthetic */ FlowPanel access$600(ViewJobDetailsWidget x0) {
        return x0.createUsageAndContentInfo();
    }

    static /* synthetic */ void access$700(ViewJobDetailsWidget x0) {
        x0.addHandlers();
    }

    static /* synthetic */ List access$800(ViewJobDetailsWidget x0) {
        return x0.contentResults;
    }

    static /* synthetic */ List access$900(ViewJobDetailsWidget x0) {
        return x0.usageResults;
    }

    static /* synthetic */ void access$1000(ViewJobDetailsWidget x0, JobResultEntry x1) {
        x0.openErrorModal(x1);
    }
}

