/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.datasources.utils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.client.widgets.TextArea;
import eu.dnetlib.repo.manager.client.widgets.TextBox;
import eu.dnetlib.repo.manager.client.widgets.ValueChangeHandler;
import eu.dnetlib.repo.manager.shared.DatasourceVocabularies;
import eu.dnetlib.repo.manager.shared.Timezone;
import java.util.HashMap;
import java.util.Map;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.form.validator.Validator;

public class RepositoryInformationFormWidget
implements IsWidget {
    private FlowPanel repositoryInformationPanel = new FlowPanel();
    private Alert errorLabel = new Alert();
    private Alert successLabel = new Alert();
    private Form repositoryInformationForm = new Form();
    private HTML basicInfoWarningLabel = new HTML();
    private ListBox typologyListBox = new ListBox();
    private MyFormGroup typologyListFormGroup = new MyFormGroup(false, "Software Platform (*)", new Widget[]{this.typologyListBox});
    private TextBox typologyTextBox = new TextBox();
    private MyFormGroup typologyTextFormGroup = new MyFormGroup(false, null, new Widget[]{this.typologyTextBox});
    private TextBox officialName = new TextBox();
    private MyFormGroup officialNameFormGroup = new MyFormGroup(false, "Official Name (*)", new Widget[]{this.officialName});
    private TextBox issn = new TextBox();
    private MyFormGroup issnFormGroup = new MyFormGroup(true, "ISSN (*)", new Widget[]{this.issn});
    private TextBox eissn = new TextBox();
    private MyFormGroup eissnFormGroup = new MyFormGroup(true, "EISSN", new Widget[]{this.eissn});
    private TextBox lissn = new TextBox();
    private MyFormGroup lissnFormGroup = new MyFormGroup(true, "LISSN", new Widget[]{this.lissn});
    private TextArea description = new TextArea();
    private MyFormGroup descriptionFormGroup = new MyFormGroup(false, "Description (*)", new Widget[]{this.description});
    private ListBox countryListBox = new ListBox();
    private MyFormGroup countryFormGroup = new MyFormGroup(false, "Country (*)", new Widget[]{this.countryListBox});
    private TextBox longitude = new TextBox();
    private MyFormGroup longitudeFormGroup = new MyFormGroup(true, "Longitude (*)", new Widget[]{this.longitude});
    private TextBox latitude = new TextBox();
    private MyFormGroup latitudeFormGroup = new MyFormGroup(true, "Latitude (*)", new Widget[]{this.latitude});
    private TextBox entryURL = new TextBox();
    private MyFormGroup entryURLFormGroup = new MyFormGroup(false, "Entry URL (*)", new Widget[]{this.entryURL});
    private TextBox institution = new TextBox();
    private MyFormGroup institutionFormGroup = new MyFormGroup(false, "Institution (*)", new Widget[]{this.institution});
    private TextBox englishName = new TextBox();
    private MyFormGroup englishNameFormGroup = new MyFormGroup(false, "English Name (*)", new Widget[]{this.englishName});
    private TextBox logoURL = new TextBox();
    private ListBox timezoneListBox = new ListBox();
    private MyFormGroup timezoneFormGroup = new MyFormGroup(false, "Timezone (*)", new Widget[]{this.timezoneListBox});
    private ListBox datasourceClassListBox = new ListBox();
    private MyFormGroup datasourceClassFormGroup = new MyFormGroup(false, "Datasource Type (*)", new Widget[]{this.datasourceClassListBox});
    private TextBox admin = new TextBox();
    private MyFormGroup adminFormGroup = new MyFormGroup(true, "Admin Email (*)", new Widget[]{this.admin});
    private Map<String, Integer> typologyValuesMap = new HashMap();
    private Map<String, Integer> countryValuesMap = new HashMap();
    private Map<String, Integer> timezoneValuesMap = new HashMap();
    private Map<String, Integer> datasourceClassValuesMap = new HashMap();
    private String mode;
    private Repository repository;
    private RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);

    public RepositoryInformationFormWidget(String mode, DatasourceVocabularies datasourceVocabularies, boolean isUpdate) {
        this.mode = mode;
        this.basicInfoWarningLabel.addStyleName("alert alert-warning");
        this.basicInfoWarningLabel.setVisible(false);
        this.errorLabel.setType(AlertType.DANGER);
        this.errorLabel.setDismissable(false);
        this.errorLabel.setVisible(false);
        this.successLabel.setType(AlertType.SUCCESS);
        this.successLabel.setDismissable(false);
        this.successLabel.setVisible(false);
        this.repositoryInformationPanel.add((Widget)this.successLabel);
        this.repositoryInformationPanel.add((Widget)this.errorLabel);
        this.repositoryInformationPanel.add((Widget)this.repositoryInformationForm);
        this.typologyListBox.addItem("-- none selected --", "noneSelected");
        for (int i = 1; i < datasourceVocabularies.getTypologies().size(); ++i) {
            if (((String)datasourceVocabularies.getTypologies().get(i - 1)).equals("[Other]")) {
                this.typologyListBox.addItem("[Other] (enter name below)", "[Other]");
                this.typologyValuesMap.put("[Other]", i);
                continue;
            }
            this.typologyListBox.addItem((String)datasourceVocabularies.getTypologies().get(i - 1), (String)datasourceVocabularies.getTypologies().get(i - 1));
            this.typologyValuesMap.put(datasourceVocabularies.getTypologies().get(i - 1), i);
        }
        this.countryListBox.addItem("-- none selected --", "noneSelected");
        int counter1 = 1;
        for (Object country : datasourceVocabularies.getCountries().keySet()) {
            this.countryListBox.addItem((String)datasourceVocabularies.getCountries().get(country), (String)country);
            this.countryValuesMap.put(country, counter1);
            ++counter1;
        }
        this.timezoneListBox.addItem("-- none selected --", "noneSelected");
        for (int i = 1; i < datasourceVocabularies.getTimezones().size(); ++i) {
            this.timezoneListBox.addItem(((Timezone)datasourceVocabularies.getTimezones().get((int)(i - 1))).name, ((Timezone)datasourceVocabularies.getTimezones().get((int)(i - 1))).offset + "");
            this.timezoneValuesMap.put(((Timezone)datasourceVocabularies.getTimezones().get((int)(i - 1))).offset + "", i);
        }
        this.datasourceClassListBox.addItem("-- none selected --", "noneSelected");
        int counter2 = 1;
        for (String datasourceClass : datasourceVocabularies.getDatasourceClasses().keySet()) {
            this.datasourceClassListBox.addItem((String)datasourceVocabularies.getDatasourceClasses().get(datasourceClass), datasourceClass);
            this.datasourceClassValuesMap.put(datasourceClass, counter2);
            ++counter2;
        }
        this.typologyTextBox.setVisible(false);
        Label logoURLComment = new Label("Please make sure that the maximum size of the uploaded image is width=360px, height=240px");
        logoURLComment.addStyleName("comment");
        logoURLComment.addStyleName("fontItalic");
        HTML basicInfoLabel = new HTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\" uk-scrollspy-class=\"\">Basic information</h4>");
        this.repositoryInformationForm.add((Widget)basicInfoLabel);
        this.repositoryInformationForm.add((Widget)this.basicInfoWarningLabel);
        this.repositoryInformationForm.add((IsWidget)this.typologyListFormGroup);
        this.repositoryInformationForm.add((IsWidget)this.typologyTextFormGroup);
        this.repositoryInformationForm.add((IsWidget)this.officialNameFormGroup);
        if (mode.equals("journal")) {
            this.repositoryInformationForm.add((IsWidget)this.issnFormGroup);
            this.repositoryInformationForm.add((IsWidget)this.eissnFormGroup);
            this.repositoryInformationForm.add((IsWidget)this.lissnFormGroup);
        }
        this.repositoryInformationForm.add((IsWidget)this.descriptionFormGroup);
        this.repositoryInformationForm.add((IsWidget)this.countryFormGroup);
        this.repositoryInformationForm.add((IsWidget)this.longitudeFormGroup);
        this.repositoryInformationForm.add((IsWidget)this.latitudeFormGroup);
        this.repositoryInformationForm.add((IsWidget)this.entryURLFormGroup);
        this.repositoryInformationForm.add((IsWidget)this.institutionFormGroup);
        HTML extraInfoLabel = new HTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\" uk-scrollspy-class=\"\">Extra information</h4>");
        this.repositoryInformationForm.add((Widget)extraInfoLabel);
        this.repositoryInformationForm.add((IsWidget)this.englishNameFormGroup);
        this.repositoryInformationForm.add((IsWidget)new MyFormGroup(false, "Logo URL", new Widget[]{this.logoURL, logoURLComment}));
        this.repositoryInformationForm.add((IsWidget)this.timezoneFormGroup);
        this.repositoryInformationForm.add((IsWidget)this.datasourceClassFormGroup);
        if (mode.equals("journal")) {
            this.datasourceClassFormGroup.setLabelText("Journal Type (*)");
        } else if (mode.equals("aggregator")) {
            this.datasourceClassFormGroup.setLabelText("Aggregator Type (*)");
        }
        HTML adminInfoLabel = new HTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\" uk-scrollspy-class=\"\">Administrator & contact information</h4>");
        this.repositoryInformationForm.add((Widget)adminInfoLabel);
        this.repositoryInformationForm.add((IsWidget)this.adminFormGroup);
        if (mode.equals("opendoar") || mode.equals("re3data")) {
            this.typologyListBox.setEnabled(false);
            this.typologyTextBox.setEnabled(false);
            this.officialName.setEnabled(false);
            this.description.setEnabled(false);
            this.countryListBox.setEnabled(false);
            this.longitude.setEnabled(false);
            this.latitude.setEnabled(false);
            this.entryURL.setEnabled(false);
            this.institution.setEnabled(false);
        }
        if (isUpdate) {
            Button updateInfoButton = new Button("Update Information");
            updateInfoButton.setType(ButtonType.PRIMARY);
            updateInfoButton.addStyleName("updateRepoInfoButton");
            updateInfoButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.repositoryInformationForm.add((IsWidget)new MyFormGroup(false, null, new Widget[]{updateInfoButton}));
        }
        this.addValueChangeHandlersToFormFields();
        this.addFieldValidators();
    }

    public Widget asWidget() {
        return this.repositoryInformationPanel;
    }

    public void loadRepository(Repository repository) {
        this.errorLabel.setVisible(false);
        this.successLabel.setVisible(false);
        this.repository = repository;
        if (this.mode.equals("opendoar")) {
            this.basicInfoWarningLabel.setHTML("The following fields are completed by OpenDOAR.<br>If you want to edit them, you can do it by using this <a target=\"_blank\" href=\"http://www.opendoar.org/suggest.php?rID=" + repository.getId().split("::")[1] + "\">OpenDOAR link</a>");
            this.basicInfoWarningLabel.setVisible(true);
        } else if (this.mode.equals("re3data")) {
            this.basicInfoWarningLabel.setHTML("The following fields are completed by Re3data.<br>If you want to edit them, you can do it by using this <a target=\"_blank\" href=\"http://service.re3data.org/repository/" + repository.getId().split("::")[1] + "\">Re3data link</a>");
            this.basicInfoWarningLabel.setVisible(true);
        }
        if (repository.getTypology() != null) {
            if (this.timezoneValuesMap.get(repository.getTypology()) != null) {
                this.typologyListBox.setSelectedIndex(((Integer)this.typologyValuesMap.get(repository.getTypology())).intValue());
            } else if (this.typologyValuesMap.containsKey("[Other]")) {
                this.typologyListBox.setSelectedIndex(((Integer)this.typologyValuesMap.get("[Other]")).intValue());
                this.typologyTextBox.setVisible(true);
                this.typologyTextBox.setValue((Object)repository.getTypology());
            }
        }
        if (repository.getOfficialName() != null) {
            this.officialName.setValue((Object)repository.getOfficialName());
        }
        if (this.mode.equals("journal")) {
            if (repository.getIssn() != null) {
                this.issn.setValue((Object)repository.getIssn());
            }
            if (repository.getEissn() != null) {
                this.eissn.setValue((Object)repository.getEissn());
            }
            if (repository.getLissn() != null) {
                this.lissn.setValue((Object)repository.getLissn());
            }
        }
        if (repository.getDescription() != null) {
            this.description.setValue((Object)repository.getDescription());
        }
        if (repository.getCountryName() != null) {
            this.countryListBox.setSelectedIndex(((Integer)this.countryValuesMap.get(repository.getCountryName())).intValue());
        }
        if (repository.getLongitude() != null) {
            this.longitude.setValue((Object)(repository.getLongitude() + ""));
        }
        if (repository.getLatitude() != null) {
            this.latitude.setValue((Object)(repository.getLatitude() + ""));
        }
        if (repository.getWebsiteUrl() != null) {
            this.entryURL.setValue((Object)repository.getWebsiteUrl());
        }
        if (repository.getOrganization() != null) {
            this.institution.setValue((Object)repository.getOrganization());
        }
        if (repository.getEnglishName() != null) {
            this.englishName.setValue((Object)repository.getEnglishName());
        }
        if (repository.getLogoUrl() != null) {
            this.logoURL.setValue((Object)repository.getLogoUrl());
        }
        if (repository.getTimezone() != null) {
            this.timezoneListBox.setSelectedIndex(((Integer)this.timezoneValuesMap.get(repository.getTimezone() + "")).intValue());
        }
        if (repository.getDatasourceClass() != null && this.datasourceClassValuesMap.containsKey(repository.getDatasourceClass())) {
            this.datasourceClassListBox.setSelectedIndex(((Integer)this.datasourceClassValuesMap.get(repository.getDatasourceClass())).intValue());
        }
        if (repository.getContactEmail() != null) {
            this.admin.setValue((Object)repository.getContactEmail());
        }
    }

    public Repository getRepository() {
        if (this.isComplete() && this.repositoryInformationForm.validate()) {
            if (this.typologyListBox.getSelectedValue().equals("[Other]")) {
                this.repository.setTypology(this.typologyTextBox.getValue().trim());
            } else {
                this.repository.setTypology(this.typologyListBox.getSelectedValue());
            }
            this.repository.setOfficialName(this.officialName.getValue().trim());
            if (this.mode.equals("journal")) {
                this.repository.setIssn(this.issn.getValue().trim());
                if (this.eissn.getValue() != null && !this.eissn.getValue().trim().isEmpty()) {
                    this.repository.setEissn(this.eissn.getValue().trim());
                }
                if (this.lissn.getValue() != null && !this.lissn.getValue().trim().isEmpty()) {
                    this.repository.setLissn(this.lissn.getValue().trim());
                }
            }
            this.repository.setDescription(this.description.getValue().trim());
            this.repository.setCountryName(this.countryListBox.getSelectedValue());
            this.repository.setLongitude(Double.valueOf(Double.parseDouble(this.longitude.getValue().trim())));
            this.repository.setLatitude(Double.valueOf(Double.parseDouble(this.latitude.getValue().trim())));
            this.repository.setWebsiteUrl(this.entryURL.getValue().trim());
            this.repository.setOrganization(this.institution.getValue().trim());
            this.repository.setEnglishName(this.englishName.getValue().trim());
            this.repository.setLogoUrl(this.logoURL.getValue().trim());
            this.repository.setTimezone(Double.valueOf(Double.parseDouble(this.timezoneListBox.getSelectedValue())));
            this.repository.setDatasourceClass(this.datasourceClassListBox.getSelectedValue());
            this.repository.setContactEmail(this.admin.getValue());
            return this.repository;
        }
        return null;
    }

    private boolean isComplete() {
        boolean isComplete = true;
        this.errorLabel.setVisible(false);
        this.successLabel.setVisible(false);
        if (this.typologyListBox.getSelectedValue().equals("noneSelected")) {
            isComplete = false;
            this.typologyListFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        } else if (this.typologyListBox.getSelectedValue().equals("[Other]") && (this.typologyTextBox.getValue() == null || this.typologyTextBox.getValue().trim().isEmpty())) {
            isComplete = false;
            this.typologyTextFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.officialName.getValue() == null || this.officialName.getValue().trim().isEmpty()) {
            isComplete = false;
            this.officialNameFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.mode.equals("journal") && (this.issn.getValue() == null || this.issn.getValue().trim().isEmpty())) {
            isComplete = false;
            this.issnFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.description.getValue() == null || this.description.getValue().trim().isEmpty()) {
            isComplete = false;
            this.descriptionFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.countryListBox.getSelectedValue().equals("noneSelected")) {
            isComplete = false;
            this.countryFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.longitude.getValue() == null || this.longitude.getValue().trim().isEmpty()) {
            isComplete = false;
            this.longitudeFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.latitude.getValue() == null || this.latitude.getValue().trim().isEmpty()) {
            isComplete = false;
            this.latitudeFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.entryURL.getValue() == null || this.entryURL.getValue().trim().isEmpty()) {
            isComplete = false;
            this.entryURLFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.institution.getValue() == null || this.institution.getValue().trim().isEmpty()) {
            isComplete = false;
            this.institutionFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.englishName.getValue() == null || this.englishName.getValue().trim().isEmpty()) {
            isComplete = false;
            this.englishNameFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.timezoneListBox.getSelectedValue().equals("noneSelected")) {
            isComplete = false;
            this.timezoneFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.datasourceClassListBox.getSelectedValue().equals("noneSelected")) {
            isComplete = false;
            this.datasourceClassFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (this.admin.getValue() == null || this.admin.getValue().trim().isEmpty()) {
            isComplete = false;
            this.adminFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }
        if (!isComplete) {
            this.errorLabel.setText("All fields marked with * are mandatory.");
            this.errorLabel.setVisible(true);
        }
        return isComplete;
    }

    private void addFieldValidators() {
        this.longitude.addValidator((Validator)new /* Unavailable Anonymous Inner Class!! */);
        this.latitude.addValidator((Validator)new /* Unavailable Anonymous Inner Class!! */);
        this.admin.addValidator((Validator)new /* Unavailable Anonymous Inner Class!! */);
        if (this.mode.equals("journal")) {
            this.issn.addValidator((Validator)new /* Unavailable Anonymous Inner Class!! */);
            this.eissn.addValidator((Validator)new /* Unavailable Anonymous Inner Class!! */);
            this.lissn.addValidator((Validator)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void addValueChangeHandlersToFormFields() {
        this.typologyListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.typologyTextBox.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.officialName.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.issn.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eissn.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.lissn.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.description.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.countryListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.longitude.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.latitude.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.entryURL.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.institution.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.englishName.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.timezoneListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.datasourceClassListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.admin.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Alert access$000(RepositoryInformationFormWidget x0) {
        return x0.errorLabel;
    }

    static /* synthetic */ Alert access$100(RepositoryInformationFormWidget x0) {
        return x0.successLabel;
    }

    static /* synthetic */ FlowPanel access$200(RepositoryInformationFormWidget x0) {
        return x0.repositoryInformationPanel;
    }

    static /* synthetic */ RepositoryServiceAsync access$300(RepositoryInformationFormWidget x0) {
        return x0.repositoryService;
    }

    static /* synthetic */ MyFormGroup access$400(RepositoryInformationFormWidget x0) {
        return x0.longitudeFormGroup;
    }

    static /* synthetic */ TextBox access$500(RepositoryInformationFormWidget x0) {
        return x0.longitude;
    }

    static /* synthetic */ MyFormGroup access$600(RepositoryInformationFormWidget x0) {
        return x0.latitudeFormGroup;
    }

    static /* synthetic */ TextBox access$700(RepositoryInformationFormWidget x0) {
        return x0.latitude;
    }

    static /* synthetic */ MyFormGroup access$800(RepositoryInformationFormWidget x0) {
        return x0.adminFormGroup;
    }

    static /* synthetic */ TextBox access$900(RepositoryInformationFormWidget x0) {
        return x0.admin;
    }

    static /* synthetic */ MyFormGroup access$1000(RepositoryInformationFormWidget x0) {
        return x0.issnFormGroup;
    }

    static /* synthetic */ TextBox access$1100(RepositoryInformationFormWidget x0) {
        return x0.issn;
    }

    static /* synthetic */ MyFormGroup access$1200(RepositoryInformationFormWidget x0) {
        return x0.eissnFormGroup;
    }

    static /* synthetic */ TextBox access$1300(RepositoryInformationFormWidget x0) {
        return x0.eissn;
    }

    static /* synthetic */ MyFormGroup access$1400(RepositoryInformationFormWidget x0) {
        return x0.lissnFormGroup;
    }

    static /* synthetic */ TextBox access$1500(RepositoryInformationFormWidget x0) {
        return x0.lissn;
    }

    static /* synthetic */ MyFormGroup access$1600(RepositoryInformationFormWidget x0) {
        return x0.typologyListFormGroup;
    }

    static /* synthetic */ ListBox access$1700(RepositoryInformationFormWidget x0) {
        return x0.typologyListBox;
    }

    static /* synthetic */ TextBox access$1800(RepositoryInformationFormWidget x0) {
        return x0.typologyTextBox;
    }

    static /* synthetic */ MyFormGroup access$1900(RepositoryInformationFormWidget x0) {
        return x0.typologyTextFormGroup;
    }

    static /* synthetic */ MyFormGroup access$2000(RepositoryInformationFormWidget x0) {
        return x0.officialNameFormGroup;
    }

    static /* synthetic */ MyFormGroup access$2100(RepositoryInformationFormWidget x0) {
        return x0.descriptionFormGroup;
    }

    static /* synthetic */ MyFormGroup access$2200(RepositoryInformationFormWidget x0) {
        return x0.countryFormGroup;
    }

    static /* synthetic */ MyFormGroup access$2300(RepositoryInformationFormWidget x0) {
        return x0.entryURLFormGroup;
    }

    static /* synthetic */ MyFormGroup access$2400(RepositoryInformationFormWidget x0) {
        return x0.institutionFormGroup;
    }

    static /* synthetic */ MyFormGroup access$2500(RepositoryInformationFormWidget x0) {
        return x0.englishNameFormGroup;
    }

    static /* synthetic */ MyFormGroup access$2600(RepositoryInformationFormWidget x0) {
        return x0.timezoneFormGroup;
    }

    static /* synthetic */ MyFormGroup access$2700(RepositoryInformationFormWidget x0) {
        return x0.datasourceClassFormGroup;
    }
}

