/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.datasources.utils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.client.widgets.TextBox;
import eu.dnetlib.repo.manager.client.widgets.ValueChangeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.RadioButton;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;

public class SelectRepositoryWidget
implements IsWidget {
    private FlowPanel selectRepositoryPanel = new FlowPanel();
    private Alert errorAlert = new Alert();
    private HTML infoLabel = new HTML();
    private Form form = new Form();
    private ListBox countriesListBox = new ListBox();
    private TextBox autocomplete = new TextBox();
    private FlowPanel repositoriesPanel = new FlowPanel();
    private List<Repository> repositoriesForCountryList = new ArrayList();
    private List<Repository> matchingRepositoriesForCountryList = new ArrayList();
    private Repository selectedRepository;
    private RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
    private String mode;

    public SelectRepositoryWidget(Map<String, String> countries, String mode) {
        this.mode = mode;
        this.selectRepositoryPanel.addStyleName("animated fadeInRight");
        this.selectRepositoryPanel.addStyleName("stepContent");
        this.errorAlert.setType(AlertType.DANGER);
        this.errorAlert.setDismissable(false);
        this.errorAlert.setVisible(false);
        this.selectRepositoryPanel.add((Widget)this.errorAlert);
        this.infoLabel.addStyleName("alert alert-info");
        if (mode.equals("opendoar")) {
            this.repositoryService.getLatestUpdateDateOfList(mode, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else if (mode.equals("re3data")) {
            this.repositoryService.getLatestUpdateDateOfList(mode, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.selectRepositoryPanel.add((Widget)this.infoLabel);
        this.countriesListBox.addItem("-- none selected --", "noneSelected");
        for (String country : countries.keySet()) {
            this.countriesListBox.addItem(countries.get(country), country);
        }
        this.countriesListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.form.add((IsWidget)new MyFormGroup(false, "Country", new Widget[]{this.countriesListBox}));
        this.autocomplete.setValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.autocomplete.setEnabled(false);
        this.form.add((IsWidget)new MyFormGroup(false, "Search by repository name", new Widget[]{this.autocomplete}));
        this.selectRepositoryPanel.add((Widget)this.form);
        this.selectRepositoryPanel.add((Widget)this.repositoriesPanel);
    }

    public Widget asWidget() {
        return this.selectRepositoryPanel;
    }

    public Repository getSelectedRepository() {
        this.errorAlert.setVisible(false);
        if (this.selectedRepository == null) {
            this.errorAlert.setVisible(true);
            this.errorAlert.setText("You need to select a repository first.");
        }
        return this.selectedRepository;
    }

    private void drawRepositoriesPanel(List<Repository> matchingRepositoriesForCountryList) {
        String modeName = "";
        modeName = this.mode.equals("opendoar") ? "OpenDOAR" : "Re3data";
        HTML labelForCountry = new HTML("<h2>" + modeName + " Repositories in " + this.countriesListBox.getSelectedValue() + "</h2>");
        this.repositoriesPanel.add((Widget)labelForCountry);
        this.addRepositoriesRadioListToPanel(matchingRepositoriesForCountryList, this.repositoriesPanel);
    }

    private void addRepositoriesRadioListToPanel(List<Repository> repositories, FlowPanel panel) {
        if (repositories.isEmpty()) {
            Alert warningAlert = new Alert();
            warningAlert.setType(AlertType.WARNING);
            warningAlert.setDismissable(false);
            warningAlert.setText("No repositories found");
            panel.add((Widget)warningAlert);
        } else {
            Form repositoriesRadioButtonsForm = new Form();
            repositoriesRadioButtonsForm.addStyleName("repositoriesRadioButtonForm");
            for (Repository repository : repositories) {
                RadioButton radioButton;
                String repositoryName = "";
                repositoryName = this.autocomplete.getValue() != null && !this.autocomplete.getValue().trim().equals("") ? RegExp.compile((String)this.autocomplete.getValue(), (String)"gi").replace(repository.getOfficialName(), "<mark>" + this.autocomplete.getValue() + "</mark>") : repository.getOfficialName();
                if (repository.isRegistered().booleanValue()) {
                    radioButton = new RadioButton("repository", repositoryName + "<span class=\"label label-warning registeredLabel\">Registered</span><a target=\"_blank\" href=\"" + repository.getWebsiteUrl() + "\"><i class=\"fa fa-external-link externalLink\"></i></a>", true);
                    radioButton.setEnabled(false);
                } else {
                    radioButton = new RadioButton("repository", repositoryName + "<a target=\"_blank\" href=\"" + repository.getWebsiteUrl() + "\"><i class=\"fa fa-external-link externalLink\"></i></a>", true);
                }
                radioButton.setType(ButtonType.LINK);
                radioButton.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                repositoriesRadioButtonsForm.add((IsWidget)new MyFormGroup(false, null, new Widget[]{radioButton}));
            }
            panel.add((Widget)repositoriesRadioButtonsForm);
        }
    }

    static /* synthetic */ HTML access$000(SelectRepositoryWidget x0) {
        return x0.infoLabel;
    }

    static /* synthetic */ FlowPanel access$100(SelectRepositoryWidget x0) {
        return x0.repositoriesPanel;
    }

    static /* synthetic */ List access$200(SelectRepositoryWidget x0) {
        return x0.repositoriesForCountryList;
    }

    static /* synthetic */ List access$300(SelectRepositoryWidget x0) {
        return x0.matchingRepositoriesForCountryList;
    }

    static /* synthetic */ ListBox access$400(SelectRepositoryWidget x0) {
        return x0.countriesListBox;
    }

    static /* synthetic */ TextBox access$500(SelectRepositoryWidget x0) {
        return x0.autocomplete;
    }

    static /* synthetic */ void access$600(SelectRepositoryWidget x0, List x1) {
        x0.drawRepositoriesPanel(x1);
    }

    static /* synthetic */ RepositoryServiceAsync access$700(SelectRepositoryWidget x0) {
        return x0.repositoryService;
    }

    static /* synthetic */ Repository access$802(SelectRepositoryWidget x0, Repository x1) {
        x0.selectedRepository = x1;
        return x0.selectedRepository;
    }
}

