/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.enrichcontent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.query.client.GQuery;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.BrokerService;
import eu.dnetlib.repo.manager.client.services.BrokerServiceAsync;
import eu.dnetlib.repo.manager.shared.broker.SimpleSubscriptionDesc;
import java.util.List;
import java.util.Map;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;

public class BrowseSubscriptionsWidget
extends AbstractRepositoryManagerWidget
implements RepositoryManagerWidget {
    private String parentToken = "";
    private String restToken = "";
    private FlowPanel browseSubscriptionsBoxContent = new FlowPanel();
    private Alert errorAlert = new Alert();
    private static HelpServiceAsync helpService = (HelpServiceAsync)GWT.create(HelpService.class);
    private static BrokerServiceAsync brokerService = (BrokerServiceAsync)GWT.create(BrokerService.class);

    public BrowseSubscriptionsWidget() {
        HTML title = new HTML("<h1 class=\"uk-article-title\">Enrich Your Content - Browse Subscriptions</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        this.contentPanel.add((Widget)title);
        this.errorAlert.setType(AlertType.DANGER);
        this.errorAlert.setDismissable(false);
        this.errorAlert.setVisible(false);
        this.browseSubscriptionsBoxContent.add((Widget)this.errorAlert);
        this.contentPanel.add((Widget)this.browseSubscriptionsBoxContent);
    }

    public void clear() {
        this.browseSubscriptionsBoxContent.clear();
        this.errorAlert.setVisible(false);
        this.gridPanel.remove((Widget)this.helpPanel);
    }

    public void reload() {
        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        this.browseSubscriptionsBoxContent.add((Widget)this.errorAlert);
        helpService.getHelpById(this.parentToken, (AsyncCallback)new HelpCallback(this.helpPanel, this.gridPanel));
        HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; color: rgb(47, 64, 80); font-weight: bold;\">Retrieving subscriptions...</div><div class=\"whiteFilm\"></div>");
        this.browseSubscriptionsBoxContent.addStyleName("loading-big");
        this.browseSubscriptionsBoxContent.add((Widget)loadingWheel);
        brokerService.getSimpleSubscriptionsOfUser(RepositoryManager.currentUser.getEmail(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    public void afterAdditionToRootPanel() {
    }

    private void addWidgetHandlers() {
        GQuery.$((String)".delete").click(new Function[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void createSubscriptionsList(Map<String, List<SimpleSubscriptionDesc>> subscriptionsList, FlowPanel subscriptionsPanel) {
        if (subscriptionsList.isEmpty()) {
            subscriptionsPanel.add((Widget)new HTML("No subscriptions found for your account"));
        } else {
            for (String key : subscriptionsList.keySet()) {
                HTML datasourceTitle = new HTML();
                datasourceTitle.setHTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\"uk-scrollspy-class=\"\"><span>" + key + "</span></h4>");
                subscriptionsPanel.add((Widget)datasourceTitle);
                FlowPanel colPanel = new FlowPanel();
                colPanel.addStyleName("uk-width-1-1@m uk-first-column uk-margin-medium-bottom");
                subscriptionsPanel.add((Widget)colPanel);
                FlowPanel divPanel = new FlowPanel();
                divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");
                colPanel.add((Widget)divPanel);
                String content = "<table class=\"uk-table uk-table-striped uk-table-middle\"><thead><tr><th>Topic</th><th class=\"uk-text-nowrap\"># of notifications</th><th class=\"uk-text-nowrap\">Actions</th></tr></thead>";
                content = content + "<tbody>";
                for (SimpleSubscriptionDesc simpleSubscriptionDesc : subscriptionsList.get(key)) {
                    content = content + "<tr class=\"el-item\"><td class=\"uk-table-shrink\">";
                    content = content + "<div class=\"el-title\">" + simpleSubscriptionDesc.getTopic() + "</div>";
                    content = content + "</td><td class=\"uk-text-nowrap uk-table-shrink\">\n<div class=\"el-title\">" + simpleSubscriptionDesc.getCount() + "</div></td><td class=\"uk-text-nowrap uk-table-shrink\"><a href=\"javascript:;\" id=\"" + simpleSubscriptionDesc.getId() + "#delete\" class=\"el-link delete\"><i class=\"fa fa-remove\" aria-hidden=\"true\"></i></a></td></tr>";
                }
                content = content + "</tbody></table>";
                HTML reposListHTML = new HTML();
                reposListHTML.setHTML(content);
                divPanel.add((Widget)reposListHTML);
            }
        }
        this.addWidgetHandlers();
    }

    private void deleteSubscriptions(List<String> subscriptionIds) {
        Modal deleteSubscriptionsConfirmationPopup = new Modal();
        deleteSubscriptionsConfirmationPopup.setDataBackdrop(ModalBackdrop.STATIC);
        FlowPanel modalContent = new FlowPanel();
        HTML description = new HTML("<h2 class=\"uk-modal-title\">Delete Confirmation</h2>\n<p>Are you sure you want to delete the selected subscription(s)?</p>");
        modalContent.add((Widget)description);
        FlowPanel actionButtons = new FlowPanel();
        actionButtons.addStyleName("uk-text-right");
        modalContent.add((Widget)actionButtons);
        Button no = new Button("Cancel");
        no.setType(ButtonType.DEFAULT);
        no.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        actionButtons.add((Widget)no);
        Button yes = new Button("Yes, delete them");
        yes.setType(ButtonType.PRIMARY);
        yes.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        actionButtons.add((Widget)yes);
        ModalBody modalBody = new ModalBody();
        modalBody.add((Widget)modalContent);
        deleteSubscriptionsConfirmationPopup.add((Widget)modalBody);
        deleteSubscriptionsConfirmationPopup.getElement().getChild(0).getChild(0).getChild(0).removeFromParent();
        deleteSubscriptionsConfirmationPopup.show();
    }

    static /* synthetic */ FlowPanel access$000(BrowseSubscriptionsWidget x0) {
        return x0.browseSubscriptionsBoxContent;
    }

    static /* synthetic */ Alert access$100(BrowseSubscriptionsWidget x0) {
        return x0.errorAlert;
    }

    static /* synthetic */ void access$200(BrowseSubscriptionsWidget x0, Map x1, FlowPanel x2) {
        x0.createSubscriptionsList(x1, x2);
    }

    static /* synthetic */ void access$300(BrowseSubscriptionsWidget x0, List x1) {
        x0.deleteSubscriptions(x1);
    }

    static /* synthetic */ BrokerServiceAsync access$400() {
        return brokerService;
    }
}

