/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.enrichcontent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.BrokerService;
import eu.dnetlib.repo.manager.client.services.BrokerServiceAsync;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.broker.BrowseEntry;
import eu.dnetlib.repo.manager.shared.broker.DatasourcesBroker;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

public class EnrichContentWidget
extends AbstractRepositoryManagerWidget
implements RepositoryManagerWidget {
    private String parentToken = "";
    private String restToken = "";
    private FlowPanel enrichContentBoxContent = new FlowPanel();
    private Alert errorAlert = new Alert();
    private static HelpServiceAsync helpService = (HelpServiceAsync)GWT.create(HelpService.class);
    private static BrokerServiceAsync brokerService = (BrokerServiceAsync)GWT.create(BrokerService.class);

    public EnrichContentWidget() {
        HTML title = new HTML("<h1 class=\"uk-article-title\">Enrich Your Content - Browse Events</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        this.contentPanel.add((Widget)title);
        this.errorAlert.setType(AlertType.DANGER);
        this.errorAlert.setDismissable(false);
        this.errorAlert.setVisible(false);
        this.enrichContentBoxContent.add((Widget)this.errorAlert);
        this.contentPanel.add((Widget)this.enrichContentBoxContent);
    }

    public void clear() {
        this.enrichContentBoxContent.clear();
        this.errorAlert.setVisible(false);
        this.gridPanel.remove((Widget)this.helpPanel);
    }

    public void reload() {
        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        this.enrichContentBoxContent.add((Widget)this.errorAlert);
        helpService.getHelpById(this.parentToken, (AsyncCallback)new HelpCallback(this.helpPanel, this.gridPanel));
        HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; color: rgb(47, 64, 80); font-weight: bold;\">Retrieving repositories...</div><div class=\"whiteFilm\"></div>");
        this.enrichContentBoxContent.addStyleName("loading-big");
        this.enrichContentBoxContent.add((Widget)loadingWheel);
        brokerService.getDatasourcesOfUser(RepositoryManager.currentUser.getEmail(), false, false, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    public void afterAdditionToRootPanel() {
    }

    private void createReposList(DatasourcesBroker datasourcesBroker, FlowPanel reposList) {
        reposList.addStyleName("uk-grid-margin uk-grid uk-grid-stack repos-list");
        if (datasourcesBroker.getDatasourcesOfUser().isEmpty()) {
            reposList.add((Widget)new HTML("No Datasources are registered under your account"));
        } else {
            FlowPanel colPanel = new FlowPanel();
            colPanel.addStyleName("uk-width-1-1@m uk-first-column");
            reposList.add((Widget)colPanel);
            FlowPanel divPanel = new FlowPanel();
            divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");
            colPanel.add((Widget)divPanel);
            String content = "<table class=\"uk-table uk-table-striped uk-table-middle\"><thead><tr><th>Logo</th><th class=\"uk-text-nowrap\">Name</th><th class=\"uk-text-nowrap\"># of events</th></tr></thead>";
            content = content + "<tbody>";
            for (Tuple datasource : datasourcesBroker.getDatasourcesOfUser()) {
                content = content + "<tr class=\"el-item\"><td class=\"uk-table-shrink\"><a href=\"#" + this.parentToken + "/" + ((BrowseEntry)datasource.getFirst()).getValue() + "\" class=\"el-link\">";
                content = datasource.getSecond() == null || ((String)datasource.getSecond()).trim().isEmpty() ? content + "<img src=\"img/yourLogoHere.jpg\" alt=\"[Repo Logo]\" class=\"el-image uk-preserve-width\" style=\"height: 45px\">" : content + "<img src=\"" + (String)datasource.getSecond() + "\" alt=\"[Repo Logo]\" class=\"el-image uk-preserve-width\" style=\"height: 45px\">";
                content = content + "</a></td><td class=\"uk-text-nowrap uk-table-shrink\">\n<a href=\"#" + this.parentToken + "/" + ((BrowseEntry)datasource.getFirst()).getValue() + "\" class=\"el-link\">" + ((BrowseEntry)datasource.getFirst()).getValue() + "</a></td><td class=\"uk-text-nowrap uk-table-shrink\">\n<a href=\"#" + this.parentToken + "/" + ((BrowseEntry)datasource.getFirst()).getValue() + "\" class=\"el-link\"><div class=\"el-title\">" + ((BrowseEntry)datasource.getFirst()).getSize() + "</div></a></td></tr>";
            }
            content = content + "</tbody></table>";
            HTML reposListHTML = new HTML();
            reposListHTML.setHTML(content);
            divPanel.add((Widget)reposListHTML);
        }
    }

    private void createReposGrid(DatasourcesBroker datasourcesBroker, FlowPanel reposGrid) {
        reposGrid.addStyleName("uk-grid-large uk-grid-margin-large uk-grid repos-grid");
        if (datasourcesBroker.getDatasourcesOfUser().isEmpty()) {
            reposGrid.add((Widget)new HTML("No Datasources are registered under your account"));
        } else if (datasourcesBroker.getDatasourcesOfUser().size() == 1) {
            FlowPanel colPanel = new FlowPanel();
            colPanel.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel);
            FlowPanel divPanel = new FlowPanel();
            divPanel.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel.add((Widget)divPanel);
            divPanel.add((Widget)this.createGridItemForRepo((Tuple)datasourcesBroker.getDatasourcesOfUser().get(0), false));
        } else if (datasourcesBroker.getDatasourcesOfUser().size() == 2) {
            FlowPanel colPanel1 = new FlowPanel();
            colPanel1.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel1);
            FlowPanel divPanel1 = new FlowPanel();
            divPanel1.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel1.add((Widget)divPanel1);
            divPanel1.add((Widget)this.createGridItemForRepo((Tuple)datasourcesBroker.getDatasourcesOfUser().get(0), false));
            FlowPanel colPanel2 = new FlowPanel();
            colPanel2.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel2);
            FlowPanel divPanel2 = new FlowPanel();
            divPanel2.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel2.add((Widget)divPanel2);
            divPanel2.add((Widget)this.createGridItemForRepo((Tuple)datasourcesBroker.getDatasourcesOfUser().get(1), false));
        } else {
            FlowPanel colPanel1 = new FlowPanel();
            colPanel1.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel1);
            FlowPanel divPanel1 = new FlowPanel();
            divPanel1.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel1.add((Widget)divPanel1);
            FlowPanel colPanel2 = new FlowPanel();
            colPanel2.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel2);
            FlowPanel divPanel2 = new FlowPanel();
            divPanel2.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel2.add((Widget)divPanel2);
            FlowPanel colPanel3 = new FlowPanel();
            colPanel3.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel3);
            FlowPanel divPanel3 = new FlowPanel();
            divPanel3.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel3.add((Widget)divPanel3);
            for (int i = 0; i < datasourcesBroker.getDatasourcesOfUser().size(); ++i) {
                boolean addExtraClass = false;
                if (i > 2) {
                    addExtraClass = true;
                }
                if (i % 3 == 0) {
                    divPanel1.add((Widget)this.createGridItemForRepo((Tuple)datasourcesBroker.getDatasourcesOfUser().get(i), addExtraClass));
                    continue;
                }
                if (i % 3 == 1) {
                    divPanel2.add((Widget)this.createGridItemForRepo((Tuple)datasourcesBroker.getDatasourcesOfUser().get(i), addExtraClass));
                    continue;
                }
                divPanel3.add((Widget)this.createGridItemForRepo((Tuple)datasourcesBroker.getDatasourcesOfUser().get(i), addExtraClass));
            }
        }
    }

    private FlowPanel createGridItemForRepo(Tuple<BrowseEntry, String> datasource, boolean addExtraClass) {
        FlowPanel gridItem = new FlowPanel();
        if (addExtraClass) {
            gridItem.addStyleName("uk-grid-margin uk-first-column");
        } else {
            gridItem.addStyleName("uk-first-column");
        }
        String gridItemContent = "<a href=\"#" + this.parentToken + "/" + ((BrowseEntry)datasource.getFirst()).getValue() + "\" class=\"el-link\">";
        gridItemContent = gridItemContent + "<div uk-scrollspy-class=\"\" class=\"el-item uk-panel uk-scrollspy-inview uk-animation-slide-top-medium\" style=\"\"><div class=\"uk-child-width-expand uk-grid-medium uk-flex-middle uk-grid\" uk-grid=\"\">";
        gridItemContent = gridItemContent + "<div class=\"uk-width-1-3@m uk-first-column\">";
        gridItemContent = datasource.getSecond() == null || ((String)datasource.getSecond()).trim().isEmpty() ? gridItemContent + "<img src=\"img/yourLogoHere.jpg\" class=\"el-image uk-border-rounded\" alt=\"\">" : gridItemContent + "<img src=\"" + (String)datasource.getSecond() + "\" class=\"el-image uk-border-rounded\" alt=\"\">";
        gridItemContent = gridItemContent + "</div>";
        gridItemContent = gridItemContent + "<div><h3 class=\"el-title uk-margin uk-h5 uk-margin-remove-adjacent uk-margin-small-bottom\">" + ((BrowseEntry)datasource.getFirst()).getValue() + "</h3><div class=\"el-meta uk-margin uk-text-meta\">(" + ((BrowseEntry)datasource.getFirst()).getSize() + " events)</div></div>";
        gridItemContent = gridItemContent + "</div></div></a>";
        gridItem.add((Widget)new HTML(gridItemContent));
        return gridItem;
    }

    static /* synthetic */ FlowPanel access$000(EnrichContentWidget x0) {
        return x0.enrichContentBoxContent;
    }

    static /* synthetic */ Alert access$100(EnrichContentWidget x0) {
        return x0.errorAlert;
    }

    static /* synthetic */ void access$200(EnrichContentWidget x0, DatasourcesBroker x1, FlowPanel x2) {
        x0.createReposList(x1, x2);
    }

    static /* synthetic */ void access$300(EnrichContentWidget x0, DatasourcesBroker x1, FlowPanel x2) {
        x0.createReposGrid(x1, x2);
    }
}

