/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.enrichcontent;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.shared.broker.AdvQueryObject;
import eu.dnetlib.repo.manager.shared.broker.NotificationFrequency;
import eu.dnetlib.repo.manager.shared.broker.NotificationMode;
import eu.dnetlib.repo.manager.shared.broker.OpenaireSubscription;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.constants.AlertType;

public class EventsSubscriptionForm
implements IsWidget {
    private FlowPanel subscriptionFormPanel = new FlowPanel();
    private Alert errorLabel = new Alert();
    private Form subscriptionForm = new Form();
    private ListBox frequencyListBox = new ListBox();
    private MyFormGroup frequencyListFormGroup = new MyFormGroup(false, "Frequency (*)", new Widget[]{this.frequencyListBox});
    private ListBox modeListBox = new ListBox();
    private MyFormGroup modeListFormGroup = new MyFormGroup(false, "Mode (*)", new Widget[]{this.modeListBox});
    private AdvQueryObject advQueryObject;

    public EventsSubscriptionForm(AdvQueryObject advQueryObject) {
        this.advQueryObject = advQueryObject;
        this.errorLabel.setType(AlertType.DANGER);
        this.errorLabel.setVisible(false);
        this.errorLabel.setDismissable(false);
        this.subscriptionFormPanel.add((Widget)this.errorLabel);
        this.subscriptionFormPanel.add((Widget)new HTML("<h4 class=\"uk-h4\">" + this.advQueryObject.getDatasource() + "</h4><div class=\"uk-text uk-text-small uk-text-secondary\">" + this.advQueryObject.getTopic().replace("/", "  |  ") + "</div>"));
        this.subscriptionFormPanel.add((Widget)this.subscriptionForm);
        HTML userEmail = new HTML(RepositoryManager.currentUser.getEmail());
        MyFormGroup userEmailFormGroup = new MyFormGroup(false, "Email", new Widget[]{userEmail});
        this.subscriptionForm.add((IsWidget)userEmailFormGroup);
        this.frequencyListBox.addItem("-- none selected --", "noneSelected");
        for (NotificationFrequency notificationFrequency : NotificationFrequency.values()) {
            this.frequencyListBox.addItem(notificationFrequency.name(), notificationFrequency.name());
        }
        this.subscriptionForm.add((IsWidget)this.frequencyListFormGroup);
        HTML options = new HTML();
        options.setHTML(this.generateOptionsContent());
        MyFormGroup optionsFormGroup = new MyFormGroup(false, "Options", new Widget[]{options});
        this.subscriptionForm.add((IsWidget)optionsFormGroup);
    }

    public Widget asWidget() {
        return this.subscriptionFormPanel;
    }

    public boolean validate() {
        this.errorLabel.setVisible(false);
        if (!this.frequencyListBox.getSelectedValue().equals("noneSelected")) {
            return true;
        }
        this.errorLabel.setVisible(true);
        this.errorLabel.setText("All asterisk (*) fields are mandatory");
        return false;
    }

    public OpenaireSubscription getOpenAIRESubscription() {
        OpenaireSubscription openaireSubscription = new OpenaireSubscription();
        openaireSubscription.setSubscriber(RepositoryManager.currentUser.getEmail());
        openaireSubscription.setFrequency(NotificationFrequency.valueOf((String)this.frequencyListBox.getSelectedValue()));
        openaireSubscription.setMode(NotificationMode.valueOf((String)this.modeListBox.getSelectedValue()));
        openaireSubscription.setQuery(this.advQueryObject);
        return openaireSubscription;
    }

    private String generateOptionsContent() {
        int i;
        String optionsContent = "<table class=\"table table-bordered\">";
        optionsContent = optionsContent + "<tbody>";
        if (this.advQueryObject.getTrust() != null) {
            optionsContent = optionsContent + "<tr><td>Trust</td><td>[" + this.advQueryObject.getTrust().getMin() + ", " + this.advQueryObject.getTrust().getMax() + "]</td></tr>";
        }
        if (this.advQueryObject.getTitles() != null && !this.advQueryObject.getTitles().isEmpty()) {
            optionsContent = optionsContent + "<tr><td>Titles</td><td>";
            for (i = 0; i < this.advQueryObject.getTitles().size(); ++i) {
                optionsContent = optionsContent + (String)this.advQueryObject.getTitles().get(i);
                if (i == this.advQueryObject.getTitles().size() - 1) continue;
                optionsContent = optionsContent + "<br>";
            }
            optionsContent = optionsContent + "</td></tr>";
        }
        if (this.advQueryObject.getAuthors() != null && !this.advQueryObject.getAuthors().isEmpty()) {
            optionsContent = optionsContent + "<tr><td>Authors</td><td>";
            for (i = 0; i < this.advQueryObject.getAuthors().size(); ++i) {
                optionsContent = optionsContent + (String)this.advQueryObject.getAuthors().get(i);
                if (i == this.advQueryObject.getAuthors().size() - 1) continue;
                optionsContent = optionsContent + "<br>";
            }
            optionsContent = optionsContent + "</td></tr>";
        }
        if (this.advQueryObject.getSubjects() != null && !this.advQueryObject.getSubjects().isEmpty()) {
            optionsContent = optionsContent + "<tr><td>Subjects</td><td>";
            for (i = 0; i < this.advQueryObject.getSubjects().size(); ++i) {
                optionsContent = optionsContent + (String)this.advQueryObject.getSubjects().get(i);
                if (i == this.advQueryObject.getSubjects().size() - 1) continue;
                optionsContent = optionsContent + "<br>";
            }
            optionsContent = optionsContent + "</td></tr>";
        }
        optionsContent = optionsContent + "</tbody>";
        optionsContent = optionsContent + "</table>";
        return optionsContent;
    }
}

