/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.enrichcontent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.query.client.GQuery;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.enrichcontent.ShowEventsWidget;
import eu.dnetlib.repo.manager.client.enrichcontent.advancedsearch.EnrichContentAdvancedSearchForm;
import eu.dnetlib.repo.manager.client.services.BrokerService;
import eu.dnetlib.repo.manager.client.services.BrokerServiceAsync;
import eu.dnetlib.repo.manager.shared.broker.AdvQueryObject;
import eu.dnetlib.repo.manager.shared.broker.EventsPage;
import eu.dnetlib.repo.manager.shared.broker.Instance;
import eu.dnetlib.repo.manager.shared.broker.OpenAireEventPayload;
import eu.dnetlib.repo.manager.shared.broker.Pid;
import eu.dnetlib.repo.manager.shared.broker.Project;
import java.util.List;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.html.UnorderedList;

public class ShowEventsWidget
extends AbstractRepositoryManagerWidget
implements RepositoryManagerWidget {
    private String parentToken = "";
    private String restToken = "";
    private String dataSource = "";
    private String topic = "";
    private long pageSize = 10L;
    private AdvQueryObject advQueryObject = new AdvQueryObject();
    private HTML title = new HTML();
    private FlowPanel showEventsBoxContent = new FlowPanel();
    private Alert errorAlert = new Alert();
    private Alert successAlert = new Alert();
    private static HelpServiceAsync helpService = (HelpServiceAsync)GWT.create(HelpService.class);
    private static BrokerServiceAsync brokerService = (BrokerServiceAsync)GWT.create(BrokerService.class);

    public ShowEventsWidget() {
        this.title.addStyleName("uk-margin-medium-bottom");
        this.contentPanel.add((Widget)this.title);
        this.errorAlert.setType(AlertType.DANGER);
        this.errorAlert.setDismissable(false);
        this.errorAlert.setVisible(false);
        this.showEventsBoxContent.add((Widget)this.errorAlert);
        this.successAlert.setType(AlertType.SUCCESS);
        this.successAlert.setDismissable(false);
        this.successAlert.setVisible(false);
        this.showEventsBoxContent.add((Widget)this.successAlert);
        this.contentPanel.add((Widget)this.showEventsBoxContent);
    }

    public void clear() {
        this.showEventsBoxContent.clear();
        this.errorAlert.setVisible(false);
        this.successAlert.setVisible(false);
        this.gridPanel.remove((Widget)this.helpPanel);
        this.advQueryObject = new AdvQueryObject();
    }

    public void reload() {
        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        this.title.setHTML("<h1 class=\"uk-article-title\">" + this.dataSource + "</h1><div class=\"uk-text uk-text-small uk-text-secondary\">" + this.topic.replace("/", "  |  ") + "</div>");
        this.advQueryObject.setDatasource(this.dataSource);
        this.advQueryObject.setTopic(this.topic);
        this.showEvents(0L);
        helpService.getHelpById(this.parentToken + "_showEvents", (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
        String[] tokenSplit = this.restToken.split("/", 2);
        this.dataSource = tokenSplit[0];
        this.topic = tokenSplit[1];
    }

    public void afterAdditionToRootPanel() {
    }

    private FlowPanel showAdvancedSearch() {
        EnrichContentAdvancedSearchForm enrichContentAdvancedSearchForm = new EnrichContentAdvancedSearchForm(this.dataSource, this.topic);
        2 advancedSearchFormSelectionListener = new /* Unavailable Anonymous Inner Class!! */;
        enrichContentAdvancedSearchForm.setAdvancedSearchFormSelectionListener((EnrichContentAdvancedSearchForm.AdvancedSearchFormSelectionListener)advancedSearchFormSelectionListener);
        FlowPanel advancedSearch = new FlowPanel();
        advancedSearch.addStyleName("enrichContentAdvancedSearch uk-card uk-card-body uk-card-default sidemenu");
        advancedSearch.add((Widget)new HTML("<h6 class=\"uk-h6 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\"uk-scrollspy-class=\"\"><span>Tweak and refine events</span></h4>"));
        advancedSearch.add(enrichContentAdvancedSearchForm.asWidget());
        return advancedSearch;
    }

    private void showEvents(long currentPage) {
        this.showEventsBoxContent.clear();
        this.showEventsBoxContent.add((Widget)this.errorAlert);
        this.showEventsBoxContent.add((Widget)this.successAlert);
        HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; color: rgb(47, 64, 80); font-weight: bold;\">Retrieving events...</div><div class=\"whiteFilm\"></div>");
        this.showEventsBoxContent.addStyleName("loading-big");
        this.showEventsBoxContent.add((Widget)loadingWheel);
        brokerService.advancedShowEvents(this.advQueryObject, currentPage, this.pageSize, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createEventsList(EventsPage eventsPage, FlowPanel eventsList) {
        if (eventsPage == null || eventsPage.getTotal() == 0L) {
            eventsList.add((Widget)new HTML("<div class=\"alert alert-warning\">No events were found for this topic.</div>"));
        } else {
            long from = eventsPage.getCurrPage() * this.pageSize + 1L;
            long to = (eventsPage.getCurrPage() + 1L) * this.pageSize;
            if (to > eventsPage.getTotal()) {
                to = eventsPage.getTotal();
            }
            HTML numberOfResultsLabel = new HTML("<span>Showing " + from + "-" + to + " of " + eventsPage.getTotal() + " results</span><span class=\"uk-float-right\"><button id=\"subscribe\" style=\"\" type=\"button\" class=\"uk-button uk-button-primary uk-button-small\">Subscribe to these events</button></span>");
            numberOfResultsLabel.addStyleName("numberOfEventsLabel");
            eventsList.add((Widget)numberOfResultsLabel);
            FlowPanel topPagerPanel = new FlowPanel();
            this.drawPager(topPagerPanel, eventsPage);
            eventsList.add((Widget)topPagerPanel);
            String content = "";
            for (OpenAireEventPayload payload : eventsPage.getValues()) {
                content = content + this.returnPayloadContent(payload);
            }
            HTML eventsListHTML = new HTML();
            eventsListHTML.addStyleName("events-list");
            eventsListHTML.setHTML(content);
            eventsList.add((Widget)eventsListHTML);
            FlowPanel bottomPagerPanel = new FlowPanel();
            this.drawPager(bottomPagerPanel, eventsPage);
            eventsList.add((Widget)bottomPagerPanel);
        }
    }

    private void drawPager(FlowPanel pagerPanel, EventsPage eventsPage) {
        UnorderedList pager = new UnorderedList();
        pager.addStyleName("uk-pagination");
        ListItem listItemPrevious = new ListItem();
        Anchor previous = new Anchor();
        previous.setHTML("<span class=\"uk-margin-small-right\" uk-pagination-previous></span> Previous");
        previous.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        listItemPrevious.add((Widget)previous);
        pager.add((Widget)listItemPrevious);
        ListItem listItemNext = new ListItem();
        listItemNext.addStyleName("uk-margin-auto-left");
        Anchor next = new Anchor();
        next.setHTML("Next <span class=\"uk-margin-small-left\" uk-pagination-next></span>");
        next.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        listItemNext.add((Widget)next);
        pager.add((Widget)listItemNext);
        if (eventsPage.getCurrPage() == 0L) {
            previous.setEnabled(false);
            listItemPrevious.addStyleName("uk-disabled");
        } else {
            previous.setEnabled(true);
            listItemPrevious.removeStyleName("uk-disabled");
        }
        if (eventsPage.getCurrPage() == eventsPage.getTotalPages() - 1L) {
            next.setEnabled(false);
            listItemNext.addStyleName("uk-disabled");
        } else {
            next.setEnabled(true);
            listItemNext.removeStyleName("uk-disabled");
        }
        pagerPanel.add((Widget)pager);
        Label pageNumber = new Label();
        pageNumber.setText("page " + (eventsPage.getCurrPage() + 1L) + " of " + eventsPage.getTotalPages());
        pageNumber.addStyleName("resultsPageLabel");
        pagerPanel.add((Widget)pageNumber);
    }

    private String returnPayloadContent(OpenAireEventPayload openAireEventPayload) {
        int i;
        int i2;
        String payloadContent = "";
        payloadContent = payloadContent + "<div class=\"uk-card uk-card-default well uk-scrollspy-inview uk-animation-slide-top-medium\"><div class=\"uk-grid-margin uk-grid uk-grid-stack\" uk-grid=\"\"><div class=\"uk-width-1-1@m uk-first-column\"><p class=\"text-right\"><span class=\"uk-label\">Trust: </b>" + openAireEventPayload.getTrust() + "</span></p>";
        payloadContent = payloadContent + "<div class=\"uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium\"><table class=\"uk-table uk-table-striped uk-table-middle\"><tbody>";
        payloadContent = payloadContent + "<tr class=\"el-item\"><td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">ID</strong></td><td class=\"uk-table-shrink\">\n<div class=\"el-title\">" + openAireEventPayload.getPublication().getOriginalId() + "</div></td></tr>";
        payloadContent = payloadContent + "<tr class=\"el-item\"><td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">Title(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";
        for (i2 = 0; i2 < openAireEventPayload.getPublication().getTitles().size(); ++i2) {
            if (i2 != 0) {
                payloadContent = payloadContent + "<br>";
            }
            payloadContent = payloadContent + "<span>" + (String)openAireEventPayload.getPublication().getTitles().get(i2) + "</span>";
        }
        payloadContent = payloadContent + "</div></td></tr>";
        payloadContent = payloadContent + "<tr class=\"el-item\"><td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">Author(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";
        for (i2 = 0; i2 < openAireEventPayload.getPublication().getCreators().size(); ++i2) {
            if (i2 != 0) {
                payloadContent = payloadContent + " | ";
            }
            payloadContent = payloadContent + "<span>" + (String)openAireEventPayload.getPublication().getCreators().get(i2) + "</span>";
        }
        payloadContent = payloadContent + "</div></td></tr>";
        payloadContent = openAireEventPayload.getHighlight().getPids() != null && !openAireEventPayload.getHighlight().getPids().isEmpty() ? payloadContent + "<tr class=\"el-item success\">" : payloadContent + "<tr class=\"el-item\">";
        payloadContent = payloadContent + "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">PID(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";
        for (Pid pid : openAireEventPayload.getPublication().getPids()) {
            payloadContent = payloadContent + "<span>" + pid.getValue() + "<b>&nbsp;&nbsp;(" + pid.getType() + ")&nbsp;&nbsp;</b> ";
            if (this.isPidHighlighted(pid, openAireEventPayload.getHighlight().getPids())) {
                payloadContent = payloadContent + "<span>";
                payloadContent = payloadContent + "<span class=\"uk-label uk-label-success\">added</span>";
                if (openAireEventPayload.getProvenance() != null) {
                    payloadContent = payloadContent + "<span class=\"pull-right\"><b>from: </b>";
                    if (openAireEventPayload.getProvenance().getUrl() != null) {
                        payloadContent = payloadContent + "<a href=\"" + openAireEventPayload.getProvenance().getUrl() + "\" target=\"_blank\">" + openAireEventPayload.getProvenance().getRepositoryName() + "</a>";
                    }
                    if (openAireEventPayload.getProvenance().getId() != null) {
                        payloadContent = payloadContent + "<span> (ID: " + openAireEventPayload.getProvenance().getId() + ")</span>";
                    }
                    payloadContent = payloadContent + "</span>";
                }
                payloadContent = payloadContent + "</span>";
            }
            payloadContent = payloadContent + "</span>";
        }
        payloadContent = payloadContent + "</div></td></tr>";
        payloadContent = openAireEventPayload.getHighlight().getAbstracts() != null && !openAireEventPayload.getHighlight().getAbstracts().isEmpty() ? payloadContent + "<tr class=\"el-item success\">" : payloadContent + "<tr class=\"el-item\">";
        payloadContent = payloadContent + "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">Abstract(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";
        for (i = 0; i < openAireEventPayload.getPublication().getAbstracts().size(); ++i) {
            if (i != 0) {
                payloadContent = payloadContent + "<br>";
            }
            payloadContent = payloadContent + "<span>" + (String)openAireEventPayload.getPublication().getAbstracts().get(i) + "</span>";
            if (openAireEventPayload.getHighlight().getAbstracts() == null || openAireEventPayload.getHighlight().getAbstracts().isEmpty() || openAireEventPayload.getProvenance() == null) continue;
            payloadContent = payloadContent + "<span class=\"pull-right\"><b>from: </b>";
            if (openAireEventPayload.getProvenance().getUrl() != null) {
                payloadContent = payloadContent + "<a href=\"" + openAireEventPayload.getProvenance().getUrl() + "\" target=\"_blank\">" + openAireEventPayload.getProvenance().getRepositoryName() + "</a>";
            }
            if (openAireEventPayload.getProvenance().getId() != null) {
                payloadContent = payloadContent + "<span> (ID: " + openAireEventPayload.getProvenance().getId() + ")</span>";
            }
            payloadContent = payloadContent + "</span>";
        }
        payloadContent = payloadContent + "</div></td></tr>";
        payloadContent = openAireEventPayload.getHighlight().getProjects() != null && !openAireEventPayload.getHighlight().getProjects().isEmpty() ? payloadContent + "<tr class=\"el-item success\">" : payloadContent + "<tr class=\"el-item\">";
        payloadContent = payloadContent + "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">Project(s)/Relation(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";
        for (i = 0; i < openAireEventPayload.getPublication().getProjects().size(); ++i) {
            if (i != 0) {
                payloadContent = payloadContent + "<br>";
            }
            payloadContent = ((Project)openAireEventPayload.getPublication().getProjects().get(i)).getAcronym() != null && !((Project)openAireEventPayload.getPublication().getProjects().get(i)).getAcronym().trim().equals("") ? payloadContent + "<span>" + ((Project)openAireEventPayload.getPublication().getProjects().get(i)).getAcronym() + "</span>" : payloadContent + "<span>" + ((Project)openAireEventPayload.getPublication().getProjects().get(i)).getTitle() + "</span>";
            if (openAireEventPayload.getHighlight().getProjects() == null || openAireEventPayload.getHighlight().getProjects().isEmpty() || openAireEventPayload.getProvenance() == null) continue;
            payloadContent = payloadContent + "<span class=\"pull-right\"><b>from: </b>";
            if (openAireEventPayload.getProvenance().getUrl() != null) {
                payloadContent = payloadContent + "<a href=\"" + openAireEventPayload.getProvenance().getUrl() + "\" target=\"_blank\">" + openAireEventPayload.getProvenance().getRepositoryName() + "</a>";
            }
            if (openAireEventPayload.getProvenance().getId() != null) {
                payloadContent = payloadContent + "<span> (ID: " + openAireEventPayload.getProvenance().getId() + ")</span>";
            }
            payloadContent = payloadContent + "</span>";
        }
        payloadContent = payloadContent + "</div></td></tr>";
        if (openAireEventPayload.getHighlight().getSubjects() != null && !openAireEventPayload.getHighlight().getSubjects().isEmpty()) {
            payloadContent = payloadContent + "<tr class=\"el-item success\">";
            payloadContent = payloadContent + "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">Subject(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";
            for (i = 0; i < openAireEventPayload.getPublication().getSubjects().size(); ++i) {
                if (i != 0) {
                    payloadContent = payloadContent + "<br>";
                }
                payloadContent = payloadContent + "<span>" + (String)openAireEventPayload.getPublication().getSubjects().get(i) + "</span>";
                if (openAireEventPayload.getHighlight().getSubjects() == null || openAireEventPayload.getHighlight().getSubjects().isEmpty() || openAireEventPayload.getProvenance() == null) continue;
                payloadContent = payloadContent + "<span class=\"pull-right\"><b>from: </b>";
                if (openAireEventPayload.getProvenance().getUrl() != null) {
                    payloadContent = payloadContent + "<a href=\"" + openAireEventPayload.getProvenance().getUrl() + "\" target=\"_blank\">" + openAireEventPayload.getProvenance().getRepositoryName() + "</a>";
                }
                if (openAireEventPayload.getProvenance().getId() != null) {
                    payloadContent = payloadContent + "<span> (ID: " + openAireEventPayload.getProvenance().getId() + ")</span>";
                }
                payloadContent = payloadContent + "</span>";
            }
            payloadContent = payloadContent + "</div></td></tr>";
        } else {
            payloadContent = payloadContent + "<tr class=\"el-item\">";
            payloadContent = payloadContent + "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">Subject(s)</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";
            for (i = 0; i < openAireEventPayload.getPublication().getSubjects().size(); ++i) {
                if (i != 0) {
                    payloadContent = payloadContent + ", ";
                }
                payloadContent = payloadContent + "<span>" + (String)openAireEventPayload.getPublication().getSubjects().get(i) + "</span>";
            }
            payloadContent = payloadContent + "</div></td></tr>";
        }
        payloadContent = openAireEventPayload.getHighlight().getPublicationdate() != null && !openAireEventPayload.getHighlight().getPublicationdate().isEmpty() ? payloadContent + "<tr class=\"el-item success\">" : payloadContent + "<tr class=\"el-item\">";
        payloadContent = payloadContent + "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">Publication date</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">" + openAireEventPayload.getPublication().getPublicationdate() + "</div></td></tr>";
        payloadContent = openAireEventPayload.getHighlight().getInstances() != null && !openAireEventPayload.getHighlight().getInstances().isEmpty() ? payloadContent + "<tr class=\"el-item success\">" : payloadContent + "<tr class=\"el-item\">";
        payloadContent = payloadContent + "<td class=\"uk-table-shrink uk-width-1-4\"><strong class=\"el-title uk-display-block\">Rights</strong></td><td class=\"uk-table-shrink\"><div class=\"el-title\">";
        for (i = 0; i < openAireEventPayload.getPublication().getInstances().size(); ++i) {
            if (i != 0) {
                payloadContent = payloadContent + "<br>";
            }
            payloadContent = payloadContent + "<span>";
            payloadContent = payloadContent + ((Instance)openAireEventPayload.getPublication().getInstances().get(i)).getLicense() + "&nbsp;&nbsp;<b>" + ((Instance)openAireEventPayload.getPublication().getInstances().get(i)).getHostedby() + "</b>";
            payloadContent = payloadContent + "<br>";
            payloadContent = payloadContent + "<a href=\"" + ((Instance)openAireEventPayload.getPublication().getInstances().get(i)).getUrl() + "\" target=\"_blank\">" + ((Instance)openAireEventPayload.getPublication().getInstances().get(i)).getUrl() + "</a>&nbsp;&nbsp;";
            payloadContent = payloadContent + "</span>";
            if (!this.isInstanceHighlighted((Instance)openAireEventPayload.getPublication().getInstances().get(i), openAireEventPayload.getHighlight().getInstances())) continue;
            payloadContent = payloadContent + "<span>";
            payloadContent = payloadContent + "<span class=\"uk-label uk-label-success\">added</span>";
            if (openAireEventPayload.getProvenance() != null) {
                payloadContent = payloadContent + "<span class=\"pull-right\"><b>from: </b>";
                if (openAireEventPayload.getProvenance().getUrl() != null) {
                    payloadContent = payloadContent + "<a href=\"" + openAireEventPayload.getProvenance().getUrl() + "\" target=\"_blank\">" + openAireEventPayload.getProvenance().getRepositoryName() + "</a>";
                }
                if (openAireEventPayload.getProvenance().getId() != null) {
                    payloadContent = payloadContent + "<span> (ID: " + openAireEventPayload.getProvenance().getId() + ")</span>";
                }
                payloadContent = payloadContent + "</span>";
            }
            payloadContent = payloadContent + "</span>";
        }
        payloadContent = payloadContent + "</div></td></tr>";
        payloadContent = payloadContent + "</tbody></table></div></div></div></div>";
        return payloadContent;
    }

    private boolean isPidHighlighted(Pid pid, List<Pid> highlightedPIDs) {
        for (Pid highlightedPid : highlightedPIDs) {
            if (!highlightedPid.getType().equals(pid.getType()) || !highlightedPid.getValue().equals(pid.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean isInstanceHighlighted(Instance instance, List<Instance> highlightedInstances) {
        for (Instance highlightedInstance : highlightedInstances) {
            if (!highlightedInstance.getUrl().equals(instance.getUrl()) || !highlightedInstance.getHostedby().equals(instance.getHostedby()) || !highlightedInstance.getInstancetype().equals(instance.getInstancetype()) || !highlightedInstance.getLicense().equals(instance.getLicense())) continue;
            return true;
        }
        return false;
    }

    private void addSubscribeHandler() {
        GQuery.$((String)"#subscribe").click(new Function[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    static /* synthetic */ FlowPanel access$000(ShowEventsWidget x0) {
        return x0.helpPanel;
    }

    static /* synthetic */ FlowPanel access$100(ShowEventsWidget x0) {
        return x0.gridPanel;
    }

    static /* synthetic */ FlowPanel access$200(ShowEventsWidget x0) {
        return x0.helpPanel;
    }

    static /* synthetic */ FlowPanel access$300(ShowEventsWidget x0) {
        return x0.showAdvancedSearch();
    }

    static /* synthetic */ FlowPanel access$400(ShowEventsWidget x0) {
        return x0.helpPanel;
    }

    static /* synthetic */ FlowPanel access$500(ShowEventsWidget x0) {
        return x0.helpPanel;
    }

    static /* synthetic */ FlowPanel access$600(ShowEventsWidget x0) {
        return x0.helpPanel;
    }

    static /* synthetic */ FlowPanel access$700(ShowEventsWidget x0) {
        return x0.helpPanel;
    }

    static /* synthetic */ AdvQueryObject access$802(ShowEventsWidget x0, AdvQueryObject x1) {
        x0.advQueryObject = x1;
        return x0.advQueryObject;
    }

    static /* synthetic */ void access$900(ShowEventsWidget x0, long x1) {
        x0.showEvents(x1);
    }

    static /* synthetic */ FlowPanel access$1000(ShowEventsWidget x0) {
        return x0.showEventsBoxContent;
    }

    static /* synthetic */ Alert access$1100(ShowEventsWidget x0) {
        return x0.errorAlert;
    }

    static /* synthetic */ void access$1200(ShowEventsWidget x0, EventsPage x1, FlowPanel x2) {
        x0.createEventsList(x1, x2);
    }

    static /* synthetic */ void access$1300(ShowEventsWidget x0) {
        x0.addSubscribeHandler();
    }

    static /* synthetic */ Alert access$1400(ShowEventsWidget x0) {
        return x0.successAlert;
    }

    static /* synthetic */ AdvQueryObject access$800(ShowEventsWidget x0) {
        return x0.advQueryObject;
    }

    static /* synthetic */ BrokerServiceAsync access$1500() {
        return brokerService;
    }
}

