/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.monitor;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.repo.manager.shared.AggregationDetails;
import java.util.List;

public class AggregationHistoryTimeline
implements IsWidget {
    private FlowPanel aggregationHistoryPanel = new FlowPanel();
    private DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd");

    public AggregationHistoryTimeline(List<AggregationDetails> aggregationHistory) {
        this.aggregationHistoryPanel.addStyleName("uk-width-1-1@m");
        FlowPanel section = new FlowPanel();
        section.addStyleName("section md-bg-blue-grey-700");
        this.aggregationHistoryPanel.add((Widget)section);
        FlowPanel container = new FlowPanel();
        container.addStyleName("uk-container uk-container-center");
        section.add((Widget)container);
        FlowPanel timeline = new FlowPanel();
        timeline.addStyleName("al_timeline");
        container.add((Widget)timeline);
        for (AggregationDetails aggregationDetails : aggregationHistory) {
            FlowPanel timelineBlock = new FlowPanel();
            timelineBlock.addStyleName("al_timeline_block versionChange");
            FlowPanel timelineImage = new FlowPanel();
            timelineImage.addStyleName("al_timeline_image uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-scale-up");
            timelineBlock.add((Widget)timelineImage);
            FlowPanel timelineContent = new FlowPanel();
            timelineContent.addStyleName("al_timeline_content uk-scrollspy-init-inview uk-scrollspy-inview uk-animation-slide-left");
            timelineBlock.add((Widget)timelineContent);
            String content = "";
            if (aggregationDetails.getDate() != null) {
                content = content + "<h3>" + this.dtf.format(aggregationDetails.getDate()) + "</h3>";
            }
            if (aggregationDetails.getAggregationStage() != null) {
                content = content + "<p>Aggregation stage - " + aggregationDetails.getAggregationStage() + "</p>";
            }
            if (aggregationDetails.getCollectionMode() != null) {
                content = content + "<p>Collection mode - " + aggregationDetails.getCollectionMode() + "</p>";
            }
            content = content + "<p>Number of records - " + aggregationDetails.getNumberOfRecords() + "</p>";
            timelineContent.add((Widget)new HTML(content));
            timeline.add((Widget)timelineBlock);
        }
    }

    public Widget asWidget() {
        return this.aggregationHistoryPanel;
    }
}

