/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.widgets;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.repo.manager.shared.DatasourcesCollection;
import org.gwtbootstrap3.client.ui.Anchor;

public class ListOrGridViewOfDatasourcesWidget
implements IsWidget {
    private FlowPanel listOrGridViewOfDatasourcesPanel = new FlowPanel();
    private String parentToken;
    private String icon;
    private boolean showPiwikInfo;

    public ListOrGridViewOfDatasourcesWidget(DatasourcesCollection datasourcesCollection, String title, String parentToken, String icon, boolean showPiwikInfo) {
        this.parentToken = parentToken;
        this.icon = icon;
        this.showPiwikInfo = showPiwikInfo;
        this.listOrGridViewOfDatasourcesPanel.addStyleName("uk-width-1-1 uk-grid");
        FlowPanel titlePanel = new FlowPanel();
        titlePanel.addStyleName("uk-width-1-1 uk-first-column uk-margin-bottom");
        this.listOrGridViewOfDatasourcesPanel.add((Widget)titlePanel);
        FlowPanel contentPanel = new FlowPanel();
        contentPanel.addStyleName("uk-width-1-1");
        this.listOrGridViewOfDatasourcesPanel.add((Widget)contentPanel);
        FlowPanel reposList = new FlowPanel();
        this.createReposList(datasourcesCollection, reposList);
        FlowPanel reposGrid = new FlowPanel();
        this.createReposGrid(datasourcesCollection, reposGrid);
        contentPanel.add((Widget)reposGrid);
        FlowPanel showOptions = new FlowPanel();
        showOptions.addStyleName("uk-float-right");
        titlePanel.add((Widget)showOptions);
        Anchor gridView = new Anchor();
        Anchor listView = new Anchor();
        gridView.addStyleName("grid-view active");
        gridView.setHTML("<i class=\"fa fa-th\"></i>");
        gridView.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        showOptions.add((Widget)gridView);
        listView.addStyleName("grid-view");
        listView.setHTML("<i class=\"fa fa-th-list\"></i>");
        listView.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        showOptions.add((Widget)listView);
    }

    public Widget asWidget() {
        return this.listOrGridViewOfDatasourcesPanel;
    }

    private void createReposList(DatasourcesCollection datasourcesCollection, FlowPanel reposList) {
        reposList.addStyleName("uk-grid-margin uk-grid uk-grid-stack repos-list");
        if (datasourcesCollection.getDatasourcesOfUser().isEmpty()) {
            reposList.add((Widget)new HTML("No Datasources are registered under your account"));
        } else {
            FlowPanel colPanel = new FlowPanel();
            colPanel.addStyleName("uk-width-1-1@m uk-first-column");
            reposList.add((Widget)colPanel);
            FlowPanel divPanel = new FlowPanel();
            divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");
            colPanel.add((Widget)divPanel);
            String content = "<table class=\"uk-table uk-table-striped uk-table-middle\"><thead><tr><th>Logo</th><th class=\"uk-text-nowrap\">Name</th>";
            if (this.showPiwikInfo) {
                content = content + "<th class=\"uk-text-nowrap\">Status</th>";
            }
            content = content + "</tr></thead>";
            content = content + "<tbody>";
            for (Repository repository : datasourcesCollection.getDatasourcesOfUser()) {
                content = content + "<tr class=\"el-item\"><td class=\"uk-table-shrink\"><a href=\"#" + this.parentToken + "/" + repository.getId() + "\" class=\"el-link\">";
                content = repository.getLogoUrl() == null || repository.getLogoUrl().trim().isEmpty() ? content + "<img src=\"img/yourLogoHere.jpg\" alt=\"[Repo Logo]\" class=\"el-image uk-preserve-width\" style=\"height: 45px\">" : content + "<img src=\"" + repository.getLogoUrl() + "\" alt=\"[Repo Logo]\" class=\"el-image uk-preserve-width\" style=\"height: 45px\">";
                content = content + "</a></td><td class=\"uk-text-nowrap uk-table-shrink\"><a href=\"#" + this.parentToken + "/" + repository.getId() + "\" class=\"el-link\"><div class=\"el-title\">" + repository.getOfficialName() + "</div></a></td>";
                if (this.showPiwikInfo) {
                    content = content + "<td class=\"uk-text-nowrap uk-table-shrink\"><a href=\"#" + this.parentToken + "/" + repository.getId() + "\" class=\"el-link\">";
                    content = repository.getPiwikInfo() == null ? content + "<div class=\"uk-badge uk-badge-danger\">not enabled</div>" : (!repository.getPiwikInfo().isValidated() ? content + "<div class=\"uk-badge uk-badge-warning\">enabling in progress</div>" : content + "<div class=\"uk-badge uk-badge-success\">enabled</div>");
                    content = content + "</a></td>";
                }
                content = content + "</tr>";
            }
            content = content + "</tbody></table>";
            HTML reposListHTML = new HTML();
            reposListHTML.setHTML(content);
            divPanel.add((Widget)reposListHTML);
        }
    }

    private void createReposGrid(DatasourcesCollection datasourcesCollection, FlowPanel reposGrid) {
        reposGrid.addStyleName("uk-grid-large uk-grid-margin-large uk-grid repos-grid");
        if (datasourcesCollection.getDatasourcesOfUser().isEmpty()) {
            reposGrid.add((Widget)new HTML("No Datasources are registered under your account"));
        } else if (datasourcesCollection.getDatasourcesOfUser().size() == 1) {
            FlowPanel colPanel = new FlowPanel();
            colPanel.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel);
            FlowPanel divPanel = new FlowPanel();
            divPanel.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel.add((Widget)divPanel);
            divPanel.add((Widget)this.createGridItemForRepo((Repository)datasourcesCollection.getDatasourcesOfUser().get(0), false));
        } else if (datasourcesCollection.getDatasourcesOfUser().size() == 2) {
            FlowPanel colPanel1 = new FlowPanel();
            colPanel1.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel1);
            FlowPanel divPanel1 = new FlowPanel();
            divPanel1.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel1.add((Widget)divPanel1);
            divPanel1.add((Widget)this.createGridItemForRepo((Repository)datasourcesCollection.getDatasourcesOfUser().get(0), false));
            FlowPanel colPanel2 = new FlowPanel();
            colPanel2.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel2);
            FlowPanel divPanel2 = new FlowPanel();
            divPanel2.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel2.add((Widget)divPanel2);
            divPanel2.add((Widget)this.createGridItemForRepo((Repository)datasourcesCollection.getDatasourcesOfUser().get(1), false));
        } else {
            FlowPanel colPanel1 = new FlowPanel();
            colPanel1.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel1);
            FlowPanel divPanel1 = new FlowPanel();
            divPanel1.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel1.add((Widget)divPanel1);
            FlowPanel colPanel2 = new FlowPanel();
            colPanel2.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel2);
            FlowPanel divPanel2 = new FlowPanel();
            divPanel2.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel2.add((Widget)divPanel2);
            FlowPanel colPanel3 = new FlowPanel();
            colPanel3.addStyleName("uk-width-expand@m uk-first-column");
            reposGrid.add((Widget)colPanel3);
            FlowPanel divPanel3 = new FlowPanel();
            divPanel3.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
            colPanel3.add((Widget)divPanel3);
            for (int i = 0; i < datasourcesCollection.getDatasourcesOfUser().size(); ++i) {
                boolean addExtraClass = false;
                if (i > 2) {
                    addExtraClass = true;
                }
                if (i % 3 == 0) {
                    divPanel1.add((Widget)this.createGridItemForRepo((Repository)datasourcesCollection.getDatasourcesOfUser().get(i), addExtraClass));
                    continue;
                }
                if (i % 3 == 1) {
                    divPanel2.add((Widget)this.createGridItemForRepo((Repository)datasourcesCollection.getDatasourcesOfUser().get(i), addExtraClass));
                    continue;
                }
                divPanel3.add((Widget)this.createGridItemForRepo((Repository)datasourcesCollection.getDatasourcesOfUser().get(i), addExtraClass));
            }
        }
    }

    private FlowPanel createGridItemForRepo(Repository repository, boolean addExtraClass) {
        FlowPanel gridItem = new FlowPanel();
        if (addExtraClass) {
            gridItem.addStyleName("uk-grid-margin uk-first-column");
        } else {
            gridItem.addStyleName("uk-first-column");
        }
        String gridItemContent = "<a href=\"#" + this.parentToken + "/" + repository.getId() + "\" class=\"el-link\">";
        gridItemContent = gridItemContent + "<div uk-scrollspy-class=\"\" class=\"el-item uk-panel uk-scrollspy-inview uk-animation-slide-top-medium\" style=\"\"><div class=\"uk-child-width-expand uk-grid-medium uk-flex-middle uk-grid\" uk-grid=\"\">";
        gridItemContent = gridItemContent + "<div class=\"uk-width-1-3@m uk-first-column\">";
        gridItemContent = repository.getLogoUrl() == null || repository.getLogoUrl().trim().isEmpty() ? gridItemContent + "<img src=\"img/yourLogoHere.jpg\" class=\"el-image uk-border-rounded\" alt=\"\">" : gridItemContent + "<img src=\"" + repository.getLogoUrl() + "\" class=\"el-image uk-border-rounded\" alt=\"\">";
        gridItemContent = gridItemContent + "</div>";
        gridItemContent = gridItemContent + "<div><h3 class=\"el-title uk-margin uk-h5 uk-margin-remove-adjacent uk-margin-small-bottom\">" + repository.getOfficialName() + "</h3>";
        if (this.showPiwikInfo) {
            gridItemContent = repository.getPiwikInfo() == null ? gridItemContent + "<div class=\"uk-badge uk-badge-danger\">not enabled</div>" : (!repository.getPiwikInfo().isValidated() ? gridItemContent + "<div class=\"uk-badge uk-badge-warning\">enabling in progress</div>" : gridItemContent + "<div class=\"uk-badge uk-badge-success\">enabled</div>");
        }
        gridItemContent = gridItemContent + "</div>";
        gridItemContent = gridItemContent + "</div></div></a>";
        gridItem.add((Widget)new HTML(gridItemContent));
        return gridItem;
    }
}

