/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.server.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.domain.data.PiwikInfo;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.domain.enabling.Vocabulary;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.gwt.server.service.SpringGwtRemoteServiceServlet;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.server.services.PiwikDAO;
import eu.dnetlib.repo.manager.server.utils.EmailUtils;
import eu.dnetlib.repo.manager.server.utils.LocalVocabularies;
import eu.dnetlib.repo.manager.service.controllers.RepositoryApi;
import eu.dnetlib.repo.manager.shared.Aggregations;
import eu.dnetlib.repo.manager.shared.BrokerException;
import eu.dnetlib.repo.manager.shared.DatasourceVocabularies;
import eu.dnetlib.repo.manager.shared.DatasourcesCollection;
import eu.dnetlib.repo.manager.shared.MetricsInfo;
import eu.dnetlib.repo.manager.shared.MetricsNumbers;
import eu.dnetlib.repo.manager.shared.RepositoryServiceException;
import eu.dnetlib.repo.manager.shared.Timezone;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repos.RepoApi;
import gr.uoa.di.driver.enabling.vocabulary.VocabularyLoader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service(value="repositoryService")
public class RepositoryServiceImpl
extends SpringGwtRemoteServiceServlet
implements RepositoryService {
    private static final Logger LOGGER = Logger.getLogger(RepositoryServiceImpl.class);
    @Autowired
    private RepoApi repoAPI;
    @Autowired
    private EmailUtils emailUtils;
    private final String[] vocabularyNames = new String[]{"dnet:countries", "dnet:datasource_typologies", "dnet:compatibilityLevel"};
    @Autowired
    private VocabularyLoader vocabularyLoader;
    private Map<String, Vocabulary> vocabularyMap = new ConcurrentHashMap();
    @Value(value="${services.repo-manager.repository.testing.mode}")
    private boolean testingMode;
    @Autowired
    private PiwikDAO piwikDAO;
    @Value(value="${services.repomanager.analyticsURL}")
    private String analyticsURL;
    @Value(value="${services.repomanager.usageStatisticsDiagramsBaseURL}")
    private String usageStatisticsDiagramsBaseURL;
    @Value(value="${services.repomanager.usageStatisticsNumbersBaseURL}")
    private String usageStatisticsNumbersBaseURL;
    private static final String PIWIK_SCRIPT = StringEscapeUtils.escapeHtml((String)"<!-- Piwik -->\n<script type=\"text/javascript\">\n\tvar _paq = _paq || [];\n\t_paq.push(['enableLinkTracking']);\n\t(function() {\n\t\tvar u=\"//analytics.openaire.eu/\";\n\t\t_paq.push(['setTrackerUrl', u+'piwik.php']);\n\t\t_paq.push(['setSiteId', $$$]);\n\t\t<% if(handle != null){%>\n\t\t\t_paq.push(['setCustomVariable', 1, 'oaipmhID',\"oai:<%= baseUrl %>:<%=handle %>\", 'page']);\n\t\t\t_paq.push(['trackPageView']);\n\t\t<}>\n\t\tvar d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];\n\t\tg.type='text/javascript'; g.async=true; g.defer=true; g.src=u+'piwik.js'; s.parentNode.insertBefore(g,s);\n\t})();\n</script>\n<noscript>\n\t<p>\n\t\t<img src=\"//analytics.openaire.eu/piwik.php?idsite=47\" style=\"border:0;\" alt=\"\" />\n\t</p>\n</noscript>\n<!\u2014 End Piwik Code \u2014>");
    @Autowired
    private RepositoryApi repositoryApi;

    @PostConstruct
    public void init() {
        this.loadVocabularies();
    }

    public Tuple<List<Repository>, List<Repository>> getRepositoriesByCountry(String country, String mode, boolean includeUnknownCountries) throws RepositoryServiceException {
        try {
            if (this.testingMode) {
                return this.getRepositoriesByCountryTesting(country, mode, includeUnknownCountries);
            }
            LOGGER.debug((Object)("Getting repositories of country: " + country + " with type: " + mode + " and includeUnknownCountries: " + includeUnknownCountries));
            Tuple retTuple = new Tuple();
            Boolean managed = null;
            List reposList = this.repositoryApi.getRepositoriesByCountry(country, mode, managed);
            if (reposList == null) {
                retTuple.setFirst(new ArrayList());
            } else {
                retTuple.setFirst((Object)reposList);
            }
            if (includeUnknownCountries) {
                List withoutCountryList = (List)this.repoAPI.getRepositoriesPerCountry(mode).get("Without Country");
                List unknownCountryList = (List)this.repoAPI.getRepositoriesPerCountry(mode).get("UNKNOWN");
                ArrayList totalList = new ArrayList();
                if (withoutCountryList != null) {
                    totalList.addAll(withoutCountryList);
                }
                if (unknownCountryList != null) {
                    totalList.addAll(unknownCountryList);
                }
                retTuple.setSecond(totalList);
            }
            return retTuple;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while getting repositories of country: " + country + " with type: " + mode + " and includeUnknownCountries: " + includeUnknownCountries), (Throwable)e);
            if (e instanceof RepositoryServiceException) {
                throw (RepositoryServiceException)e;
            }
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public List<Repository> getRepositoriesByCountry(String country, String mode) throws RepositoryServiceException {
        return (List)this.getRepositoriesByCountry(country, mode, false).getFirst();
    }

    public DatasourcesCollection getRepositoriesOfUser(String userEmail, boolean includeShared, boolean includeByOthers) throws RepositoryServiceException {
        DatasourcesCollection retDatasources = new DatasourcesCollection();
        try {
            LOGGER.debug((Object)("Getting repositories of user: " + userEmail + " . IncludeShared: " + includeShared + " . IncludeByOthers: " + includeByOthers));
            int page = 0;
            String size = "50";
            List resultSet = this.repositoryApi.getRepositoriesOfUser(userEmail, String.valueOf(page), size);
            while (resultSet.size() > 0) {
                retDatasources.getDatasourcesOfUser().addAll(resultSet);
                resultSet = this.repositoryApi.getRepositoriesOfUser(userEmail, String.valueOf(++page), size);
            }
        }
        catch (JSONException e) {
            LOGGER.error((Object)("Error while getting repositories of user: " + userEmail + " . IncludeShared: " + includeShared + " . IncludeByOthers: " + includeByOthers), (Throwable)e);
            this.emailUtils.reportException((Exception)((Object)e));
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
        return retDatasources;
    }

    public List<String> getRepositoryUrlsOfUser(String userEmail, boolean includeShared, boolean includeByOthers) throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)("Getting repositories(urls) of user: " + userEmail + " . IncludeShared: " + includeShared + " . IncludeByOthers: " + includeByOthers));
            ArrayList<String> retRepos = new ArrayList<String>();
            int page = 0;
            String size = "50";
            List resultSet = this.repositoryApi.getUrlsOfUserRepos(userEmail, String.valueOf(page), size);
            while (resultSet.size() > 0) {
                retRepos.addAll(resultSet);
                resultSet = this.repositoryApi.getUrlsOfUserRepos(userEmail, String.valueOf(++page), size);
            }
            return retRepos;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while getting repositories(urls) of user: " + userEmail + " . IncludeShared: " + includeShared + " . IncludeByOthers: " + includeByOthers), (Throwable)e);
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public Repository getRepository(String repoId) throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)("Getting repository with id: " + repoId));
            Repository repo = this.repositoryApi.getRepositoryById(repoId);
            if (repo != null) {
                for (RepositoryInterface iFace : repo.getInterfaces()) {
                    if (iFace.getContentDescription().equals("file::hybrid") || !iFace.getAccessProtocol().equalsIgnoreCase("oai")) continue;
                    iFace.setComplianceName(this.getComplianceName(iFace.getCompliance()));
                    if (!iFace.getCompliance().equals("notCompatible")) continue;
                    iFace.setComplianceName("not compatible");
                }
            } else {
                throw new RepositoryServiceException("registration.repositoryNotExists", RepositoryServiceException.ErrorCode.REPOSITORY_NOT_EXISTS);
            }
            repo.setPiwikInfo(this.getPiwikSiteForRepository(repoId));
            return repo;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while getting repository with id: " + repoId), (Throwable)e);
            if (e instanceof RepositoryServiceException) {
                throw (RepositoryServiceException)e;
            }
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public Map<String, String> getCountries(Boolean existingOnly, String mode) throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)"Getting countries");
            ArrayList countries = new ArrayList();
            TreeMap<String, String> countriesMap = new TreeMap<String, String>();
            if (existingOnly.booleanValue()) {
                LOGGER.debug((Object)"using the repositories map");
                countries.addAll(this.repoAPI.getRepositoriesByCountry(mode).keySet());
            } else {
                LOGGER.debug((Object)"using \"dnet:countries\" vocabulary");
                countries.addAll(this.getVocabulary("dnet:countries").getEnglishNames());
            }
            for (String country : countries) {
                countriesMap.put(country, WordUtils.capitalizeFully((String)country));
            }
            return countriesMap;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while getting getting countries", (Throwable)e);
            if (e instanceof RepositoryServiceException) {
                throw (RepositoryServiceException)e;
            }
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public Map<String, String> getCountries() throws RepositoryServiceException {
        return this.getCountries(Boolean.valueOf(false), null);
    }

    public List<Timezone> getTimezones() throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)"Getting timezones from file");
            return LocalVocabularies.timezones;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while getting timezones from file", (Throwable)e);
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public List<String> getTypologies() throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)"Getting typologies from file");
            return LocalVocabularies.typologies;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while getting typologies from file", (Throwable)e);
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public Map<String, String> getDatasourceClasses(String mode) throws RepositoryServiceException {
        return this.repositoryApi.getDatasourceClasses(mode);
    }

    public Map<String, String> getCompatibilityClasses(String mode) throws RepositoryServiceException {
        return this.repositoryApi.getCompatibilityClasses(mode);
    }

    public void storeRepository(Repository repo, String mode) throws RepositoryServiceException {
        try {
            this.repositoryApi.addRepository(mode, repo);
            LOGGER.debug((Object)("Repository with name: " + repo.getOfficialName() + " stored!"));
        }
        catch (Exception e) {
            this.emailUtils.reportException(e);
            LOGGER.error((Object)("Error while storing repository with name: " + repo.getOfficialName()), (Throwable)e);
            throw new RepositoryServiceException("Error while storing repository", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public void updateRepositoryInformation(Repository repo) throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)("Updating information of repo: " + repo.getOfficialName()));
            this.repositoryApi.updateEnglishName(repo.getId(), repo.getEnglishName());
            this.repositoryApi.updateLatitude(repo.getId(), String.valueOf(repo.getLatitude()));
            this.repositoryApi.updateLongitude(repo.getId(), String.valueOf(repo.getLongitude()));
            this.repositoryApi.updateOfficialName(repo.getId(), repo.getOfficialName());
            this.repositoryApi.updateLogoUrl(repo.getId(), repo.getLogoUrl());
            this.repositoryApi.updateTimezone(repo.getId(), String.valueOf(repo.getTimezone()));
            this.repositoryApi.updatePlatform(repo.getId(), repo.getTypology());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while updating information of repo: " + repo.getOfficialName()), (Throwable)e);
            if (e instanceof RepositoryServiceException) {
                throw (RepositoryServiceException)e;
            }
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public RepositoryInterface updateInterface(RepositoryInterface iFace, String repoId, String datatype) throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)("updating interface with id: " + iFace.getId()));
            RepositoryInterface retIface = null;
            retIface = this.repoAPI.updateRepositoryInterfaceWithoutChecks(repoId, iFace, datatype);
            retIface.setComplianceName(this.getComplianceName(retIface.getCompliance()));
            return retIface;
        }
        catch (Exception e) {
            LOGGER.error((Object)("error updating interface with id: " + iFace.getId()), (Throwable)e);
            if (e instanceof RepositoryServiceException) {
                throw (RepositoryServiceException)e;
            }
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public RepositoryInterface insertInterface(RepositoryInterface iFace, String repoId, String datatype) throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)("inserting interface with id: " + iFace.getId()));
            RepositoryInterface retIface = null;
            retIface = this.repositoryApi.addRepositoryInterface(datatype, repoId, iFace);
            retIface.setComplianceName(this.getComplianceName(retIface.getCompliance()));
            return retIface;
        }
        catch (Exception e) {
            LOGGER.error((Object)("error updating interface with id: " + iFace.getId()), (Throwable)e);
            if (e instanceof RepositoryServiceException) {
                throw (RepositoryServiceException)e;
            }
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public void deleteInterface(String repoId, RepositoryInterface iFace, String datatype) throws RepositoryServiceException {
        ArrayList<RepositoryInterface> iFaces = new ArrayList<RepositoryInterface>();
        iFaces.add(iFace);
        this.deleteInterfaces(repoId, iFaces, datatype);
    }

    public void deleteInterfaces(String repoId, List<RepositoryInterface> iFaces, String datatype) throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)("deleting interfaces of repo: " + repoId));
            for (RepositoryInterface iFace : iFaces) {
                LOGGER.info((Object)("deleting repository interface with url/set/id: " + iFace.getBaseUrl() + "/" + iFace.getAccessSet() + "/" + iFace.getId()));
                this.repositoryApi.deleteRepositoryInterface(iFace.getId());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("deleting interfaces of repo: " + repoId), (Throwable)e);
            if (e instanceof RepositoryServiceException) {
                throw (RepositoryServiceException)e;
            }
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public DatasourceVocabularies getDatasourceVocabularies(String mode) throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)("Getting vocabularies for datasource with type: " + mode));
            DatasourceVocabularies vocs = new DatasourceVocabularies();
            vocs.setCountries(this.getCountries());
            vocs.setDatasourceClasses(this.getDatasourceClasses(mode));
            vocs.setTimezones(this.getTimezones());
            vocs.setTypologies(this.getTypologies());
            vocs.setCompatibilityLevels(this.getCompatibilityClasses(mode));
            return vocs;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while getting vocabularies for datasource with type: \" + mode", (Throwable)e);
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    private Tuple<List<Repository>, List<Repository>> getRepositoriesByCountryTesting(String country, String mode, boolean includeUnknownCountries) throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)("Getting testing repositories of country: " + country + " with type: " + mode + " and includeUnknownCountries: " + includeUnknownCountries));
            Tuple retTuple = new Tuple();
            ArrayList<Repository> reposList = new ArrayList<Repository>();
            reposList.add(this.repoAPI.getRepository("opendoar____::1356"));
            reposList.add(this.repoAPI.getRepository("opendoar____::2678"));
            reposList.add(this.repoAPI.getRepository("opendoar____::2980"));
            reposList.add(this.repoAPI.getRepository("opendoar____::1347"));
            reposList.add(this.repoAPI.getRepository("opendoar____::2984"));
            retTuple.setFirst(reposList);
            if (includeUnknownCountries) {
                ArrayList<Repository> totalList = new ArrayList<Repository>();
                totalList.add(this.repoAPI.getRepository("opendoar____::3000"));
                totalList.add(this.repoAPI.getRepository("opendoar____::1027"));
                totalList.add(this.repoAPI.getRepository("opendoar____::1096"));
                retTuple.setSecond(totalList);
            }
            return retTuple;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while getting testing repositories of country: " + country + " with type: " + mode + " and includeUnknownCountries: " + includeUnknownCountries), (Throwable)e);
            if (e instanceof RepositoryServiceException) {
                throw (RepositoryServiceException)e;
            }
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public String getLatestUpdateDateOfList(String mode) throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)("Getting latest update date of list: " + mode));
            return this.repoAPI.getListLatestUpdate(mode).split("T")[0];
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while getting latest update date of list: " + mode), (Throwable)e);
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public PiwikInfo getPiwikSiteForRepository(String repoId) throws RepositoryServiceException {
        try {
            LOGGER.debug((Object)("Repo id -> " + repoId));
            return this.piwikDAO.getPiwikSiteForRepo(repoId);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public void enableMetricsForRepository(Repository repository, UserProfile requestor) throws RepositoryServiceException {
        try {
            String URL2 = this.analyticsURL + "siteName=" + URLEncoder.encode(repository.getOfficialName(), "UTF-8") + "&url=" + URLEncoder.encode(repository.getWebsiteUrl(), "UTF-8");
            Map map = (Map)new ObjectMapper().readValue(new URL(URL2), Map.class);
            String siteId = null;
            if (map.get("value") != null) {
                siteId = map.get("value").toString();
            }
            String authenticationToken = "32846584f571be9b57488bf4088f30ea";
            PiwikInfo piwikInfo = new PiwikInfo();
            piwikInfo.setRepositoryId(repository.getId());
            piwikInfo.setRepositoryName(repository.getOfficialName());
            piwikInfo.setCountry(repository.getCountryName());
            piwikInfo.setSiteId(siteId);
            piwikInfo.setAuthenticationToken(authenticationToken);
            piwikInfo.setRequestorEmail(requestor.getEmail());
            piwikInfo.setRequestorName(requestor.getFirstname() + " " + requestor.getLastname());
            piwikInfo.setValidated(false);
            this.piwikDAO.savePiwikInfo(piwikInfo);
            this.emailUtils.sendAdministratorRequestToEnableMetrics(piwikInfo);
            this.emailUtils.sendUserRequestToEnableMetrics(piwikInfo);
        }
        catch (UnsupportedEncodingException uee) {
            LOGGER.error((Object)"Error while creating piwikScript URL", (Throwable)uee);
            this.emailUtils.reportException((Exception)uee);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"Error while creating piwik site", (Throwable)ioe);
            this.emailUtils.reportException((Exception)ioe);
            throw new RepositoryServiceException("login.generalError", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while sending email to administrator or user about the request to enable metrics", (Throwable)e);
            this.emailUtils.reportException(e);
        }
    }

    public String getPiwikScriptForRepository(String repoId) throws RepositoryServiceException {
        try {
            PiwikInfo piwikInfo = this.piwikDAO.getPiwikSiteForRepo(repoId);
            String piwikScript = PIWIK_SCRIPT.replace("$$$", piwikInfo.getSiteId());
            return piwikScript;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public List<PiwikInfo> getPiwikSitesForRepositories() throws RepositoryServiceException {
        try {
            ArrayList<PiwikInfo> piwikInfos = new ArrayList();
            piwikInfos = this.piwikDAO.getPiwikSitesForRepos();
            return piwikInfos;
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.error((Object)"Error while getting list of piwik sites: ", (Throwable)e);
            this.emailUtils.reportException((Exception)((Object)e));
            throw new RepositoryServiceException("General error", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    public void markPiwikSiteAsValidated(String repositoryId) throws RepositoryServiceException {
        try {
            this.piwikDAO.markPiwikSiteAsValidated(repositoryId);
            PiwikInfo piwikInfo = this.piwikDAO.getPiwikSiteForRepo(repositoryId);
            this.emailUtils.sendAdministratorMetricsEnabled(piwikInfo);
            this.emailUtils.sendUserMetricsEnabled(piwikInfo);
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.error((Object)"Error while approving piwik site: ", (Throwable)e);
            this.emailUtils.reportException((Exception)((Object)e));
            throw new RepositoryServiceException("General error", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while sending email to administrator or user about the enabling of metrics", (Throwable)e);
            this.emailUtils.reportException(e);
        }
    }

    public MetricsInfo getMetricsInfoForRepository(String repoId) throws RepositoryServiceException {
        try {
            MetricsInfo metricsInfo = new MetricsInfo();
            metricsInfo.setDiagramsBaseURL(this.usageStatisticsDiagramsBaseURL);
            metricsInfo.setMetricsNumbers(this.getMetricsNumbers(this.getOpenAIREId(repoId)));
            return metricsInfo;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while getting metrics info for repository: ", (Throwable)e);
            this.emailUtils.reportException(e);
            throw new RepositoryServiceException("General error", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    private MetricsNumbers getMetricsNumbers(String openAIREID) throws BrokerException {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.usageStatisticsNumbersBaseURL + openAIREID + "/clicks"));
        RestTemplate template = new RestTemplate();
        template.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        ResponseEntity resp = template.exchange(builder.build().encode().toUri(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return (MetricsNumbers)resp.getBody();
    }

    private String getCountryCode(String countryName) {
        Vocabulary countries = this.getVocabulary("dnet:countries");
        return countries.getEncoding(countryName);
    }

    private String getDatasourceClassCode(String datasourceClassName) {
        Vocabulary datasourceClasses = this.getVocabulary("dnet:datasource_typologies");
        return datasourceClasses.getEncoding(datasourceClassName);
    }

    private String getComplianceName(String complianceCode) {
        Vocabulary compatibilityLevels = this.getVocabulary("dnet:compatibilityLevel");
        return compatibilityLevels.getEnglishName(complianceCode);
    }

    private Vocabulary getVocabulary(String vocName) {
        if (!this.vocabularyMap.containsKey(vocName)) {
            this.vocabularyMap.put(vocName, this.vocabularyLoader.getVocabulary(vocName, Locale.ENGLISH, Locale.ROOT));
        }
        return (Vocabulary)this.vocabularyMap.get(vocName);
    }

    @Scheduled(fixedRate=3600000L)
    private void loadVocabularies() {
        LOGGER.debug((Object)"loading vocabularies");
        for (String vocName : this.vocabularyNames) {
            this.vocabularyMap.put(vocName, this.vocabularyLoader.getVocabulary(vocName, Locale.ENGLISH, Locale.ROOT));
        }
    }

    private String getOpenAIREId(String repoId) {
        if (repoId != null && repoId.contains("::")) {
            return repoId.split("::")[0] + "::" + DigestUtils.md5Hex((String)repoId.split("::")[1]);
        }
        return null;
    }

    public Aggregations getRepositoryAggregations(String repoId) throws Exception {
        return this.repositoryApi.getRepositoryAggregations(repoId);
    }
}

