/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.server.services;

import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.gwt.server.service.SpringGwtRemoteServiceServlet;
import eu.dnetlib.repo.manager.client.services.UserService;
import eu.dnetlib.repo.manager.server.utils.EmailUtils;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.UserAccessException;
import eu.dnetlib.users.UserApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userService")
public class UserServiceImpl
extends SpringGwtRemoteServiceServlet
implements UserService {
    private static final Logger LOGGER = Logger.getLogger(UserServiceImpl.class);
    @Autowired
    private UserApi userAPI;
    @Autowired
    private EmailUtils emailUtils;

    public void init(ServletConfig config) throws ServletException {
        LOGGER.info((Object)"initializing user service impl ");
        super.init(config);
    }

    public Tuple<UserProfile, String> login(String email_username, String password) throws UserAccessException {
        LOGGER.info((Object)("Checking credentials for user " + email_username));
        try {
            String email = email_username;
            Pattern rfc2822 = Pattern.compile("^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$");
            if (!rfc2822.matcher(email_username.trim().toLowerCase()).matches()) {
                LOGGER.debug((Object)"user logged in using username");
                email = this.userAPI.getEmailFromUsername(email_username);
            }
            if (email == null) {
                throw new UserAccessException("login.userNotExists", UserAccessException.ErrorCode.INVALID_USERNAME);
            }
            if (!this.userAPI.userExists(email)) {
                throw new UserAccessException("login.userNotExists", UserAccessException.ErrorCode.INVALID_USERNAME);
            }
            if (!this.userAPI.isUserActivated(email)) {
                throw new UserAccessException("login.notActivated", UserAccessException.ErrorCode.NOT_ACTIVATED);
            }
            if (!this.userAPI.correctCreds(email, password)) {
                throw new UserAccessException("login.InvalidPassword", UserAccessException.ErrorCode.INVALID_PASSWORD);
            }
            UserProfile userProfile = this.userAPI.getUser(email);
            String role = "";
            String[] adminEmails = new String[]{"stefania.martziou@gmail.com", "antleb@di.uoa.gr", "ant.lebesis@gmail.com", "natalia@di.uoa.gr", "pedroprincipe@sdum.uminho.pt", "dpierrakos@gmail.com", "jochen.schirrwagen@uni-bielefeld.de", "aenne.loehden@uni-bielefeld.de"};
            if (Arrays.asList(adminEmails).contains(userProfile.getEmail())) {
                role = "admin";
            }
            return new Tuple((Object)userProfile, (Object)role);
        }
        catch (Exception e) {
            LOGGER.error((Object)("An error occurred while checking credentials for user " + email_username), (Throwable)e);
            this.emailUtils.reportException(e);
            if (e instanceof UserAccessException) {
                throw (UserAccessException)e;
            }
            throw new UserAccessException("login.generalError", UserAccessException.ErrorCode.GENERAL_ERROR);
        }
    }

    public Tuple<UserProfile, String> getUserByEmail(String email) throws UserAccessException {
        LOGGER.info((Object)("Getting user with email " + email));
        try {
            UserProfile userProfile = this.userAPI.getUser(email);
            String role = "";
            String[] adminEmails = new String[]{"stefania.martziou@gmail.com", "antleb@di.uoa.gr", "ant.lebesis@gmail.com", "natalia@di.uoa.gr", "pedroprincipe@sdum.uminho.pt", "dpierrakos@gmail.com", "jochen.schirrwagen@uni-bielefeld.de", "aenne.loehden@uni-bielefeld.de"};
            if (Arrays.asList(adminEmails).contains(userProfile.getEmail())) {
                role = "admin";
            }
            return new Tuple((Object)userProfile, (Object)role);
        }
        catch (Exception e) {
            LOGGER.error((Object)("An error occurred while getting user with email " + email), (Throwable)e);
            this.emailUtils.reportException(e);
            throw new UserAccessException("login.generalError", UserAccessException.ErrorCode.GENERAL_ERROR);
        }
    }

    public void register(UserProfile userProfile) throws UserAccessException {
        try {
            LOGGER.info((Object)("Registering user " + userProfile.getEmail()));
            Pattern rfc2822 = Pattern.compile("^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$");
            if (!rfc2822.matcher(userProfile.getEmail().trim().toLowerCase()).matches()) {
                throw new UserAccessException("login.notValidEmail", UserAccessException.ErrorCode.INVALID_EMAIL_FORMAT);
            }
            if (this.userAPI.usernameExists(userProfile.getUsername())) {
                throw new UserAccessException("login.usernameAlreadyExists", UserAccessException.ErrorCode.USERNAME_ALREADY_EXISTS);
            }
            if (this.userAPI.userExists(userProfile.getEmail())) {
                throw new UserAccessException("login.mailAlreadyExists", UserAccessException.ErrorCode.MAIL_ALREADY_EXISTS);
            }
            String activationId = this.userAPI.addUser(userProfile.getUsername(), userProfile.getEmail(), userProfile.getPassword(), userProfile.getFirstname(), userProfile.getLastname(), userProfile.getInstitution());
            this.emailUtils.sendActivationEmail(userProfile, activationId);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while registering user " + userProfile.getEmail()), (Throwable)e);
            this.emailUtils.reportException(e);
            if (e instanceof UserAccessException) {
                throw (UserAccessException)e;
            }
            throw new UserAccessException("login.generalError", UserAccessException.ErrorCode.GENERAL_ERROR);
        }
    }

    public void activateUser(String activationId) throws UserAccessException {
        try {
            LOGGER.info((Object)("Activating user with activation with activation id " + activationId));
            if (!this.userAPI.activateUser(activationId)) {
                throw new UserAccessException("registration.okAccountAlreadyActivation", UserAccessException.ErrorCode.ALREADY_ACTIVATED);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while activating user account with activation id " + activationId), (Throwable)e);
            this.emailUtils.reportException(e);
            if (e instanceof UserAccessException) {
                throw (UserAccessException)e;
            }
            throw new UserAccessException("login.generalError", UserAccessException.ErrorCode.GENERAL_ERROR);
        }
    }

    public void updateUser(UserProfile userProfile) throws UserAccessException {
        try {
            LOGGER.info((Object)("Editing user " + userProfile.getUsername()));
            Pattern rfc2822 = Pattern.compile("^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$");
            if (!rfc2822.matcher(userProfile.getEmail().trim().toLowerCase()).matches()) {
                throw new UserAccessException("login.notValidEmail", UserAccessException.ErrorCode.INVALID_EMAIL_FORMAT);
            }
            String currentEmail = this.userAPI.getEmailFromUsername(userProfile.getUsername());
            if (!userProfile.getEmail().equalsIgnoreCase(currentEmail) && this.userAPI.userExists(userProfile.getEmail())) {
                throw new UserAccessException("login.mailAlreadyExists", UserAccessException.ErrorCode.MAIL_ALREADY_EXISTS);
            }
            this.userAPI.editUser(userProfile);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while editing user " + userProfile.getUsername()), (Throwable)e);
            if (e instanceof UserAccessException) {
                throw (UserAccessException)e;
            }
            throw new UserAccessException("login.generalError", UserAccessException.ErrorCode.GENERAL_ERROR);
        }
    }

    public void prepareResetPassword(String email) throws UserAccessException {
        try {
            LOGGER.debug((Object)("Sending password recovery to user " + email));
            if (!this.userAPI.userExists(email)) {
                throw new UserAccessException("login.userNotExists", UserAccessException.ErrorCode.INVALID_USERNAME);
            }
            ArrayList<String> to = new ArrayList<String>();
            to.add(email);
            String securityCode = this.userAPI.prepareResetPassword(email);
            this.emailUtils.sendResetPasswordEmail(email, securityCode);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while sending password recovery to user " + email), (Throwable)e);
            this.emailUtils.reportException(e);
            if (e instanceof UserAccessException) {
                throw (UserAccessException)e;
            }
            throw new UserAccessException("login.generalError", UserAccessException.ErrorCode.GENERAL_ERROR);
        }
    }

    public void resetPassword(String securityCode, String password) throws UserAccessException {
        try {
            LOGGER.debug((Object)("Reseting password with security code " + securityCode));
            if (securityCode.length() == 0) {
                throw new UserAccessException("resetPassword.wrongSecurityCode", UserAccessException.ErrorCode.WRONG_SECURITY_CODE);
            }
            this.userAPI.resetPassword(securityCode, password);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while reseting password with security code " + securityCode));
            this.emailUtils.reportException(e);
            if (e instanceof UserAccessException) {
                throw (UserAccessException)e;
            }
            throw new UserAccessException("login.generalError", UserAccessException.ErrorCode.GENERAL_ERROR);
        }
    }

    public void resendActivation(String email) throws UserAccessException {
    }
}

