/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.server.utils;

import eu.dnetlib.repo.manager.server.utils.OaiTools;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.dom4j.io.DOMWriter;
import org.w3c.dom.Document;
import se.kb.oai.pmh.Identification;
import se.kb.oai.pmh.OaiPmhServer;
import se.kb.oai.pmh.ResumptionToken;
import se.kb.oai.pmh.Set;
import se.kb.oai.pmh.SetsList;

/*
 * Exception performing whole class analysis ignored.
 */
public class OaiTools {
    private static Logger LOGGER = Logger.getLogger(OaiTools.class);

    public OaiTools() {
        OaiTools.disableSslVerification();
    }

    public static List<String> getSetsOfRepo(String baseUrl) throws Exception {
        try {
            LOGGER.debug((Object)("Getting sets of repository " + baseUrl));
            OaiPmhServer harvester = new OaiPmhServer(baseUrl);
            SetsList setList = harvester.listSets();
            ResumptionToken token = setList.getResumptionToken();
            ArrayList sets = new ArrayList();
            sets.addAll(setList.asList());
            while (token != null) {
                setList = harvester.listSets(token);
                token = setList.getResumptionToken();
                sets.addAll(setList.asList());
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (Set set : sets) {
                ret.add(set.getSpec().trim());
            }
            if (ret.size() > 0) {
                Collections.sort(ret);
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error getting sets of repository " + baseUrl), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public static boolean identifyRepository(String baseUrl) throws Exception {
        LOGGER.debug((Object)("sending identify request to repo " + baseUrl));
        OaiPmhServer harvester = new OaiPmhServer(baseUrl);
        if (baseUrl.trim().isEmpty()) {
            return false;
        }
        try {
            Identification identification = harvester.identify();
            DOMWriter d4Writer = new DOMWriter();
            Document d = d4Writer.write(identification.getResponse());
            return OaiTools.verifyIdentify((Document)d);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Error verifying identify response", (Throwable)e);
            throw e;
        }
    }

    private static boolean verifyIdentify(Document doc) throws XPathExpressionException {
        1 ctx = new /* Unavailable Anonymous Inner Class!! */;
        String xpathStr = "//oai:OAI-PMH/oai:Identify";
        XPathFactory xpathFact = XPathFactory.newInstance();
        XPath xpath = xpathFact.newXPath();
        xpath.setNamespaceContext((NamespaceContext)ctx);
        String result = xpath.evaluate(xpathStr, doc);
        return result != null && !result.equals("");
    }

    private static void disableSslVerification() {
        try {
            LOGGER.debug((Object)"disabling ssl verification");
            TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            3 allHostsValid = new /* Unavailable Anonymous Inner Class!! */;
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"disabling ssl verification", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOGGER.error((Object)"error while disabling ssl verification", (Throwable)e);
        }
    }
}

