package eu.dnetlib.repo.manager.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import eu.dnetlib.gwt.shared.Help;

/**
 * Created by stefania on 3/9/16.
 */
public class HelpCallback implements AsyncCallback<Help> {

    private FlowPanel helpPanel;
    private FlowPanel parentPanel;

    public HelpCallback(FlowPanel helpPanel, FlowPanel parentPanel) {
        this.helpPanel = helpPanel;
        this.parentPanel = parentPanel;
    }

    @Override
    public void onFailure(Throwable caught) {
        parentPanel.remove(helpPanel);
    }

    @Override
    public void onSuccess(Help help) {

        if (help != null && help.getText()!=null && !help.getText().trim().isEmpty()) {
            String content = "<div class=\"uk-card uk-card-body uk-card-default sidemenu\">" + help.getText() + "</div>";
            HTML html = new HTML();
            html.setHTML(content);

            helpPanel.clear();
            helpPanel.add(html);
            parentPanel.add(helpPanel);

        } else {
            parentPanel.remove(helpPanel);
        }
    }

    public FlowPanel getHelpPanel() {
        return helpPanel;
    }

    public void setHelpPanel(FlowPanel helpPanel) {
        this.helpPanel = helpPanel;
    }

    public FlowPanel getParentPanel() {
        return parentPanel;
    }

    public void setParentPanel(FlowPanel parentPanel) {
        this.parentPanel = parentPanel;
    }
}
