package eu.dnetlib.repo.manager.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.client.services.UserService;
import eu.dnetlib.repo.manager.client.services.UserServiceAsync;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.UserAccessException;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.SubmitButton;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.html.Paragraph;

import java.util.Date;

/**
 * Created by stefania on 12/2/15.
 */
public class LoginPage {

    private static LoginPage instance = null;

    private Form userLoginForm = new Form();

    private Alert successLabel = new Alert();
    private Alert errorLabel = new Alert();
    private TextBox email;
    private PasswordTextBox password;

    private SubmitButton login = new SubmitButton();

    private Anchor forgotYourPassword = new Anchor();
    private Paragraph paragraph = new Paragraph();
    private Anchor register = new Anchor();

    private UserServiceAsync userService = GWT.create(UserService.class);
    private LoginListener loginListener;

    private LoginPage() {

        successLabel.setType(AlertType.SUCCESS);
        successLabel.setVisible(false);
        successLabel.setDismissable(false);
        userLoginForm.add(successLabel);

        errorLabel.setType(AlertType.DANGER);
        errorLabel.setVisible(false);
        errorLabel.setDismissable(false);
        userLoginForm.add(errorLabel);

        userLoginForm.addStyleName("m-t");

        email = TextBox.wrap(DOM.getElementById("creds_username"));
        email.getElement().setPropertyString("placeholder", "Username / Email");
        email.addStyleName("form-control");
        userLoginForm.add(new MyFormGroup(false, null, email));

        password = PasswordTextBox.wrap(DOM.getElementById("creds_password"));
        password.getElement().setPropertyString("placeholder", "Password");
        password.addStyleName("form-control");
        userLoginForm.add(new MyFormGroup(false, null, password));

        login.setType(ButtonType.PRIMARY);
        login.setText("Login");
        login.addStyleName("block full-width m-b");
        login.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                successLabel.setVisible(false);
                errorLabel.setVisible(false);

                if(email.getValue().trim().isEmpty() || password.getValue().trim().isEmpty()) {

                    errorLabel.setText("Both username / email and password fields are required");
                    errorLabel.setVisible(true);

                } else {

                    userService.login(email.getValue(), password.getValue(), new AsyncCallback<Tuple<UserProfile, String>>() {

                        @Override
                        public void onFailure(Throwable throwable) {

                            if (throwable instanceof UserAccessException) {

                                UserAccessException uae = (UserAccessException) throwable;
                                errorLabel.setText(uae.getMessage());
                                errorLabel.setVisible(true);

                            } else {

                                errorLabel.setText("Login failed - Something went wrong, please try again.");
                                errorLabel.setVisible(true);
                            }
                        }

                        @Override
                        public void onSuccess(Tuple<UserProfile, String> result) {

                            RepositoryManager.currentUser = result.getFirst();
                            RepositoryManager.currentUserRole = result.getSecond();

                            Date expireDate = new Date();
                            CalendarUtil.addDaysToDate(expireDate, 1);
                            Cookies.setCookie("currentUser", Crypto.encrypt(result.getFirst().getEmail()), expireDate);

                            if (loginListener != null)
                                loginListener.loginSucceeded(result.getFirst());
                        }
                    });
                }
            }
        });

        userLoginForm.add(login);

        forgotYourPassword.setHTML("<small>Forgot password?</small>");
        userLoginForm.add(forgotYourPassword);

        paragraph.setHTML("<small>Do not have an account?</small>");
        paragraph.addStyleName("text-muted text-center");
        userLoginForm.add(paragraph);

        register.setHref("#register");
        register.setText("Create an account");
        register.addStyleName("btn btn-sm btn-white btn-block");
        userLoginForm.add(register);

        RootPanel.get("loginForm").add(userLoginForm);
    }

    public static final LoginPage getInstance() {

        if(instance==null)
            instance = new LoginPage();

        return instance;
    }

    public void showLoginPage() {

        Document.get().getElementById("landingPage").getStyle().setDisplay(Style.Display.NONE);
        Document.get().getElementById("register").getStyle().setDisplay(Style.Display.NONE);
        Document.get().getElementById("wrapper").getStyle().setDisplay(Style.Display.NONE);
        Document.get().getElementById("login").getStyle().setDisplay(Style.Display.BLOCK);

//        Document.get().getBody().removeClassName("landing-page");
//        Document.get().getBody().addClassName("gray-bg");
    }

    public interface LoginListener {
        void loginSucceeded(UserProfile userProfile);
    }

    public void setLoginListener(LoginListener loginListener) {
        this.loginListener = loginListener;
    }

    public void showSuccessfulMessage(String message) {

        Window.alert("showing successful activation message");

        successLabel.setText(message);
        successLabel.setVisible(true);
    }
}
