package eu.dnetlib.repo.manager.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RootPanel;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.client.services.UserService;
import eu.dnetlib.repo.manager.client.services.UserServiceAsync;
import eu.dnetlib.repo.manager.client.widgets.TextBox;
import eu.dnetlib.repo.manager.shared.UserAccessException;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.SubmitButton;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.html.Paragraph;

/**
 * Created by stefania on 12/2/15.
 */
public class RegisterPage {

    private static RegisterPage instance = null;

    private Form userRegistrationForm = new Form();

    private Alert successLabel = new Alert();
    private Alert errorLabel = new Alert();

    private TextBox username = new TextBox();
    private TextBox firstName = new TextBox();
    private TextBox lastName = new TextBox();
    private TextBox email = new TextBox();
    private TextBox institution = new TextBox();
    private PasswordTextBox password = new PasswordTextBox();
    private PasswordTextBox confirmPassword = new PasswordTextBox();

    private SubmitButton register = new SubmitButton();

    private Paragraph paragraph = new Paragraph();
    private Anchor login = new Anchor();

    private UserServiceAsync userService = GWT.create(UserService.class);

    private RegisterPage() {

        successLabel.setType(AlertType.SUCCESS);
        successLabel.setVisible(false);
        successLabel.setDismissable(false);
        userRegistrationForm.add(successLabel);

        errorLabel.setType(AlertType.DANGER);
        errorLabel.setVisible(false);
        errorLabel.setDismissable(false);
        userRegistrationForm.add(errorLabel);

        userRegistrationForm.addStyleName("m-t");

        username.setPlaceholder("Username (*)");
        username.addStyleName("form-control");
        userRegistrationForm.add(new MyFormGroup(false, null, username));

        firstName.setPlaceholder("First Name (*)");
        firstName.addStyleName("form-control");
        userRegistrationForm.add(new MyFormGroup(false, null, firstName));

        lastName.setPlaceholder("Last Name (*)");
        lastName.addStyleName("form-control");
        userRegistrationForm.add(new MyFormGroup(false, null, lastName));

        email.setPlaceholder("Email (*)");
        email.addStyleName("form-control");
        userRegistrationForm.add(new MyFormGroup(false, null, email));

        institution.setPlaceholder("Institution");
        institution.addStyleName("form-control");
        userRegistrationForm.add(new MyFormGroup(false, null, institution));

        password.getElement().setPropertyString("placeholder", "Password (*)");
        password.addStyleName("form-control");
        userRegistrationForm.add(new MyFormGroup(false, null, password));

        confirmPassword.getElement().setPropertyString("placeholder", "Re-enter password (*)");
        confirmPassword.addStyleName("form-control");
        userRegistrationForm.add(new MyFormGroup(false, null, confirmPassword));

        register.setType(ButtonType.PRIMARY);
        register.setText("Register");
        register.addStyleName("block full-width m-b");
        register.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {

                errorLabel.setVisible(false);
                successLabel.setVisible(false);

                if(username.getValue().trim().isEmpty() || firstName.getValue().trim().isEmpty()
                        || lastName.getValue().trim().isEmpty() || email.getValue().trim().isEmpty()
                        || password.getValue().trim().isEmpty() || confirmPassword.getValue().trim().isEmpty()) {

                    errorLabel.setText("All asterisk (*) fields are required");
                    errorLabel.setVisible(true);

                } else if(!password.getValue().equals(confirmPassword.getValue())) {

                    errorLabel.setText("Password fields do not match");
                    errorLabel.setVisible(true);

                } else {

                    UserProfile userProfile = new UserProfile();
                    userProfile.setFirstname(firstName.getValue());
                    userProfile.setLastname(lastName.getValue());
                    userProfile.setUsername(username.getValue());
                    userProfile.setEmail(email.getValue());
                    userProfile.setPassword(password.getValue());
                    if(institution.getValue()!=null && !institution.getValue().isEmpty())
                        userProfile.setInstitution(institution.getValue());

                    final HTML loadingWheel = new HTML("<div class=\"loader-small\"></div><div class=\"whiteFilm\"></div>");
                    userRegistrationForm.addStyleName("loading");
                    userRegistrationForm.add(loadingWheel);

                    userService.register(userProfile, new AsyncCallback<Void>() {

                        @Override
                        public void onFailure(Throwable throwable) {

                            userRegistrationForm.removeStyleName("loading");
                            userRegistrationForm.remove(loadingWheel);

                            if(throwable instanceof UserAccessException) {
                                UserAccessException uae = (UserAccessException) throwable;
                                errorLabel.setText(uae.getMessage());
                                errorLabel.setVisible(true);
                            } else {
                                errorLabel.setText("Registration failed - Something went wrong, please try again.");
                                errorLabel.setVisible(true);
                            }
                        }

                        @Override
                        public void onSuccess(Void aVoid) {

                            userRegistrationForm.removeStyleName("loading");
                            userRegistrationForm.remove(loadingWheel);

                            successLabel.setText("An activation e-mail has been sent to the e-mail " +
                                    "address you specified. Please follow the link included in that e-mail to activate your account.");
                            successLabel.setVisible(true);
                        }
                    });
                }
            }
        });
        userRegistrationForm.add(register);

        paragraph.setHTML("<small>Do not have an account?</small>");
        paragraph.addStyleName("text-muted text-center");
        userRegistrationForm.add(paragraph);

        login.setHref("#login");
        login.setText("Already have an account?");
        login.addStyleName("btn btn-sm btn-white btn-block");
        userRegistrationForm.add(login);

        RootPanel.get("registerForm").add(userRegistrationForm);
    }

    public static final RegisterPage getInstance() {

        if(instance==null)
            instance = new RegisterPage();

        return instance;
    }

    public void showRegisterPage() {

        Document.get().getElementById("landingPage").getStyle().setDisplay(Style.Display.NONE);
        Document.get().getElementById("login").getStyle().setDisplay(Style.Display.NONE);
        Document.get().getElementById("wrapper").getStyle().setDisplay(Style.Display.NONE);
        Document.get().getElementById("register").getStyle().setDisplay(Style.Display.BLOCK);

//        Document.get().getBody().removeClassName("landing-page");
//        Document.get().getBody().addClassName("gray-bg");
    }
}
