package eu.dnetlib.repo.manager.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.RootPanel;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.repo.manager.client.services.UserService;
import eu.dnetlib.repo.manager.client.services.UserServiceAsync;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.UserAccessException;

import java.util.logging.Level;
import java.util.logging.Logger;

import static com.google.gwt.query.client.GQuery.$;


public class RepositoryManager implements EntryPoint {

    public static UserProfile currentUser = null;
    public static String currentUserRole = null;

    public static String publicCaptchaKey = "";

    public static String currentToken = "landing";
    public static String previousToken = "landing";

    private UserServiceAsync userService = GWT.create(UserService.class);

    public void onModuleLoad() {

        GWT.setUncaughtExceptionHandler(new GWT.UncaughtExceptionHandler() {

            Logger logger = Logger.getLogger("UncaughtException");

            @Override
            public void onUncaughtException(Throwable arg0) {

                logger.log(Level.SEVERE, "Exception: ", arg0);
            }
        });

        History.addValueChangeHandler(new ValueChangeHandler<String>() {
            @Override
            public void onValueChange(ValueChangeEvent<String> event) {

                String historyToken = event.getValue();

                if(historyToken!=null && !historyToken.equals("")) {

                    String finalHistoryToken = getFinalHistoryToken(historyToken);

                    History.newItem(finalHistoryToken);
                    NavigationManager.getInstance().navigate(finalHistoryToken);

                } else {

                    //TODO kapou peftei se loop
                    History.newItem("landing");
                    NavigationManager.getInstance().navigate("landing");
                }
            }
        });

        String hash = Window.Location.getHash();
        String activationId = Window.Location.getParameter("activationId");
        final String hashValue = hash.substring(1);

        if(hashValue.startsWith("activateAccount")) {

            Cookies.removeCookie("currentUser");

            if(activationId!=null) {

                userService.activateUser(activationId, new AsyncCallback<Void>() {

                    @Override
                    public void onFailure(Throwable throwable) {

                        if(throwable instanceof UserAccessException) {
                            UserAccessException uae = (UserAccessException) throwable;
                            LoginPage.getInstance().showSuccessfulMessage(uae.getMessage());
                            Window.Location.replace(GWT.getHostPageBaseURL() + "#login");
                        } else {
                            //TODO
                        }
                    }

                    @Override
                    public void onSuccess(Void aVoid) {

                        //TODO it does not show the message because it refreshes the page
                        LoginPage.getInstance().showSuccessfulMessage("Account activation was successful! You can now log-in " +
                                "using your account details.");
                        Window.Location.replace(GWT.getHostPageBaseURL() + "#login");
//                        NavigationManager.getInstance().navigate("login");
//                        Window.Location.replace(GWT.getHostPageBaseURL() + "#login");
                    }
                });

            } else {

                //TODO invalid url
            }

        } else {

            String encryptedEmail = Cookies.getCookie("currentUser");
            if (encryptedEmail == null) {

                String finalHistoryToken = getFinalHistoryToken(hashValue);
                History.newItem(finalHistoryToken);
                NavigationManager.getInstance().navigate(finalHistoryToken);

            } else {

                userService.getUserByEmail(Crypto.decrypt(encryptedEmail), new AsyncCallback<Tuple<UserProfile, String>>() {

                    @Override
                    public void onFailure(Throwable caught) {

                        Cookies.removeCookie("currentUser");

                        String finalHistoryToken = getFinalHistoryToken(hashValue);
                        History.newItem(finalHistoryToken);
                        NavigationManager.getInstance().navigate(finalHistoryToken);
                    }

                    @Override
                    public void onSuccess(Tuple<UserProfile, String> result) {

                        RepositoryManager.currentUser = result.getFirst();
                        RepositoryManager.currentUserRole = result.getSecond();

                        if (RepositoryManager.currentUser != null)
                            Document.get().getElementById("currentUser").setInnerText(RepositoryManager.currentUser.getFirstname()
                                    + " " + RepositoryManager.currentUser.getLastname());

                        //TODO use role instead of email
                        if(RepositoryManager.currentUserRole.equals("admin")) {
                            Document.get().getElementById("adminMenuHeader").getStyle().setDisplay(Style.Display.BLOCK);
                            Document.get().getElementById("adminMenuHelpTexts").getStyle().setDisplay(Style.Display.BLOCK);
                            Document.get().getElementById("adminMenuMetrics").getStyle().setDisplay(Style.Display.BLOCK);

                            Document.get().getElementById("admin1").getStyle().setDisplay(Style.Display.BLOCK);
                        }

                        String finalHistoryToken = getFinalHistoryToken(hashValue);
                        History.newItem(finalHistoryToken);
                        NavigationManager.getInstance().navigate(finalHistoryToken);
                    }
                });
            }
        }

        addLogoutHandler();
    }

    private void addLogoutHandler() {

        $(".logoutLink").click(new Function() {

            public boolean f(Event e) {

                Cookies.removeCookie("currentUser");
                RepositoryManager.currentUser = null;
                RepositoryManager.currentUserRole = null;

                if(RepositoryManager.currentToken.equals("landing"))
                    NavigationManager.getInstance().navigate("landing");
                else
                    History.newItem("landing");

                return false;
            }
        });
    }

    private String getFinalHistoryToken(String historyToken) {

        if(RepositoryManager.currentUser==null) {

            if(!(historyToken.equals("landing") || historyToken.equals("login") || historyToken.equals("register"))) {
                historyToken = "landing";
            }

        } else if(!RepositoryManager.currentUserRole.equals("admin")) {
            if(historyToken.equals("admin/helpTexts") || historyToken.equals("admin/metrics")) {
                historyToken = "dashboard";
            }
        }

        return historyToken;
    }
}
