package eu.dnetlib.repo.manager.client.admin.metrics;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.query.client.Function;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.domain.data.PiwikInfo;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;

import java.util.ArrayList;
import java.util.List;

import static com.google.gwt.query.client.GQuery.$;

/**
 * Created by stefania on 10/18/17.
 */
public class MetricsAdminWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private FlowPanel metricsAdminBoxContent = new FlowPanel();

    private Alert errorAlert = new Alert();

    private static HelpServiceAsync helpService = GWT.create(HelpService.class);
    private static RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);

    private DateTimeFormat dtf = DateTimeFormat.getFormat("yyyy-MM-dd");

    public MetricsAdminWidget() {

        super();

        HTML title = new HTML("<h1 class=\"uk-article-title\">Metrics Admin</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        metricsAdminBoxContent.add(errorAlert);

        contentPanel.add(metricsAdminBoxContent);
    }

    @Override
    public void clear() {

        metricsAdminBoxContent.clear();
        errorAlert.setVisible(false);
        gridPanel.remove(helpPanel);
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        metricsAdminBoxContent.add(errorAlert);

        helpService.getHelpById(parentToken, new HelpCallback(helpPanel, gridPanel));

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving piwik sites info...</div>" +
                "<div class=\"whiteFilm\"></div>");
        metricsAdminBoxContent.addStyleName("loading-big");
        metricsAdminBoxContent.add(loadingWheel);

        repositoryService.getPiwikSitesForRepositories(new AsyncCallback<List<PiwikInfo>>() {

            @Override
            public void onFailure(Throwable caught) {

                metricsAdminBoxContent.removeStyleName("loading-big");
                metricsAdminBoxContent.remove(loadingWheel);

                errorAlert.setText("System error retrieving piwik sites info.");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(List<PiwikInfo> results) {

                metricsAdminBoxContent.removeStyleName("loading-big");
                metricsAdminBoxContent.remove(loadingWheel);

                if(results!=null) {
                    createPiwikSitesInfoList(results, metricsAdminBoxContent);
                } else {
                    errorAlert.setText("System error retrieving piwik sites info.");
                    errorAlert.setVisible(true);
                }
            }
        });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }

    private void addWidgetHandlers() {

        $(".validate").click(new Function() {

            public boolean f(Event e) {

                errorAlert.setVisible(false);

                String[] idParts = $(e).get(0).getId().split("#");
                List<String> repositoryIds = new ArrayList<String>();
                repositoryIds.add(idParts[0]);

                validatePiwikSites(repositoryIds);

                return true;
            }
        });
    }

    private void createPiwikSitesInfoList(List<PiwikInfo> results, FlowPanel piwikInfosPanel) {

        if(results.isEmpty()) {
            piwikInfosPanel.add(new HTML("There are no piwik sites available yet."));
        } else {

//                HTML datasourceTitle = new HTML();
//                datasourceTitle.setHTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\"" +
//                        "uk-scrollspy-class=\"\"><span>" + piwikInfo + "</span></h4>");
//                piwikInfosPanel.add(datasourceTitle);

            FlowPanel colPanel = new FlowPanel();
            colPanel.addStyleName("uk-width-1-1@m uk-first-column uk-margin-medium-bottom");
            piwikInfosPanel.add(colPanel);

            FlowPanel divPanel = new FlowPanel();
            divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");
            colPanel.add(divPanel);

            String content = "<table class=\"uk-table uk-table-striped uk-table-middle\" style=\"font-size: 12px\">" +
                    "<thead><tr><th class=\"uk-text-nowrap\">Repository</th><th class=\"uk-text-nowrap\">Piwik site</th>" +
                    "<th class=\"uk-text-nowrap\">Requested on</th><th class=\"uk-text-nowrap\">Requestor</th>" +
                    "<th class=\"uk-text-nowrap\">Validated</th>" +
                    "<th class=\"uk-text-nowrap\">Actions</th></tr></thead>";

            content += "<tbody>";

            for(PiwikInfo piwikInfo : results) {

                content += "<tr class=\"el-item\">" +
                        "";

                // REPOSITORY
                content += "<td class=\"uk-table-shrink\">";
                if(piwikInfo.getRepositoryName()!=null && !piwikInfo.getRepositoryName().trim().equals(""))
                    content += "<div class=\"el-title\">" + piwikInfo.getRepositoryName() + "</div>";
                else
                    content += "--";
                if(piwikInfo.getCountry()!=null && !piwikInfo.getCountry().trim().equals(""))
                    content += "<div class=\"el-title\">" + piwikInfo.getCountry() + "</div>";
                else
                    content += "--";
                if(piwikInfo.getRepositoryId()!=null && !piwikInfo.getRepositoryId().trim().equals(""))
                    content += "<div class=\"el-title\">(ID: " + piwikInfo.getRepositoryId() + ")</div>";
                else
                    content += "--";

                content += "</td>";

                // PIWIK SITE
                content += "<td class=\"uk-table-shrink\">";
                if(piwikInfo.getSiteId()!=null && !piwikInfo.getSiteId().trim().equals(""))
                    content += "<div class=\"el-title\">ID: " + piwikInfo.getSiteId() + "</div>";
                else
                    content += "--";
                if(piwikInfo.getAuthenticationToken()!=null && !piwikInfo.getAuthenticationToken().trim().equals(""))
                    content += "<div class=\"el-title\">Authentication token: " + piwikInfo.getAuthenticationToken() + "</div>";
                else
                    content += "--";
                content += "</td>";

                // REQUEST DATE
                if(piwikInfo.getCreationDate()!=null)
                    content += "<td class=\"uk-text-nowrap uk-table-shrink\"><div class=\"el-title\">" + dtf.format(piwikInfo.getCreationDate()) + "</div></td>";
                else
                    content += "<td class=\"uk-text-nowrap uk-table-shrink\"><div class=\"el-title\">--</div></td>";

                // REQUESTOR
                content += "<td class=\"uk-text-nowrap uk-table-shrink\">";
                if(piwikInfo.getRequestorName()!=null && !piwikInfo.getRequestorName().trim().equals(""))
                    content += "<div class=\"el-title\">" + piwikInfo.getRequestorName() + "</div>";
                else
                    content += "--";
                if(piwikInfo.getRequestorEmail()!=null && !piwikInfo.getRequestorEmail().trim().equals(""))
                    content += "<div class=\"el-title\">" + piwikInfo.getRequestorEmail() + "</div>";
                else
                    content += "--";
                content += "</td>";

                // APPROVED
                if(piwikInfo.isValidated()) {
                    content += "<td class=\"uk-text-nowrap uk-table-shrink\">";
                    content += "<div class=\"el-title\">YES</div>" ;
                    if(piwikInfo.getValidationDate()!=null)
                        content += "<div class=\"el-title\">on " + dtf.format(piwikInfo.getValidationDate()) + "</div>" ;
                    content += "</td>";
                }  else
                    content += "<td class=\"uk-text-nowrap uk-table-shrink\"><div class=\"el-title\">NO</div></td>";

                content += "<td class=\"uk-text-nowrap uk-table-shrink\">";

                // ACTIONS
                if(!piwikInfo.isValidated())
                    content += "<a href=\"javascript:;\" id=\"" + piwikInfo.getRepositoryId() + "#validate\" " +
                            "class=\"uk-button uk-button-primary validate\">Validate</button>";
                content += "</td>" +
                        "</tr>";
            }

            content += "</tbody></table>";

            HTML reposListHTML = new HTML();
            reposListHTML.setHTML(content);

            divPanel.add(reposListHTML);
        }

        addWidgetHandlers();
    }

    private void validatePiwikSites(final List<String> repositoryIds) {

        final Modal approvePiwikSitesConfirmationPopup = new Modal();
        approvePiwikSitesConfirmationPopup.setDataBackdrop(ModalBackdrop.STATIC);

        FlowPanel modalContent = new FlowPanel();

        HTML description = new HTML("<h2 class=\"uk-modal-title\">Approval Confirmation</h2>\n" +
                "<p>Are you sure you want to validate the selected piwik site(s)?</p>");
        modalContent.add(description);

        FlowPanel actionButtons = new FlowPanel();
        actionButtons.addStyleName("uk-text-right");
        modalContent.add(actionButtons);

        Button no = new Button("Cancel");
        no.setType(ButtonType.DEFAULT);
        no.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                approvePiwikSitesConfirmationPopup.hide();
                approvePiwikSitesConfirmationPopup.removeFromParent();
            }
        });
        actionButtons.add(no);

        Button yes = new Button("Yes, validate");
        yes.setType(ButtonType.PRIMARY);
        yes.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                approvePiwikSitesConfirmationPopup.hide();
                approvePiwikSitesConfirmationPopup.removeFromParent();

                final HTML loadingWheel = new HTML("<div class=\"loader-big\"></div><div class=\"whiteFilm\"></div>");
                metricsAdminBoxContent.addStyleName("loading-big");
                metricsAdminBoxContent.add(loadingWheel);

                repositoryService.markPiwikSiteAsValidated(repositoryIds.get(0), new AsyncCallback<Void>() {

                    @Override
                    public void onFailure(Throwable caught) {

                        metricsAdminBoxContent.removeStyleName("loading-big");
                        metricsAdminBoxContent.remove(loadingWheel);

                        errorAlert.setText("System error validating the specified piwik site(s)");
                        errorAlert.setVisible(true);
                    }

                    @Override
                    public void onSuccess(Void result) {

                        metricsAdminBoxContent.removeStyleName("loading-big");
                        metricsAdminBoxContent.remove(loadingWheel);

                        clear();
                        reload();

                        Window.scrollTo(0, 0);
                    }
                });
            }
        });
        actionButtons.add(yes);

        ModalBody modalBody = new ModalBody();
        modalBody.add(modalContent);
        approvePiwikSitesConfirmationPopup.add(modalBody);
        approvePiwikSitesConfirmationPopup.getElement().getChild(0).getChild(0).getChild(0).removeFromParent();

        approvePiwikSitesConfirmationPopup.show();
    }
}
