package eu.dnetlib.repo.manager.client.browsehistory;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.functionality.validator.JobResultEntry;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.ValidationService;
import eu.dnetlib.repo.manager.client.services.ValidationServiceAsync;
import org.apache.lucene.document.Field;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;
import org.gwtbootstrap3.client.ui.html.UnorderedList;

import java.util.ArrayList;
import java.util.List;

import static com.google.gwt.query.client.GQuery.$;

/**
 * Created by stefania on 4/4/16.
 */
public class ViewJobDetailsWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private HTML title = new HTML();
    private FlowPanel viewJobDetailsBoxContent = new FlowPanel();

    private Alert errorAlert = new Alert();

    private FlowPanel helpPanel = new FlowPanel();

    private StoredJob storedJob;

    private List<JobResultEntry> contentResults = new ArrayList<>();
    private List<JobResultEntry> usageResults = new ArrayList<>();

    private ValidationServiceAsync validationService = GWT.create(ValidationService.class);
    private static HelpServiceAsync helpService = GWT.create(HelpService.class);

    public ViewJobDetailsWidget() {

        super();


        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);
//        HTML title = new HTML("<h1 class=\"uk-article-title\">Validation results for</h1>");
//        title.addStyleName("uk-margin-medium-bottom");
//        contentPanel.add(title);

        contentPanel.add(viewJobDetailsBoxContent);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        viewJobDetailsBoxContent.add(errorAlert);
    }

    @Override
    public void clear() {
        viewJobDetailsBoxContent.clear();
        errorAlert.setVisible(false);
        gridPanel.remove(helpPanel);
        storedJob = null;
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");

        viewJobDetailsBoxContent.add(errorAlert);

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving job details...</div>" +
                "<div class=\"whiteFilm\"></div>");
        viewJobDetailsBoxContent.addStyleName("loading-big");
        viewJobDetailsBoxContent.add(loadingWheel);

        helpService.getHelpById(parentToken + "_viewJobDetails", new HelpCallback(helpPanel, gridPanel));

        validationService.getJobSummary(Integer.parseInt(restToken), "all", new AsyncCallback<StoredJob>() {

            @Override
            public void onFailure(Throwable caught) {

                viewJobDetailsBoxContent.removeStyleName("loading-big");
                viewJobDetailsBoxContent.remove(loadingWheel);

                errorAlert.setText("System error retrieving job details");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(StoredJob storedJob) {

                ViewJobDetailsWidget.this.storedJob = storedJob;

//                title.setHTML("<h1 class=\"uk-article-title\">Validation results for " + storedJob.getOfficialName() + "</h1>");
                title.setHTML("<h1 class=\"uk-article-title\">Validation results for</h1>");

                viewJobDetailsBoxContent.removeStyleName("loading-big");
                viewJobDetailsBoxContent.remove(loadingWheel);

                viewJobDetailsBoxContent.add(createGeneralInfoItem());
                viewJobDetailsBoxContent.add(createInfoTags());
                viewJobDetailsBoxContent.add(createUsageAndContentInfo());

                addHandlers();
            }
        });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }

    private FlowPanel createGeneralInfoItem() {

        FlowPanel generalInfoItem = new FlowPanel();

        String content = "<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\"" +
                "uk-scrollspy-class=\"\"><span>" + storedJob.getBaseUrl() + "</span></h4>" +
                "<div class=\"uk-margin-small\">by " + storedJob.getUserEmail() + "</div>";


        generalInfoItem.add(new HTML(content));
        return generalInfoItem;
    }

    private FlowPanel createInfoTags() {

        FlowPanel generalInfoTags = new FlowPanel();

        String content = "<hr class=\"uk-scrollspy-inview uk-animation-slide-bottom-small\" uk-scrollspy-class=\"\">" +
                "<div>" +
                "<span class=\"\">" + storedJob.getJobType() + "</span> | " +
                "<span class=\"\">" + storedJob.getGuidelinesShortName() + "</span> | " +
                "<span class=\"\">Validation set: " + storedJob.getValidationSet() + "</span>" +
                "</div>" +
                "<div>" +
                "<span class=\"\">Started: " + storedJob.getStarted() + "</span>, " +
                "<span class=\"\">Ended: " + storedJob.getEnded() + "</span>, " +
                "<span class=\"\">Duration: " + storedJob.getDuration() + "</span>" +
                "</div>" +
                "<div style=\"font-size: 120%\">" +
                "<span class=\"\">Records tested: " + storedJob.getRecordsTested() + "</span>" +
                "</div>" +
                "<div>" +
                "<span class=\"label label-primary uk-margin-right\">Score for content: " + storedJob.getContentJobScore() + "</span>" +
                "<span class=\"label label-primary\">Score for usage: " + storedJob.getUsageJobScore() + "</span>" +
                "</div>" +
                "<hr class=\"uk-scrollspy-inview uk-animation-slide-bottom-small\" uk-scrollspy-class=\"\">";

        generalInfoTags.add(new HTML(content));
        return generalInfoTags;
    }

    private FlowPanel createUsageAndContentInfo() {

        FlowPanel usageAndContentTabs = new FlowPanel();

        UnorderedList tabTitles = new UnorderedList();
        tabTitles.addStyleName("uk-margin el-nav uk-tab");

        final ListItem contentTab = new ListItem();
        final ListItem usageTab = new ListItem();

        final ListItem contentTabContent = new ListItem();
        final ListItem usageTabContent = new ListItem();

        contentTab.addStyleName("uk-active");
        Anchor contentTablLink = new Anchor("for Content");
        contentTablLink.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                contentTab.addStyleName("uk-active");
                usageTab.removeStyleName("uk-active");
                contentTabContent.addStyleName("uk-active");
                usageTabContent.removeStyleName("uk-active");
            }
        });
        contentTab.add(contentTablLink);
        tabTitles.add(contentTab);

        Anchor usageTabLink = new Anchor("for Usage");
        usageTabLink.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                usageTab.addStyleName("uk-active");
                contentTab.removeStyleName("uk-active");
                usageTabContent.addStyleName("uk-active");
                contentTabContent.removeStyleName("uk-active");
            }
        });
        usageTab.add(usageTabLink);
        tabTitles.add(usageTab);

        usageAndContentTabs.add(tabTitles);

        UnorderedList tabContent = new UnorderedList();
        tabContent.addStyleName("uk-switcher");

        contentTabContent.addStyleName("el-item uk-active");
        tabContent.add(contentTabContent);

        usageTabContent.addStyleName("el-item");
        tabContent.add(usageTabContent);

        usageAndContentTabs.add(tabContent);

        if(storedJob.getResultEntries()!=null) {
            for (JobResultEntry jobResultEntry : storedJob.getResultEntries()) {
                if (jobResultEntry.getType().equals("content"))
                    contentResults.add(jobResultEntry);
                else
                    usageResults.add(jobResultEntry);
            }
        }

        contentTabContent.add(rulesTable(contentResults));
        usageTabContent.add(rulesTable(usageResults));

        return usageAndContentTabs;
    }

    private FlowPanel rulesTable(List<JobResultEntry> jobResults) {

        FlowPanel contentRules = new FlowPanel();
        contentRules.addStyleName("uk-grid-margin uk-grid uk-grid-stack");

        FlowPanel colPanel = new FlowPanel();
        colPanel.addStyleName("uk-width-1-1@m uk-first-column");
        contentRules.add(colPanel);

        FlowPanel divPanel = new FlowPanel();
        divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");
        colPanel.add(divPanel);

        String content = "<table class=\"uk-table uk-table-striped uk-table-middle rules-table\">" +
                "<thead><tr><th>Rule Name</th><th class=\"uk-text-nowrap\">Rule Description</th>" +
                "<th class=\"uk-text-nowrap\">Rule Weight</th><th class=\"uk-text-nowrap\"># of records</th>" +
                "<th class=\"uk-text-nowrap\">Status</th></tr></thead>";

        content += "<tbody>";

        if(jobResults==null || jobResults.size()==0) {

            content += "<tr class=\"el-item\">" +
                    "<td colspan=\"10\"><div class=\"alert alert-warning\">No result entries found</div></td>" +
                    "</tr>";

        } else {

            for (int i=0; i<jobResults.size(); i++) {

                content += "<tr class=\"el-item\">" +
                        "<td class=\"uk-table-shrink\">" +
                        "<div class=\"el-title\">" + jobResults.get(i).getName() + "</div>" +
                        "</td>" +
                        "<td class=\"uk-table-shrink\">\n" +
                        "<div class=\"el-title\">" + jobResults.get(i).getDescription() + "</div>" +
                        "</td>" +
                        "<td class=\"uk-table-shrink\">\n" +
                        "<div class=\"el-title\">" + jobResults.get(i).getWeight() + "</div>" +
                        "</td>" +
                        "<td class=\"uk-table-shrink\">\n" +
                        "<div class=\"el-title\">" + jobResults.get(i).getSuccesses() + "</div>" +
                        "</td>" +
                        "<td class=\"uk-table-shrink\">\n";

                if (jobResults.get(i).isHasErrors() && jobResults.get(i).isMandatory()) {

                    content += "<span uk-icon=\"icon: close\" style=\"color: #cd242b\"></span>" +
                            "<a href=\"javascript:;\" class=\"errorlink viewErrors uk-display-block\" id=\"" + jobResults.get(i).getType() + "#" + i + "\"><span>View Errors</span></a>";
//                    content += "<img src=\"img/icon_colours-x.jpg\" alt=\"Error\" class=\"el-image uk-preserve-width\" width=\"20\">" +
//                            "<a href=\"javascript:;\" class=\"errorlink viewErrors uk-display-block\" id=\"" + jobResults.get(i).getType() + "#" + i + "\"><span>View Errors</span></a>";

                } else if (jobResults.get(i).isHasErrors() && !jobResults.get(i).isMandatory()) {

                    content += "<span uk-icon=\"icon: warning\" style=\"color: #e9d60d\"></span>" +
                            "<a href=\"javascript:;\" class=\"warninglink viewErrors uk-display-block\" id=\"" + jobResults.get(i).getType() + "#" + i + "\"><span>View Warnings</span></a>";
//                    content += "<img src=\"img/icon_colours-warning.jpg\" alt=\"Warning\" class=\"el-image uk-preserve-width\" width=\"20\">" +
//                            "<a href=\"javascript:;\" class=\"warninglink viewErrors uk-display-block\" id=\"" + jobResults.get(i).getType() + "#" + i + "\"><span>View Warnings</span></a>";

                } else
                    content += "<span uk-icon=\"icon: check\" style=\"color: #4b991f\"></span>" ;
//                    content += "<img src=\"img/icon_colours-check.jpg\" alt=\"Success\" class=\"el-image uk-preserve-width\" width=\"20\">";

                content += "</td>" +
                        "</tr>";
            }
        }

        content += "</tbody></table>";

        HTML contentRulesListHTML = new HTML();
        contentRulesListHTML.setHTML(content);

        divPanel.add(contentRulesListHTML);

        return contentRules;
    }

    private void addHandlers() {

        $(".viewErrors").click(new Function() {

            public boolean f(Event e) {

                String[] idParts = $(e).get(0).getId().split("#");
                String jobType = idParts[0];
                String index = idParts[1];

                JobResultEntry jobResultEntry;

                if(jobType.equals("content")) {
                    jobResultEntry = contentResults.get(Integer.parseInt(index));
                } else {
                    jobResultEntry = usageResults.get(Integer.parseInt(index));
                }

                openErrorModal(jobResultEntry);

                return true;
            }
        });
    }

    private void openErrorModal(JobResultEntry jobResultEntry) {

        final Modal errorsModal = new Modal();
        errorsModal.setDataBackdrop(ModalBackdrop.STATIC);

        FlowPanel modalContent = new FlowPanel();

        String content = "<h2 class=\"uk-modal-title\">Rule: " + jobResultEntry.getName() + "</h2>" +
                "<p>See the list of errors found for this specific rule</p>";

        for(String error : jobResultEntry.getErrors()) {
            content += "<a class=\"uk-display-block\" target=\"_blank\" href=\"" + storedJob.getBaseUrl() +
                    "?verb=GetRecord&metadataPrefix=oai_dc&identifier=" + error + "\">" + error + "</a>";
        }

        HTML contentHTML = new HTML(content);
        modalContent.add(contentHTML);

        FlowPanel actionButtons = new FlowPanel();
        actionButtons.addStyleName("uk-text-right");
        modalContent.add(actionButtons);

        Button no = new Button("Ok");
        no.setType(ButtonType.DEFAULT);
        no.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                errorsModal.hide();
                errorsModal.removeFromParent();
            }
        });
        actionButtons.add(no);

        ModalBody modalBody = new ModalBody();
        modalBody.add(modalContent);
        errorsModal.add(modalBody);
        errorsModal.getElement().getChild(0).getChild(0).getChild(0).removeFromParent();

        errorsModal.show();
    }
}
