package eu.dnetlib.repo.manager.client.datasources.register;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.TokenController;

/**
 * Created by stefania on 12/17/15.
 */
public class DatasourceRegisterController extends TokenController {

    private static DatasourceRegisterController instance = null;
    private SelectRepositoryTypeWidget selectRepositoryTypeWidget = SelectRepositoryTypeWidget.getInstance();

    public static DatasourceRegisterController getInstance() {
        if (instance == null)
            instance = new DatasourceRegisterController();

        return instance;
    }

    private DatasourceRegisterController() {
        this.subControllers.put("literature", LiteratureController.getInstance());
        this.subControllers.put("data", DataController.getInstance());
        this.subControllers.put("journal", JournalController.getInstance());
        this.subControllers.put("aggregator", AggregatorController.getInstance());
    }

    @Override
    public void showWidget(FlowPanel contentPanel, String parent, String rest) {

        if (rest == null)
            redrawWidget(contentPanel, selectRepositoryTypeWidget, parent, rest);
        else {
            super.showWidget(contentPanel, parent, rest);
        }
    }

    @Override
    public String[] getMenuPath(String parent, String rest) {
        return new String[] {"registerDatasource"};
    }
}
