package eu.dnetlib.repo.manager.client.datasources.register;

import com.google.gwt.query.client.Function;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.TokenController;
import eu.dnetlib.repo.manager.client.datasources.register.wizard.*;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardStepWidget;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardWidget;
import eu.dnetlib.repo.manager.shared.Constants;

import java.util.ArrayList;
import java.util.List;

import static com.google.gwt.query.client.GQuery.$;

/**
 * Created by stefania on 12/17/15.
 */
public class LiteratureController extends TokenController {

    private static LiteratureController instance = null;

    public static LiteratureController getInstance() {
        if (instance == null)
            instance = new LiteratureController();

        return instance;
    }

    @Override
    public void showWidget(FlowPanel contentPanel, String parent, String rest) {

        List<WizardStepWidget> stepWidgets = new ArrayList<WizardStepWidget>();

        SelectRepositoryStepWidget selectRepositoryStepWidget = new SelectRepositoryStepWidget("selectRepo", "Select repository", Constants.REPOSITORY_MODE_OPENDOAR);
        stepWidgets.add(selectRepositoryStepWidget);

        DatasourceBasicInfoStepWidget datasourceBasicInfoStepWidget = new DatasourceBasicInfoStepWidget("info", "Enter information", Constants.REPOSITORY_MODE_OPENDOAR);
        stepWidgets.add(datasourceBasicInfoStepWidget);

        DatasourceInterfacesStepWidget datasourceInterfacesStepWidget = new DatasourceInterfacesStepWidget("interfaces", "Add interfaces", Constants.REPOSITORY_MODE_OPENDOAR);
        stepWidgets.add(datasourceInterfacesStepWidget);

        DatasourceRegistrationCompleteStepWidget datasourceRegistrationCompleteStepWidget = new DatasourceRegistrationCompleteStepWidget("complete", "Finish", Constants.REPOSITORY_MODE_OPENDOAR);
        stepWidgets.add(datasourceRegistrationCompleteStepWidget);

        WizardWidget wizardWidget = new DatasourceRegistrationWizard(stepWidgets);
        redrawWidget(contentPanel, wizardWidget, parent, rest);
    }

//    @Override
//    public void drawHeader(String rest) {
//
//        RepositoryManager.pageHeader.add(new HTML("<div class=\"col-sm-9\"><h2>Register your literature repository</h2>" +
//                "<ol class=\"breadcrumb\"><li><a href=\"#dashboard\">Home</a></li><li class=\"active\"><strong>New DataSource " +
//                "Registration</strong></li></ol></div><div class=\"col-sm-3\"><div class=\"nav navbar-top-links navbar-right\">" +
//                "<button id=\"changeDatasourceType\" style=\"margin-top: 30px; margin-right: 20px\" type=\"button\" " +
//                "class=\"btn btn-w-m btn-white\">Start fresh</button></div></div>"));
//
//        $("#changeDatasourceType").click(new Function() {
//            public boolean f(Event e) {
//                History.newItem("registerDatasource");
//                return false;
//            }
//        });
//    }
}
