package eu.dnetlib.repo.manager.client.datasources.register;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import org.gwtbootstrap3.client.ui.Anchor;

/**
 * Created by stefania on 12/7/15.
 */
public class SelectRepositoryTypeWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private static SelectRepositoryTypeWidget instance = null;

    private String parentToken = "";
    private String restToken = "";

    private static HelpServiceAsync helpService = GWT.create(HelpService.class);

    private SelectRepositoryTypeWidget() {

        super();

        HTML title = new HTML("<h1 class=\"uk-article-title\">Register your datasource</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        contentPanel.add(new HTML(createRepositoryTypeLinks()));
    }

    public static final SelectRepositoryTypeWidget getInstance() {

        if(instance==null)
            instance = new SelectRepositoryTypeWidget();

        return instance;
    }

    @Override
    public void clear() {
        gridPanel.remove(helpPanel);
    }

    @Override
    public void reload() {
        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        helpService.getHelpById(parentToken, new HelpCallback(helpPanel, gridPanel));
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }

    private String createRepositoryTypeLinks() {

        String content = "";

        content += "<div class=\"uk-margin uk-grid repositoryTypeSelection\" uk-grid=\"\">\n" +
                "\t<div class=\"uk-width-expand@m uk-width-1-2@s uk-grid-item-match uk-first-column\">\n" +
                "    \t<div class=\"uk-text-center uk-card uk-card-default uk-card-hover uk-scrollspy-inview uk-animation-slide-top-medium\" uk-scrollspy-class=\"\" data-id=\"page#38\" style=\"\">\n" +
                "        \t<a href=\"#registerDatasource/literature\" class=\"el-link uk-position-cover uk-margin-remove-adjacent\"></a>\n" +
                "            <div class=\"uk-card-media-top\">\n" +
                "                <img src=\"img/Literature_repos_square.png\" class=\"el-image\" alt=\"\" style=\"width: 100%\">\n" +
                "            </div>        \n" +
                "            <div class=\"uk-card-body\">\n" +
                "                <h3 class=\"el-title uk-margin uk-card-title uk-margin-remove-adjacent uk-margin-small-bottom\">Make sure your repository is already registered in OpenDOAR, the authoritative directory of institutional and thematic OA repositories.</h3>\n" +
                "\t\t\t\t<div class=\"el-meta uk-margin uk-text-meta\"><a href=\"http://www.opendoar.org\" target=\"_blank\">List provided by <br>OpenDOAR<i class=\"fa fa-external-link\" style=\"margin-left:3px\"></i></a></div>\n" +
                "            </div>\n" +
                "\t\t</div>\n" +
                "\t</div>\n" +
                "\t\n" +
                "\t<div class=\"uk-width-expand@m uk-width-1-2@s uk-grid-item-match\">\n" +
                "    \t<div class=\"uk-margin uk-text-center uk-card uk-card-default uk-card-hover uk-scrollspy-inview uk-animation-slide-top-medium\" uk-scrollspy-class=\"\" data-id=\"page#40\" style=\"\">\n" +
                "        \t<a href=\"#registerDatasource/data\" class=\"el-link uk-position-cover uk-margin-remove-adjacent\"></a>\n" +
                "            <div class=\"uk-card-media-top\">\n" +
                "                <img src=\"img/Data_repos_sqare.png\" class=\"el-image\" alt=\"\" style=\"width: 100%\">\n" +
                "            </div>        \n" +
                "            <div class=\"uk-card-body\">\n" +
                "                <h3 class=\"el-title uk-margin uk-card-title uk-margin-remove-adjacent uk-margin-small-bottom\">Make sure your data repository is registered in Re3Data, the global registry of research data repositories from different academic disciplines. </h3>\n" +
                "\t\t\t\t<div class=\"el-meta uk-margin uk-text-meta\"><a href=\"http://www.re3data.org\" target=\"_blank\">List provided by <br>Re3data<i class=\"fa fa-external-link\" style=\"margin-left:3px\"></i></a></div>\n" +
                "            </div>\n" +
                "\t\t</div>\n" +
                "\t</div>\n" +
                "\t<div class=\"uk-width-expand@m uk-width-1-2@s uk-grid-item-match\">\n" +
                "    \t<div class=\"uk-margin uk-text-center uk-card uk-card-default uk-card-hover uk-scrollspy-inview uk-animation-slide-top-medium\" uk-scrollspy-class=\"\" data-id=\"page#42\" style=\"\">\n" +
                "        \t<a href=\"#registerDatasource/journal\" class=\"el-link uk-position-cover uk-margin-remove-adjacent\"></a>\n" +
                "            <div class=\"uk-card-media-top\">\n" +
                "            \t<img src=\"img/OAJournals_square.png\" class=\"el-image\" alt=\"\" style=\"width: 100%\">\n" +
                "            </div>        \n" +
                "            <div class=\"uk-card-body\">\n" +
                "                <h3 class=\"el-title uk-margin uk-card-title uk-margin-remove-adjacent uk-margin-small-bottom\">Make sure that your Open Access Journal is compatible with the OpenAIRE literature Guidelines.</h3>\n" +
                "\t\t\t\t<div class=\"el-meta uk-margin uk-text-meta\"><a href=\"https://www.openaire.eu/helpdesk/\" target=\"_blank\">For any questions please contact the OpenAIRE helpdesk.<i class=\"fa fa-external-link\" style=\"margin-left:3px\"></i></a></div>\n" +
                "            </div>\n" +
                "\t\t</div>\n" +
                "\t</div>\n" +
                "\t<div class=\"uk-width-expand@m uk-width-1-2@s uk-grid-item-match\">\n" +
                "    \t<div class=\"uk-margin uk-text-center uk-card uk-card-default uk-card-hover uk-scrollspy-inview uk-animation-slide-top-medium\" uk-scrollspy-class=\"\" data-id=\"page#44\" style=\"\">\n" +
                "        \t<a href=\"#registerDatasource/aggregator\" class=\"el-link uk-position-cover uk-margin-remove-adjacent\"></a>\n" +
                "            <div class=\"uk-card-media-top\">\n" +
                "            \t<img src=\"img/Icons_Aggregators_square.png\" class=\"el-image\" alt=\"\" style=\"width: 100%\">\n" +
                "            </div>        \n" +
                "            <div class=\"uk-card-body\">\n" +
                "                <h3 class=\"el-title uk-margin uk-card-title uk-margin-remove-adjacent uk-margin-small-bottom\">Make sure that your publications aggregator is compatible with the OpenAIRE literature Guidelines.</h3>\n" +
                "\t\t\t\t<div class=\"el-meta uk-margin uk-text-meta\"><a href=\"https://www.openaire.eu/helpdesk/\" target=\"_blank\">For any questions please contact the OpenAIRE helpdesk.<i class=\"fa fa-external-link\" style=\"margin-left:3px\"></i></a></div>\n" +
                "            </div>\n" +
                "\t\t</div>\n" +
                "\t</div>\n" +
                "</div>";

        return content;
    }
}
