package eu.dnetlib.repo.manager.client.datasources.register.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardStepWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.datasources.utils.RepositoryInformationFormWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.shared.DatasourceRegistrationState;
import eu.dnetlib.repo.manager.shared.DatasourceVocabularies;
import eu.dnetlib.repo.manager.shared.WizardState;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

/**
 * Created by stefania on 12/17/15.
 */
public class DatasourceBasicInfoStepWidget extends WizardStepWidget {

    private FlowPanel datasourceBasicInfoStepPanel = new FlowPanel();

    private Alert errorAlert = new Alert();

    private RepositoryInformationFormWidget repositoryInformationFormWidget;

    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);

    public DatasourceBasicInfoStepWidget(String id, String title, final String mode) {

        super(id, title, mode);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);

        datasourceBasicInfoStepPanel.add(errorAlert);

        datasourceBasicInfoStepPanel.addStyleName("animated fadeInRight stepContent");

        repositoryService.getDatasourceVocabularies(mode, new AsyncCallback<DatasourceVocabularies>() {

            @Override
            public void onFailure(Throwable caught) {

                errorAlert.setText("System error retrieving datasource vocabularies");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(DatasourceVocabularies datasourceVocabularies) {

                repositoryInformationFormWidget = new RepositoryInformationFormWidget(mode, datasourceVocabularies, false);
                datasourceBasicInfoStepPanel.add(repositoryInformationFormWidget.asWidget());
            }
        });
    }

    @Override
    public void clear() {

    }

    @Override
    public void updateState(WizardState wizardState) {

        DatasourceRegistrationState datasourceRegistrationState = (DatasourceRegistrationState) wizardState;

        Repository repository = repositoryInformationFormWidget.getRepository();
        repository.setRegisteredBy(RepositoryManager.currentUser.getEmail());

        datasourceRegistrationState.setRepository(repository);
    }

    @Override
    public void loadContent(WizardState wizardState) {

        DatasourceRegistrationState datasourceRegistrationState = (DatasourceRegistrationState) wizardState;

        if(datasourceRegistrationState.getRepository()!=null)
            repositoryInformationFormWidget.loadRepository(datasourceRegistrationState.getRepository());
    }

    @Override
    public void completeStep() {

        if(repositoryInformationFormWidget!=null && repositoryInformationFormWidget.getRepository()!=null) {

            if(getWizardStepCompletedListener()!=null)
                getWizardStepCompletedListener().setStepCompleted();
        }
    }

    @Override
    public Widget asWidget() {
        return datasourceBasicInfoStepPanel;
    }
}
