package eu.dnetlib.repo.manager.client.datasources.register.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardStepWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.datasources.utils.RepositoryInterfacesFormWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.shared.DatasourceRegistrationState;
import eu.dnetlib.repo.manager.shared.WizardState;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

import java.util.Map;

/**
 * Created by stefania on 12/17/15.
 */
public class DatasourceInterfacesStepWidget extends WizardStepWidget {

    private FlowPanel datasourceInterfacesStepPanel = new FlowPanel();

    private Alert errorAlert = new Alert();

    private RepositoryInterfacesFormWidget repositoryInterfacesFormWidget;

    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);

    public DatasourceInterfacesStepWidget(String id, String title, final String mode) {

        super(id, title, mode);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);

        datasourceInterfacesStepPanel.add(errorAlert);

        datasourceInterfacesStepPanel.addStyleName("animated fadeInRight stepContent");

        repositoryService.getCompatibilityClasses(mode, new AsyncCallback<Map<String, String>>() {

            @Override
            public void onFailure(Throwable caught) {

                errorAlert.setText("System error retrieving compatibility classes");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(Map<String, String> compatibilityClasses) {

                repositoryInterfacesFormWidget = new RepositoryInterfacesFormWidget(mode, false, compatibilityClasses, false);
                datasourceInterfacesStepPanel.add(repositoryInterfacesFormWidget.asWidget());
            }
        });
    }

    @Override
    public void clear() {

    }

    @Override
    public void updateState(WizardState wizardState) {

        DatasourceRegistrationState datasourceRegistrationState = (DatasourceRegistrationState) wizardState;

        if(datasourceRegistrationState.getRepository()!=null)
            datasourceRegistrationState.getRepository().setInterfaces(repositoryInterfacesFormWidget.getRepositoryInterfaces());
    }

    @Override
    public void loadContent(WizardState wizardState) {

        DatasourceRegistrationState datasourceRegistrationState = (DatasourceRegistrationState) wizardState;

        if(datasourceRegistrationState.getRepository()!=null && datasourceRegistrationState.getRepository().getInterfaces()!=null)
            repositoryInterfacesFormWidget.loadRepositoryInterfaces(datasourceRegistrationState.getRepository().getInterfaces(), datasourceRegistrationState.getRepository().getId());
    }

    @Override
    public void completeStep() {

        if(repositoryInterfacesFormWidget!=null && repositoryInterfacesFormWidget.getRepositoryInterfaces()!=null
                && !repositoryInterfacesFormWidget.getRepositoryInterfaces().isEmpty() && !repositoryInterfacesFormWidget.hasInvalid()) {

            if(getWizardStepCompletedListener()!=null)
                getWizardStepCompletedListener().setStepCompleted();
        }
    }

    @Override
    public Widget asWidget() {
        return datasourceInterfacesStepPanel;
    }
}
