package eu.dnetlib.repo.manager.client.datasources.register.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardStepWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.datasources.utils.SelectRepositoryWidget;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.shared.DatasourceRegistrationState;
import eu.dnetlib.repo.manager.shared.WizardState;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

import java.util.Map;

/**
 * Created by stefania on 12/17/15.
 */
public class SelectRepositoryStepWidget extends WizardStepWidget {

    private FlowPanel selectRepositoryStepPanel = new FlowPanel();

    private Alert errorAlert = new Alert();

    private SelectRepositoryWidget selectRepositoryWidget;

    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);

    public SelectRepositoryStepWidget(String id, String title, String mode) {

        super(id, title, mode);

        errorAlert.addStyleName("stepContent");
        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);

        selectRepositoryStepPanel.add(errorAlert);

        repositoryService.getCountries(new AsyncCallback<Map<String, String>>() {

            @Override
            public void onFailure(Throwable caught) {

                errorAlert.setText("System error retrieving countries");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(Map<String, String> countries) {

                selectRepositoryWidget = new SelectRepositoryWidget(countries, getMode());
                selectRepositoryStepPanel.add(selectRepositoryWidget.asWidget());
            }
        });
    }

    @Override
    public void clear() {

    }

    @Override
    public void updateState(WizardState wizardState) {

        DatasourceRegistrationState datasourceRegistrationState = (DatasourceRegistrationState) wizardState;

        datasourceRegistrationState.setSelectedRepositoryId(selectRepositoryWidget.getSelectedRepository().getId());
        datasourceRegistrationState.setRepository(selectRepositoryWidget.getSelectedRepository());

        datasourceRegistrationState.setMode(this.getMode());
    }

    @Override
    public void loadContent(WizardState wizardState) {

    }

    @Override
    public void completeStep() {

        if(selectRepositoryWidget!=null && selectRepositoryWidget.getSelectedRepository()!=null) {

            if(getWizardStepCompletedListener()!=null)
                getWizardStepCompletedListener().setStepCompleted();

        }
    }

    @Override
    public Widget asWidget() {
        return selectRepositoryStepPanel;
    }
}
