package eu.dnetlib.repo.manager.client.datasources.utils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.*;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.repo.manager.client.services.RepositoryService;
import eu.dnetlib.repo.manager.client.services.RepositoryServiceAsync;
import eu.dnetlib.repo.manager.client.services.ValidationService;
import eu.dnetlib.repo.manager.client.services.ValidationServiceAsync;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.client.widgets.TextBox;
import eu.dnetlib.repo.manager.client.widgets.ValueChangeEvent;
import eu.dnetlib.repo.manager.client.widgets.ValueChangeHandler;
import eu.dnetlib.repo.manager.shared.Constants;
import eu.dnetlib.repo.manager.shared.InterfaceInformation;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.RadioButton;
import org.gwtbootstrap3.client.ui.constants.*;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by stefania on 12/23/15.
 */
public class InterfaceFields implements IsWidget {

    private boolean isValid = true;

    private FlowPanel interfacePanel = new FlowPanel();
    private FlowPanel interfaceBoxPanel = new FlowPanel();
    private FlowPanel interfaceBoxContentPanel = new FlowPanel();
    private FlowPanel interfaceBoxTitlePanel = new FlowPanel();
    private HTML title = new HTML();

    private FlowPanel actionsPanel = new FlowPanel();

    private Anchor deleteIcon = new Anchor();
    private Anchor saveIcon = new Anchor();

    private Form interfaceForm = new Form();

    private Alert interfaceErrorAlert = new Alert();
    private Alert interfaceSuccessAlert = new Alert();

    private TextBox baseURL = new TextBox();
    private MyFormGroup baseURLFormGroup = new MyFormGroup(true, "Base OAI-PMH URL (*)", baseURL);

    private RadioButton addACustomValidationSetRadio = new RadioButton("validationSet", "or a custom one", false);
    private TextBox validationSetTextBox = new TextBox();
    private RadioButton chooseExistingValidationSetRadio = new RadioButton("validationSet", "Choose existing", false);
    private ListBox existingValidationSetsListBox = new ListBox();
    private Map<String, Integer> existingValidationSetsValuesMap = new HashMap<String, Integer>();

    private ListBox desiredCompatibilityLevelListBox = new ListBox();
    private MyFormGroup desiredCompatibilityLevelFormGroup = new MyFormGroup(false, "Desired Compatibility Level (*)", desiredCompatibilityLevelListBox);
    private Map<String, Integer> desiredCompatibilityValuesMap = new HashMap<String, Integer>();

    private HTML currentCompatibilityLevel = new HTML();

    private RepositoryInterface existingRepositoryInterface;
    private String repositoryId;

    private DeleteInterfaceListener deleteInterfaceListener;

    private ValidationServiceAsync validationService = GWT.create(ValidationService.class);
    private RepositoryServiceAsync repositoryService = GWT.create(RepositoryService.class);

    private String mode;
    private boolean isUpdate;

    public InterfaceFields(boolean hasSave, Map<String, String> compatibilityClasses, String mode, final boolean isUpdate) {

        this.mode = mode;
        this.isUpdate = isUpdate;

//        interfacePanel.addStyleName("col-md-6");
        interfacePanel.add(interfaceBoxPanel);

//        interfaceBoxPanel.addStyleName("ibox interface-box");
        interfaceBoxPanel.addStyleName("el-item uk-card uk-card-default uk-card-body uk-scrollspy-inview uk-animation-fade");
        interfaceBoxPanel.add(interfaceBoxTitlePanel);
        interfaceBoxPanel.add(interfaceBoxContentPanel);

//        interfaceBoxContentPanel.addStyleName("ibox-content");

//        interfaceBoxTitlePanel.addStyleName("ibox-title");
        interfaceBoxTitlePanel.add(title);
        interfaceBoxTitlePanel.add(actionsPanel);

        actionsPanel.addStyleName("interfaceActionsPanel");

        deleteIcon.setIcon(IconType.REMOVE);
        deleteIcon.setIconSize(IconSize.LARGE);
        deleteIcon.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                if(deleteInterfaceListener!=null)
                    deleteInterfaceListener.deleteInterface(isUpdate);
            }
        });

        saveIcon.setIcon(IconType.SAVE);
        saveIcon.setIconSize(IconSize.LARGE);
        saveIcon.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                saveInterface();
            }
        });

        if(hasSave)
            actionsPanel.add(saveIcon);
        actionsPanel.add(deleteIcon);

        interfaceSuccessAlert.setType(AlertType.SUCCESS);
        interfaceSuccessAlert.setDismissable(false);
        interfaceSuccessAlert.setVisible(false);
        interfaceBoxContentPanel.add(interfaceSuccessAlert);

        interfaceErrorAlert.setType(AlertType.DANGER);
        interfaceErrorAlert.setDismissable(false);
        interfaceErrorAlert.setVisible(false);
        interfaceBoxContentPanel.add(interfaceErrorAlert);

        interfaceBoxContentPanel.add(interfaceForm);

        desiredCompatibilityLevelListBox.addItem("-- none selected --", "noneSelected");
        int counter = 1;
        for(String compatibility : compatibilityClasses.keySet()) {
            desiredCompatibilityLevelListBox.addItem(compatibilityClasses.get(compatibility), compatibility);
            desiredCompatibilityValuesMap.put(compatibility, counter);
            counter++;
        }

        baseURL.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {

                baseURLFormGroup.setFormGroupValidationState(ValidationState.NONE);
                getInterfaceInformation(null);
            }
        });

        interfaceForm.add(baseURLFormGroup);

        FlowPanel customValidationRadioPanel = new FlowPanel();
        addACustomValidationSetRadio.setType(ButtonType.LINK);
        addACustomValidationSetRadio.addStyleName("validationSetRadio");
        addACustomValidationSetRadio.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                if(addACustomValidationSetRadio.getValue()) {
                    validationSetTextBox.setEnabled(true);
                    existingValidationSetsListBox.setEnabled(false);
                }
            }
        });
        addACustomValidationSetRadio.setEnabled(false);
        customValidationRadioPanel.add(addACustomValidationSetRadio);

        validationSetTextBox.setEnabled(false);

        FlowPanel chooseExistingValidationRadioPanel = new FlowPanel();
        chooseExistingValidationSetRadio.setValue(true);
        chooseExistingValidationSetRadio.setType(ButtonType.LINK);
        chooseExistingValidationSetRadio.addStyleName("validationSetRadio");
        chooseExistingValidationSetRadio.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                existingValidationSetsListBox.setEnabled(true);
                validationSetTextBox.setEnabled(false);
            }
        });
        chooseExistingValidationSetRadio.setEnabled(false);
        chooseExistingValidationRadioPanel.add(chooseExistingValidationSetRadio);

        existingValidationSetsListBox.addItem("-- none selected --", "noneSelected");
        existingValidationSetsListBox.setEnabled(false);

        interfaceForm.add(new MyFormGroup(false, "Validation Set", chooseExistingValidationRadioPanel, existingValidationSetsListBox,
                customValidationRadioPanel, validationSetTextBox));

        interfaceForm.add(desiredCompatibilityLevelFormGroup);

        currentCompatibilityLevel.setText("not available");
        interfaceForm.add(new MyFormGroup(false, "Current Compatibility Level", currentCompatibilityLevel));

        addValueChangeHandlersToFormFields();
    }

    @Override
    public Widget asWidget() {
        return interfacePanel;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public interface DeleteInterfaceListener {
        void deleteInterface(boolean checkForLastOne);
    }

    public void setDeleteInterfaceListener(DeleteInterfaceListener deleteInterfaceListener) {
        this.deleteInterfaceListener = deleteInterfaceListener;
    }

    public void loadRepositoryInterface(RepositoryInterface repositoryInterface, String repositoryId) {

        this.existingRepositoryInterface = repositoryInterface;
        this.repositoryId = repositoryId;

        if(repositoryInterface!=null) {

            if(!repositoryInterface.isRemovable()) {

                if(mode.equals(Constants.REPOSITORY_MODE_OPENDOAR))
                    title.setHTML("<h5>OpenDOAR Interface (non-removable)</h5>");
                else if(mode.equals(Constants.REPOSITORY_MODE_RE3DATA))
                    title.setHTML("<h5>Re3data Interface (non-removable)</h5>");

                actionsPanel.remove(deleteIcon);
            }

            baseURL.setValue(repositoryInterface.getBaseUrl());
            getInterfaceInformation(repositoryInterface.getAccessSet());


            if(repositoryInterface.getDesiredCompatibilityLevel()!=null && !repositoryInterface.getDesiredCompatibilityLevel().equalsIgnoreCase("UNKNOWN"))
                desiredCompatibilityLevelListBox.setSelectedIndex(desiredCompatibilityValuesMap.get(repositoryInterface.getDesiredCompatibilityLevel()));

            if(repositoryInterface.getComplianceName()!=null && !repositoryInterface.getComplianceName().isEmpty())
                currentCompatibilityLevel.setText(repositoryInterface.getComplianceName());
        }

        if(existingRepositoryInterface!=null && existingRepositoryInterface.getId()!=null) {
            baseURL.setEnabled(false);
            addACustomValidationSetRadio.setEnabled(false);
            chooseExistingValidationSetRadio.setEnabled(false);
            validationSetTextBox.setEnabled(false);
            existingValidationSetsListBox.setEnabled(false);
        }
    }

    private void saveInterface() {

        interfaceErrorAlert.setVisible(false);
        interfaceSuccessAlert.setVisible(false);

        RepositoryInterface repositoryInterface = getRepositoryInterface(false);
        if(repositoryInterface!=null && isValid) {

            final HTML loadingWheel = new HTML("<div class=\"loader-small\" style=\"text-align: center; padding-top: 35%; " +
                    "color: rgb(47, 64, 80); font-weight: bold;\">Saving interface information</div><div class=\"whiteFilm\"></div>");
            interfaceBoxContentPanel.addStyleName("loading");
            interfaceBoxContentPanel.add(loadingWheel);

            if (repositoryInterface.getId() == null) {

                repositoryService.insertInterface(repositoryInterface, repositoryId, mode, new AsyncCallback<RepositoryInterface>() {

                    @Override
                    public void onFailure(Throwable caught) {

                        interfaceBoxContentPanel.removeStyleName("loading");
                        interfaceBoxContentPanel.remove(loadingWheel);

                        interfaceErrorAlert.setText("System error saving interface information ");
                        interfaceErrorAlert.setVisible(true);
                    }

                    @Override
                    public void onSuccess(RepositoryInterface repositoryInterface) {

                        interfaceBoxContentPanel.removeStyleName("loading");
                        interfaceBoxContentPanel.remove(loadingWheel);

                        interfaceSuccessAlert.setText("Interface saved successfully");
                        interfaceSuccessAlert.setVisible(true);

                        existingRepositoryInterface.setId(repositoryInterface.getId());
                        desiredCompatibilityLevelListBox.setSelectedIndex(0);
                        currentCompatibilityLevel.setText(repositoryInterface.getComplianceName());

                        baseURL.setEnabled(false);
                        addACustomValidationSetRadio.setEnabled(false);
                        chooseExistingValidationSetRadio.setEnabled(false);
                        validationSetTextBox.setEnabled(false);
                        existingValidationSetsListBox.setEnabled(false);
                    }
                });

            } else {

                repositoryService.updateInterface(repositoryInterface, repositoryId, mode, new AsyncCallback<RepositoryInterface>() {

                    @Override
                    public void onFailure(Throwable caught) {

                        interfaceBoxContentPanel.removeStyleName("loading");
                        interfaceBoxContentPanel.remove(loadingWheel);

                        interfaceErrorAlert.setText("System error updating interface information ");
                        interfaceErrorAlert.setVisible(true);
                    }

                    @Override
                    public void onSuccess(RepositoryInterface repositoryInterface) {

                        interfaceBoxContentPanel.removeStyleName("loading");
                        interfaceBoxContentPanel.remove(loadingWheel);

                        interfaceSuccessAlert.setText("Interface updated successfully");
                        interfaceSuccessAlert.setVisible(true);

                        existingRepositoryInterface.setId(repositoryInterface.getId());

                        desiredCompatibilityLevelListBox.setSelectedIndex(0);
                        currentCompatibilityLevel.setText(repositoryInterface.getComplianceName());
                    }
                });
            }
        }
    }

    private void getInterfaceInformation(final String validationSet) {

        interfaceErrorAlert.setVisible(false);

        final HTML loadingWheel = new HTML("<div class=\"loader-small\" style=\"text-align: center; padding-top: 35%; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Fetching interface information</div><div class=\"whiteFilm\"></div>");
        interfaceBoxContentPanel.addStyleName("loading");
        interfaceBoxContentPanel.add(loadingWheel);

        validationService.getInterfaceInformation(baseURL.getValue(), new AsyncCallback<InterfaceInformation>() {

            @Override
            public void onFailure(Throwable caught) {

                interfaceBoxContentPanel.removeStyleName("loading");
                interfaceBoxContentPanel.remove(loadingWheel);

                interfaceErrorAlert.setText("System error fetching interface information ");
                interfaceErrorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(InterfaceInformation interfaceInformation) {

                interfaceBoxContentPanel.removeStyleName("loading");
                interfaceBoxContentPanel.remove(loadingWheel);

                if(interfaceInformation.isIdentified()) {

                    baseURLFormGroup.displayInlineSuccess("Identified");

                    if(existingRepositoryInterface==null || existingRepositoryInterface.getId()==null) {
                        chooseExistingValidationSetRadio.setEnabled(true);
                        addACustomValidationSetRadio.setEnabled(true);

                        if (chooseExistingValidationSetRadio.getValue())
                            existingValidationSetsListBox.setEnabled(true);
                        else
                            validationSetTextBox.setEnabled(true);
                    }

                    existingValidationSetsListBox.clear();
                    existingValidationSetsListBox.addItem("-- none selected --", "noneSelected");
                    int counter = 1;
                    for(String validationSet : interfaceInformation.getSets()) {
                        existingValidationSetsListBox.addItem(validationSet, validationSet);
                        existingValidationSetsValuesMap.put(validationSet, counter);
                        counter++;
                    }

                } else {
                    baseURLFormGroup.displayInlineError("Not Identified");
                }

                if(validationSet!=null) {

                    if (interfaceInformation.getSets().contains(validationSet)) {
                        existingValidationSetsListBox.setSelectedIndex(existingValidationSetsValuesMap.get(validationSet));
                    } else {

                        chooseExistingValidationSetRadio.setValue(false);
                        addACustomValidationSetRadio.setValue(true);
                        if(existingRepositoryInterface==null || existingRepositoryInterface.getId()==null) {
                            existingValidationSetsListBox.setEnabled(false);
                            validationSetTextBox.setEnabled(true);
                        }
                        validationSetTextBox.setValue(validationSet);
                    }
                }
            }
        });
    }

    public RepositoryInterface getRepositoryInterface(boolean forDeletion) {

        if(!forDeletion) {

            isValid = true;

            if (isEmpty()) {
                return null;
            }

            if (isComplete()) {

                if (existingRepositoryInterface == null) {
                    existingRepositoryInterface = new RepositoryInterface();
                }

                existingRepositoryInterface.setCompliance("UNKNOWN");

                existingRepositoryInterface.setBaseUrl(baseURL.getValue().trim());

                if (chooseExistingValidationSetRadio.getValue() && !existingValidationSetsListBox.getSelectedValue().equals("noneSelected"))
                    existingRepositoryInterface.setAccessSet(existingValidationSetsListBox.getSelectedValue());
                else if (addACustomValidationSetRadio.getValue() && validationSetTextBox.getValue() != null && !validationSetTextBox.getValue().trim().isEmpty())
                    existingRepositoryInterface.setAccessSet(validationSetTextBox.getValue().trim());
                else
                    existingRepositoryInterface.setAccessSet("");

                existingRepositoryInterface.setDesiredCompatibilityLevel(desiredCompatibilityLevelListBox.getSelectedValue());

                return existingRepositoryInterface;
            }

            isValid = false;
            return new RepositoryInterface();

        } else {

            if (isEmpty()) {
                return null;
            }

            return existingRepositoryInterface;
        }
    }

    private boolean isEmpty() {

        if(chooseExistingValidationSetRadio.getValue()) {

            if ((baseURL.getValue() == null || baseURL.getValue().trim().equals(""))
                    && existingValidationSetsListBox.getSelectedValue().equals("noneSelected")
                    && desiredCompatibilityLevelListBox.getSelectedValue().equals("noneSelected")) {
                return true;
            }

        } else {

            if ((baseURL.getValue() == null || baseURL.getValue().trim().equals(""))
                    && (validationSetTextBox.getValue() == null || validationSetTextBox.getValue().trim().equals(""))
                    && desiredCompatibilityLevelListBox.getSelectedValue().equals("noneSelected")) {
                return true;
            }
        }

        return false;
    }

    private boolean isComplete() {

        boolean isComplete = true;

        interfaceErrorAlert.setVisible(false);

        if(baseURL.getValue()==null || baseURL.getValue().trim().isEmpty()) {
            isComplete = false;
            baseURLFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(desiredCompatibilityLevelListBox.getSelectedValue().equals("noneSelected")) {
            isComplete = false;
            desiredCompatibilityLevelFormGroup.setFormGroupValidationState(ValidationState.ERROR);
        }

        if(!isComplete) {
            interfaceErrorAlert.setText("All fields marked with * are mandatory.");
            interfaceErrorAlert.setVisible(true);
        }

        return isComplete;
    }

    private void addValueChangeHandlersToFormFields() {

        baseURL.setValueChangeHandler(new ValueChangeHandler() {
            @Override
            public void handle(ValueChangeEvent valueChangeEvent) {
                baseURLFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });

        desiredCompatibilityLevelListBox.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                desiredCompatibilityLevelFormGroup.setFormGroupValidationState(ValidationState.NONE);
            }
        });
    }

    public boolean isValid() {
        return isValid;
    }
}
