package eu.dnetlib.repo.manager.client.enrichcontent;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.TokenController;

/**
 * Created by stefania on 3/16/17.
 */
public class BrowseEventsController extends TokenController {

    private EnrichContentWidget enrichContentWidget = new EnrichContentWidget();
    private SelectTopicWidget selectTopicWidget = new SelectTopicWidget();
    private ShowEventsWidget showEventsWidget = new ShowEventsWidget();

    private static BrowseEventsController instance = null;

    public static BrowseEventsController getInstance() {
        if (instance == null)
            instance = new BrowseEventsController();

        return instance;
    }

    @Override
    public void showWidget(FlowPanel contentPanel, String parent, String rest) {

        if (rest == null)
            redrawWidget(contentPanel, enrichContentWidget, parent, rest);
        else {
            if(rest.contains("/") && (rest.indexOf("/") < rest.length())) {
                redrawWidget(contentPanel, showEventsWidget, parent, rest);
            } else {
                redrawWidget(contentPanel, selectTopicWidget, parent, rest);
            }
        }
    }

//    @Override
//    public void drawHeader(String rest) {
//
//        RootPanel.get("pageHeader").addStyleName("row wrapper border-bottom white-bg page-heading");
//
//        if (rest == null) {
//            RepositoryManager.pageHeader.clear();
//            RepositoryManager.pageHeader.add(new HTML("<div class=\"col-sm-9\"><h2>Enrich Your Content - Browse Events</h2>" +
//                    "<ol class=\"breadcrumb\"><li><a href=\"#dashboard\">Home</a></li><li class=\"active\">" +
//                    "<strong>Enrich Content - Browse Events</strong></li></ol></div>"));
//        } else {
//            if(rest.contains("/")) {
//                String[] tokenSplit = rest.split("/", 2);
//                String dataSource = tokenSplit[0];
//                String topic = tokenSplit[1];
//                RepositoryManager.pageHeader.clear();
//                String header = "<div class=\"col-sm-9\"><h2>Events for " + topic + "</h2><ol class=\"breadcrumb\">" +
//                        "<li><a href=\"#dashboard\">Home</a></li><li><a href=\"#enrichContent/events\">Enrich Content - Browse Events</a></li>" +
//                        "<li><a href=\"#enrichContent/events/" + dataSource +"\">" + dataSource + "</a></li>" +
//                        "<li class=\"active\"><strong>" + topic + "</strong></li></ol></div>";
//                RepositoryManager.pageHeader.add(new HTML(header));
//            } else {
//                RepositoryManager.pageHeader.clear();
//                String header = "<div class=\"col-sm-9\"><h2>Topics for " + rest + "</h2><ol class=\"breadcrumb\">" +
//                        "<li><a href=\"#dashboard\">Home</a></li><li><a href=\"#enrichContent/events\">Enrich Content - Browse Events</a></li>" +
//                        "<li class=\"active\"><strong>" + rest + "</strong></li></ol></div>";
//                RepositoryManager.pageHeader.add(new HTML(header));
//            }
//        }
//    }

    @Override
    public String[] getMenuPath(String parent, String rest) {
        return new String[] {"events"};
    }
}
