package eu.dnetlib.repo.manager.client.enrichcontent;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.shared.broker.AdvQueryObject;
import eu.dnetlib.repo.manager.shared.broker.NotificationFrequency;
import eu.dnetlib.repo.manager.shared.broker.NotificationMode;
import eu.dnetlib.repo.manager.shared.broker.OpenaireSubscription;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.constants.AlertType;

/**
 * Created by stefania on 3/17/17.
 */
public class EventsSubscriptionForm implements IsWidget {

    private FlowPanel subscriptionFormPanel = new FlowPanel();

    private Alert errorLabel = new Alert();

    private Form subscriptionForm = new Form();
    private ListBox frequencyListBox = new ListBox();
    private MyFormGroup frequencyListFormGroup = new MyFormGroup(false, "Frequency (*)", frequencyListBox);
    private ListBox modeListBox = new ListBox();
    private MyFormGroup modeListFormGroup = new MyFormGroup(false, "Mode (*)", modeListBox);

    private AdvQueryObject advQueryObject;

    public EventsSubscriptionForm(AdvQueryObject advQueryObject) {

        this.advQueryObject = advQueryObject;

        errorLabel.setType(AlertType.DANGER);
        errorLabel.setVisible(false);
        errorLabel.setDismissable(false);
        subscriptionFormPanel.add(errorLabel);

        subscriptionFormPanel.add(new HTML("<h4 class=\"uk-h4\">" + this.advQueryObject.getDatasource() + "</h4>" +
                "<div class=\"uk-text uk-text-small uk-text-secondary\">" + this.advQueryObject.getTopic().replace("/", "  |  ") + "</div>"));

        subscriptionFormPanel.add(subscriptionForm);

        HTML userEmail = new HTML(RepositoryManager.currentUser.getEmail());
        MyFormGroup userEmailFormGroup = new MyFormGroup(false, "Email", userEmail);
        subscriptionForm.add(userEmailFormGroup);

        frequencyListBox.addItem("-- none selected --", "noneSelected");
        for(NotificationFrequency notificationFrequency : NotificationFrequency.values())
            frequencyListBox.addItem(notificationFrequency.name(), notificationFrequency.name());
        subscriptionForm.add(frequencyListFormGroup);

//        modeListBox.addItem("-- none selected --", "noneSelected");
//        for(NotificationMode notificationMode : NotificationMode.values())
//            modeListBox.addItem(notificationMode.name(), notificationMode.name());
//        subscriptionForm.add(modeListFormGroup);

        HTML options = new HTML();
        options.setHTML(generateOptionsContent());
        MyFormGroup optionsFormGroup = new MyFormGroup(false, "Options", options);
        subscriptionForm.add(optionsFormGroup);
    }

    @Override
    public Widget asWidget() {
        return subscriptionFormPanel;
    }

    public boolean validate() {

        errorLabel.setVisible(false);

        if(!frequencyListBox.getSelectedValue().equals("noneSelected"))
//                && !modeListBox.getSelectedValue().equals("noneSelected"))
            return true;
        else {
            errorLabel.setVisible(true);
            errorLabel.setText("All asterisk (*) fields are mandatory");
            return false;
        }
    }

    public OpenaireSubscription getOpenAIRESubscription() {

        OpenaireSubscription openaireSubscription = new OpenaireSubscription();

        openaireSubscription.setSubscriber(RepositoryManager.currentUser.getEmail());
        openaireSubscription.setFrequency(NotificationFrequency.valueOf(frequencyListBox.getSelectedValue()));
        openaireSubscription.setMode(NotificationMode.valueOf(modeListBox.getSelectedValue()));
        openaireSubscription.setQuery(advQueryObject);

        return openaireSubscription;
    }

    private String generateOptionsContent() {

        String optionsContent = "<table class=\"table table-bordered\">";

//        optionsContent += "<thead><tr><th>Name</th><th>Values</th></tr></thead>";
        optionsContent += "<tbody>";

//        if(advQueryObject.getDatasource()!=null && !advQueryObject.getDatasource().equals(""))
//            optionsContent += "<tr><td>Datasource</td><td>" + advQueryObject.getDatasource() + "</td></tr>";
//
//        if(advQueryObject.getTopic()!=null && !advQueryObject.getTopic().equals(""))
//            optionsContent += "<tr><td>Topic</td><td>" + advQueryObject.getTopic() + "</td></tr>";

        if(advQueryObject.getTrust()!=null)
            optionsContent += "<tr><td>Trust</td><td>[" + advQueryObject.getTrust().getMin() + ", " + advQueryObject.getTrust().getMax() + "]</td></tr>";

        if(advQueryObject.getTitles()!=null && !advQueryObject.getTitles().isEmpty()) {
            optionsContent += "<tr><td>Titles</td><td>";
            for(int i=0; i<advQueryObject.getTitles().size(); i++) {
                optionsContent += advQueryObject.getTitles().get(i);
                if(i!=advQueryObject.getTitles().size()-1)
                    optionsContent += "<br>";
            }
            optionsContent += "</td></tr>";
        }

        if(advQueryObject.getAuthors()!=null && !advQueryObject.getAuthors().isEmpty()) {
            optionsContent += "<tr><td>Authors</td><td>";
            for(int i=0; i<advQueryObject.getAuthors().size(); i++) {
                optionsContent += advQueryObject.getAuthors().get(i);
                if(i!=advQueryObject.getAuthors().size()-1)
                    optionsContent += "<br>";
            }
            optionsContent += "</td></tr>";
        }

        if(advQueryObject.getSubjects()!=null && !advQueryObject.getSubjects().isEmpty()) {
            optionsContent += "<tr><td>Subjects</td><td>";
            for(int i=0; i<advQueryObject.getSubjects().size(); i++) {
                optionsContent += advQueryObject.getSubjects().get(i);
                if(i!=advQueryObject.getSubjects().size()-1)
                    optionsContent += "<br>";
            }
            optionsContent += "</td></tr>";
        }

        optionsContent += "</tbody>";
        optionsContent += "</table>";

        return optionsContent;
    }
}
