package eu.dnetlib.repo.manager.client.enrichcontent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.BrokerService;
import eu.dnetlib.repo.manager.client.services.BrokerServiceAsync;
import eu.dnetlib.repo.manager.shared.Term;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.broker.BrowseEntry;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by stefania on 10/31/16.
 */
public class SelectTopicWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private HTML title = new HTML();
    private FlowPanel selectTopicBoxContent = new FlowPanel();

    private Alert errorAlert = new Alert();

    public static Map<String, Term> topicsVocabulary = new HashMap<>();

    private static HelpServiceAsync helpService = GWT.create(HelpService.class);
    private static BrokerServiceAsync brokerService = GWT.create(BrokerService.class);

    public SelectTopicWidget() {

        super();

        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        selectTopicBoxContent.add(errorAlert);

        contentPanel.add(selectTopicBoxContent);
    }

    @Override
    public void clear() {

        selectTopicBoxContent.clear();
        errorAlert.setVisible(false);
        gridPanel.remove(helpPanel);
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        selectTopicBoxContent.add(errorAlert);

        title.setHTML("<h1 class=\"uk-article-title\">Enrichments for " + restToken + "</h1>");

        helpService.getHelpById(parentToken + "_selectTopic", new HelpCallback(helpPanel, gridPanel));

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving topics...</div>" +
                "<div class=\"whiteFilm\"></div>");
        selectTopicBoxContent.addStyleName("loading-big");
        selectTopicBoxContent.add(loadingWheel);

        brokerService.getTopicsForDatasource(restToken, new AsyncCallback<List<BrowseEntry>>() {

            @Override
            public void onFailure(Throwable caught) {

                selectTopicBoxContent.removeStyleName("loading-big");
                selectTopicBoxContent.remove(loadingWheel);

                errorAlert.setText("System error retrieving topics for datasources.");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(final List<BrowseEntry> browseEntries) {

                brokerService.getDnetTopics(new AsyncCallback<Map<String, Term>>() {

                    @Override
                    public void onFailure(Throwable throwable) {

                        selectTopicBoxContent.removeStyleName("loading-big");
                        selectTopicBoxContent.remove(loadingWheel);

                        errorAlert.setText("System error retrieving topics vocabulary.");
                        errorAlert.setVisible(true);
                    }

                    @Override
                    public void onSuccess(Map<String, Term> stringTermMap) {

                        topicsVocabulary.putAll(stringTermMap);

                        selectTopicBoxContent.removeStyleName("loading-big");
                        selectTopicBoxContent.remove(loadingWheel);

                        final FlowPanel topicsList = new FlowPanel();
                        createTopicsList(browseEntries, topicsList);
                        selectTopicBoxContent.add(topicsList);
                    }
                });

            }
        });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }

    private void createTopicsList(List<BrowseEntry> browseEntries, FlowPanel topicsList) {

        topicsList.addStyleName("uk-grid-margin uk-grid uk-grid-stack repos-list");

        if(browseEntries.isEmpty()) {

            topicsList.add(new HTML("No topics were found for this datasource"));

        } else {

            List<BrowseEntry> enrichMoreEntries = new ArrayList<>();
            List<BrowseEntry> enrichMissingEntries = new ArrayList<>();

            for(BrowseEntry browseEntry : browseEntries) {
                if(browseEntry.getValue().startsWith("ENRICH/MORE"))
                    enrichMoreEntries.add(browseEntry);
                else if(browseEntry.getValue().startsWith("ENRICH/MISSING"))
                    enrichMissingEntries.add(browseEntry);
            }

            //COLUMN FOR ENRICH/MORE
            FlowPanel colPanel1 = new FlowPanel();
            colPanel1.addStyleName("uk-width-1-2@m uk-first-column");
            topicsList.add(colPanel1);

            colPanel1.add(createTopicGroupPanel(enrichMoreEntries, "More"));

            //COLUMN FOR ENRICH/MISSING
            FlowPanel colPanel2 = new FlowPanel();
            colPanel2.addStyleName("uk-width-1-2@m uk-first-column");
            topicsList.add(colPanel2);

            colPanel2.add(createTopicGroupPanel(enrichMissingEntries, "Missing"));


        }
    }

    private FlowPanel createTopicGroupPanel(List<BrowseEntry> browseEntries, String group) {

        long total = 0;

        FlowPanel divPanel = new FlowPanel();
        divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");

        String content = "<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\" " +
                "uk-scrollspy-class=\"\"><span>" + group + "</span></h4>";

        content += "<table class=\"uk-table uk-table-striped uk-table-middle\">" +
//                "<thead><tr><th>Related events that may potentially enrich " + restToken + " content</th>" +
                "<thead><tr><th>Events that may enrich " + restToken + " content</th>" +
                "<th class=\"uk-text-nowrap\"># of events</th>" +
                "</tr></thead>";

        content += "<tbody>";

        for(BrowseEntry browseEntry : browseEntries) {

            content += "<tr class=\"el-item\">" +
                    "<td class=\"uk-table-shrink uk-width-4-5\">\n" +
                    "<a href=\"#" + parentToken + "/" + restToken + "/" + browseEntry.getValue() + "\" class=\"el-link\">" +
                    browseEntry.getValue() + "</a>";

            if(this.topicsVocabulary.get(browseEntry.getValue())!=null)
                content +=   "<div class=\"uk-text uk-text-meta\">" + this.topicsVocabulary.get(browseEntry.getValue()).getEnglishName() + "</div>";

            content += "</td>" +
                    "<td class=\"uk-text-nowrap uk-table-shrink uk-width-1-5\">\n" +
                    "<div class=\"el-title\">" + browseEntry.getSize() + "</div>" +
                    "</td>" +
                    "</tr>";

            total += browseEntry.getSize();
        }

        content += "<tr class=\"el-item footers\">" +
                "<td class=\"uk-text-nowrap uk-table-shrink uk-width-4-5\">\n" +
                "<div class=\"el-title\">Total</div>" +
                "</td>" +
                "<td class=\"uk-text-nowrap uk-table-shrink uk-width-1-5\">\n" +
                "<div class=\"el-title\">" + total + "</div>" +
                "</td>" +
                "</tr>";

        content += "</tbody></table>";

        HTML reposListHTML = new HTML();
        reposListHTML.setHTML(content);

        divPanel.add(reposListHTML);

        return divPanel;
    }
}
