package eu.dnetlib.repo.manager.client.enrichcontent.advancedsearch;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.query.client.css.CSS;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.repo.manager.shared.broker.Range;
import org.gwtbootstrap3.client.shared.event.ShowEvent;
import org.gwtbootstrap3.client.shared.event.ShowHandler;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker;
import java.util.Date;

import static com.google.gwt.query.client.GQuery.$;

/**
 * Created by stefania on 11/2/16.
 */
public class DateRangePickerField implements IsWidget {

    private FlowPanel dateRangePickerPanel = new FlowPanel();

    private DatePicker from = new DatePicker();
    private DatePicker to = new DatePicker();

    private Anchor deleteIcon = new Anchor();

    private DeleteDateRangeListener deleteDateRangeListener;

    private DateTimeFormat dtf = DateTimeFormat.getFormat("yyyy-MM-dd");

    public DateRangePickerField() {

        from.setAutoClose(true);
        from.addStyleName("inlineBlock");
        from.addStyleName("fromDate");
        from.setHighlightToday(true);
        from.setShowTodayButton(true);
        from.setPlaceholder("From");
        from.addShowHandler(new ShowHandler() {
            @Override
            public void onShow(ShowEvent showEvent) {
                $(".datepicker-days").css(CSS.DISPLAY.with(Style.Display.BLOCK));
            }
        });

        to.setAutoClose(true);
        to.addStyleName("inlineBlock");
        to.addStyleName("toDate");
        to.setHighlightToday(true);
        to.setShowTodayButton(true);
        to.setPlaceholder("To");
        to.addShowHandler(new ShowHandler() {
            @Override
            public void onShow(ShowEvent showEvent) {
                $(".datepicker-days").css(CSS.DISPLAY.with(Style.Display.BLOCK));
            }
        });

        deleteIcon.setIcon(IconType.REMOVE);
        deleteIcon.addStyleName("inlineBlock");
        deleteIcon.addStyleName("deleteIcon");
        deleteIcon.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent clickEvent) {

                if(deleteDateRangeListener !=null)
                    deleteDateRangeListener.deleteKeyword();
            }
        });

        dateRangePickerPanel.add(from);
        dateRangePickerPanel.add(to);
        dateRangePickerPanel.add(deleteIcon);
    }

    @Override
    public Widget asWidget() {
        return dateRangePickerPanel;
    }

    public interface DeleteDateRangeListener {
        void deleteKeyword();
    }

    public void setDeleteDateRangeListener(DeleteDateRangeListener deleteDateRangeListener) {
        this.deleteDateRangeListener = deleteDateRangeListener;
    }

    public void clear() {
        from.setValue(new Date());
        to.setValue(new Date());
    }

    public void loadSelectedDateRange(Range selectedDateRange) {

        if(selectedDateRange !=null) {

            if(selectedDateRange.getMin()!=null || !selectedDateRange.getMin().trim().equals(""))
                from.setValue(dtf.parse(selectedDateRange.getMin()));

            if(selectedDateRange.getMax()!=null || !selectedDateRange.getMax().trim().equals(""))
                to.setValue(dtf.parse(selectedDateRange.getMax()));

        }
    }

    public Range getSelectedDateRange() {

        if(from.getValue()!=null && to.getValue()!=null) {

            Range selectedDateRange = new Range();
            selectedDateRange.setMin(dtf.format(from.getValue()));
            selectedDateRange.setMax(dtf.format(to.getValue()));

            return selectedDateRange;
        }

        return null;
    }
}
