package eu.dnetlib.repo.manager.client.enrichcontent.advancedsearch;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.shared.broker.AdvQueryObject;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.FormType;
import org.gwtbootstrap3.extras.slider.client.ui.Range;
import org.gwtbootstrap3.extras.slider.client.ui.RangeSlider;
import org.gwtbootstrap3.extras.slider.client.ui.base.FormatterCallback;

/**
 * Created by stefania on 11/1/16.
 */
public class EnrichContentAdvancedSearchForm implements IsWidget {

    private FlowPanel enrichContentAdvancedSearchFormPanel = new FlowPanel();

    private Alert enrichContentAdvancedSearchErrorAlert = new Alert();
    private Alert enrichContentAdvancedSearchSuccessAlert = new Alert();

    private Form enrichContentAdvancedSearchForm = new Form();

    private RangeSlider trustSlider = new RangeSlider(0.00, 1.00, new Range(0.00, 1.00));

    private MultiTextBoxFieldSet titles = new MultiTextBoxFieldSet("Title");
    private MultiTextBoxFieldSet authors = new MultiTextBoxFieldSet("Author");
    private MultiTextBoxFieldSet subjects = new MultiTextBoxFieldSet("Subject");

    private MultiDateRangePickerFieldSet dates = new MultiDateRangePickerFieldSet("Date");

    private FlowPanel actionButtons = new FlowPanel();
    private Button search = new Button("Apply");
    private Button clear = new Button("Clear");

    private AdvancedSearchFormSelectionListener advancedSearchFormSelectionListener;

    private String datasource;
    private String topic;

    public EnrichContentAdvancedSearchForm(String datasource, String topic) {

        this.datasource = datasource;
        this.topic = topic;

        enrichContentAdvancedSearchFormPanel.addStyleName("advancedSearchForm");

        enrichContentAdvancedSearchErrorAlert.setType(AlertType.DANGER);
        enrichContentAdvancedSearchErrorAlert.setVisible(false);
        enrichContentAdvancedSearchErrorAlert.setDismissable(false);
        enrichContentAdvancedSearchFormPanel.add(enrichContentAdvancedSearchErrorAlert);

        enrichContentAdvancedSearchSuccessAlert.setType(AlertType.SUCCESS);
        enrichContentAdvancedSearchSuccessAlert.setVisible(false);
        enrichContentAdvancedSearchSuccessAlert.setDismissable(false);
        enrichContentAdvancedSearchFormPanel.add(enrichContentAdvancedSearchSuccessAlert);

        enrichContentAdvancedSearchForm.addStyleName("uk-form-horizontal");
        enrichContentAdvancedSearchFormPanel.add(enrichContentAdvancedSearchForm);

        Form trustForm = new Form();
        trustForm.addStyleName("uk-form-horizontal");

        trustSlider.setEnabled(true);
        trustSlider.setStep(0.01);
//        trustSlider.addStyleName("trustSlider");

        trustSlider.setFormatter(new FormatterCallback<Range>() {
            @Override
            public String formatTooltip(final Range range) {
                return "Range: [" + range.getMinValue() + ", " + range.getMaxValue() + "]";
            }
        });

        trustForm.add(new MyFormGroup(false, "Trust", trustSlider.asWidget()));
        enrichContentAdvancedSearchForm.add(trustForm);

        enrichContentAdvancedSearchForm.add(titles);

        enrichContentAdvancedSearchForm.add(authors);

        enrichContentAdvancedSearchForm.add(subjects);

        enrichContentAdvancedSearchForm.add(dates);

        Form actionsForm = new Form();
        actionsForm.setType(FormType.HORIZONTAL);

        actionButtons.addStyleName("actionButtons");
        actionsForm.add(new MyFormGroup(false, null, actionButtons));

        search.setType(ButtonType.PRIMARY);
        search.addStyleName("advancedSearch");
        search.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                AdvQueryObject advQueryObject = createAdvancedQueryData();

                if(advancedSearchFormSelectionListener!=null)
                    advancedSearchFormSelectionListener.criteriaSelected(advQueryObject);
            }
        });
        actionButtons.add(search);

        clear.setType(ButtonType.DEFAULT);
        clear.addStyleName("clearCriteria");
        clear.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                clearSelections();

                if(advancedSearchFormSelectionListener!=null)
                    advancedSearchFormSelectionListener.criteriaCleared(createClearQueryData());
            }
        });
        actionButtons.add(clear);

        enrichContentAdvancedSearchForm.add(actionsForm);
    }


    @Override
    public Widget asWidget() {
        return enrichContentAdvancedSearchFormPanel;
    }

    public interface AdvancedSearchFormSelectionListener {

        void criteriaSelected(AdvQueryObject advQueryObject);
        void criteriaCleared(AdvQueryObject advQueryObject);
    }

    public void setAdvancedSearchFormSelectionListener(AdvancedSearchFormSelectionListener advancedSearchFormSelectionListener) {
        this.advancedSearchFormSelectionListener = advancedSearchFormSelectionListener;
    }

    private AdvQueryObject createAdvancedQueryData() {

        AdvQueryObject advQueryObject = new AdvQueryObject();

        advQueryObject.setDatasource(datasource);
        advQueryObject.setTopic(topic);

        Range trustSliderValue = trustSlider.getValue();
        advQueryObject.setTrust(new eu.dnetlib.repo.manager.shared.broker.Range(trustSliderValue.getMinValue()+"", trustSliderValue.getMaxValue()+""));

        advQueryObject.setTitles(titles.getValues());
        advQueryObject.setAuthors(authors.getValues());
        advQueryObject.setSubjects(subjects.getValues());

        advQueryObject.setDates(dates.getSelectedDateRanges());

        return advQueryObject;
    }

    private AdvQueryObject createClearQueryData() {

        AdvQueryObject advQueryObject = new AdvQueryObject();

        advQueryObject.setDatasource(datasource);
        advQueryObject.setTopic(topic);

        advQueryObject.setDates(dates.getSelectedDateRanges());

        return advQueryObject;
    }

    private void clearSelections() {

        trustSlider.setValue(new Range(0.00, 1.00));

        titles.clear();
        authors.clear();
        subjects.clear();

        dates.clear();
    }

}
