package eu.dnetlib.repo.manager.client.enrichcontent.advancedsearch;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.repo.manager.shared.broker.Range;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.constants.FormType;
import org.gwtbootstrap3.client.ui.constants.IconType;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by stefania on 11/2/16.
 */
public class MultiDateRangePickerFieldSet implements IsWidget {

    private FlowPanel dateRangePickersPanel = new FlowPanel();

    private Form multipleDateRangePickerForm = new Form();

    private FlowPanel multipleDateRangePickerPanel = new FlowPanel();
    private List<DateRangePickerField> dateRangePickerFieldsList = new ArrayList<DateRangePickerField>();

    private Anchor addMore = new Anchor();

    public MultiDateRangePickerFieldSet(String label) {

        dateRangePickersPanel.add(multipleDateRangePickerForm);

//        multipleDateRangePickerForm.setType(FormType.HORIZONTAL);
        multipleDateRangePickerForm.addStyleName("uk-form-horizontal");
        multipleDateRangePickerForm.add(new MyFormGroup(false, label, multipleDateRangePickerPanel));

        final DateRangePickerField dateRangePickerField = new DateRangePickerField();
        dateRangePickerFieldsList.add(dateRangePickerField);
        multipleDateRangePickerPanel.add(dateRangePickerField.asWidget());

        DateRangePickerField.DeleteDateRangeListener deleteDateRangeListener = new DateRangePickerField.DeleteDateRangeListener() {
            @Override
            public void deleteKeyword() {
                dateRangePickerFieldsList.remove(dateRangePickerField);
                multipleDateRangePickerPanel.remove(dateRangePickerField.asWidget());
            }
        };
        dateRangePickerField.setDeleteDateRangeListener(deleteDateRangeListener);

        addMore.setIcon(IconType.PLUS);
        addMore.setText("Add another");
        addMore.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent clickEvent) {

                final DateRangePickerField dateRangePickerField = new DateRangePickerField();
                dateRangePickerFieldsList.add(dateRangePickerField);
                multipleDateRangePickerPanel.insert(dateRangePickerField.asWidget(), multipleDateRangePickerPanel.getWidgetIndex(addMore));
                DateRangePickerField.DeleteDateRangeListener deleteDateRangeListener = new DateRangePickerField.DeleteDateRangeListener() {
                    @Override
                    public void deleteKeyword() {
                        dateRangePickerFieldsList.remove(dateRangePickerField);
                        multipleDateRangePickerPanel.remove(dateRangePickerField.asWidget());
                    }
                };
                dateRangePickerField.setDeleteDateRangeListener(deleteDateRangeListener);
            }
        });
        multipleDateRangePickerPanel.add(addMore);
    }

    @Override
    public Widget asWidget() {
        return dateRangePickersPanel;
    }

    public void clear() {

        multipleDateRangePickerPanel.clear();
        dateRangePickerFieldsList = new ArrayList<DateRangePickerField>();

        final DateRangePickerField dateRangePickerField = new DateRangePickerField();
        DateRangePickerField.DeleteDateRangeListener deleteDateRangeListener = new DateRangePickerField.DeleteDateRangeListener() {
            @Override
            public void deleteKeyword() {
                dateRangePickerFieldsList.remove(dateRangePickerField);
                multipleDateRangePickerPanel.remove(dateRangePickerField.asWidget());
            }
        };
        dateRangePickerField.setDeleteDateRangeListener(deleteDateRangeListener);

        dateRangePickerFieldsList.add(dateRangePickerField);
        multipleDateRangePickerPanel.add(dateRangePickerField.asWidget());
        multipleDateRangePickerPanel.add(addMore);
    }

    public void loadSelectedDateRanges(List<Range> selectedDateRanges) {

        if(selectedDateRanges !=null && !selectedDateRanges.isEmpty()) {
            multipleDateRangePickerPanel.clear();
            dateRangePickerFieldsList = new ArrayList<DateRangePickerField>();

            for (Range selectedDateRange : selectedDateRanges) {

                final DateRangePickerField dateRangePickerField = new DateRangePickerField();
                DateRangePickerField.DeleteDateRangeListener deleteDateRangeListener = new DateRangePickerField.DeleteDateRangeListener() {
                    @Override
                    public void deleteKeyword() {
                        dateRangePickerFieldsList.remove(dateRangePickerField);
                        multipleDateRangePickerPanel.remove(dateRangePickerField.asWidget());
                    }
                };
                dateRangePickerField.setDeleteDateRangeListener(deleteDateRangeListener);
                dateRangePickerField.loadSelectedDateRange(selectedDateRange);
                dateRangePickerFieldsList.add(dateRangePickerField);
                multipleDateRangePickerPanel.add(dateRangePickerField.asWidget());
            }
            multipleDateRangePickerPanel.add(addMore);

        } else {
            clear();
        }
    }

    public List<Range> getSelectedDateRanges() {

        List<Range> selectedDateRanges = new ArrayList<Range>();

        for(DateRangePickerField dateRangePickerField : dateRangePickerFieldsList) {

            Range selectedDateRange = dateRangePickerField.getSelectedDateRange();
            if(selectedDateRange!=null)
                selectedDateRanges.add(selectedDateRange);
        }

        return selectedDateRanges;
    }
}
