package eu.dnetlib.repo.manager.client.enrichcontent.advancedsearch;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.repo.manager.client.widgets.TextBox;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.constants.IconType;

/**
 * Created by stefania on 11/1/16.
 */
public class SingleTextBoxField implements IsWidget {

    private FlowPanel keywordPanel = new FlowPanel();

    private TextBox keyword = new TextBox();
    private Anchor deleteIcon = new Anchor();

    private DeleteKeywordListener deleteKeywordListener;

    public SingleTextBoxField() {

//        value.se(AlternateSize.XLARGE);
        keyword.addStyleName("inlineBlock");

        deleteIcon.setIcon(IconType.REMOVE);
        deleteIcon.addStyleName("inlineBlock");
        deleteIcon.addStyleName("deleteIcon");
        deleteIcon.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent clickEvent) {

                if(deleteKeywordListener !=null)
                    deleteKeywordListener.deleteKeyword();
            }
        });

        keywordPanel.add(keyword);
        keywordPanel.add(deleteIcon);
    }

    @Override
    public Widget asWidget() {
        return keywordPanel;
    }

    public interface DeleteKeywordListener {
        void deleteKeyword();
    }

    public void setDeleteKeywordListener(DeleteKeywordListener deleteKeywordListener) {
        this.deleteKeywordListener = deleteKeywordListener;
    }

    public void clear() {
        keyword.setValue("");
    }

    public void loadValue(String value) {
        if(value !=null)
            this.keyword.setValue(value);
    }

    public String getValue() {
        return keyword.getValue().trim().equals("") ? null : keyword.getValue().trim();
    }
}
